#!/bin/bash

export PATH=.:$PATH
export OUT_HOST_ROOT=.

declare -A zip_dic=([source_name]="targetfiles.zip" [target_name]="targetfiles.zip" [update_name]="update.zip")
declare -A def_dic=([source_dir]="v1" [target_dir]="v2")

default_expand_name="zip"
default_fota_type=""
multi_fota=1 # enable multifota by default
upgrade_method="DFOTA" # generate DFOTA upgrade package by default

quectel_logo()
{
    echo
    echo '* * * * * * * * * * * * * * * * * * * * * * * * *'
    echo '          ___                  _       _         '
    echo '         / _ \ _   _  ___  ___| |_ ___| |        '
    echo '        | | | | | | |/ _ \/ __| __/ _ \ |        '
    echo '        | |_| | |_| |  __/ (__| ||  __/ |        '
    echo '         \__\_\\__,_|\___|\___|\__\___|_|        '
    echo '                                                 '
    echo '* * * * * * * * * * * * * * * * * * * * * * * * *'
    echo
}

#add the latest info at array head
declare -a his_ver=(
"3.13 : When generating multifota firmware, the update .xml file in the MULTIFOTA directory will be parsed first"
"3.12 : Full upgrade supports upgrading specified partitions"
"3.11 : Platform differences can be identified during the process of making a differential package"
"3.10 : add quectel-anti-rollback-version file for anti-rollback"
"3.9 : add quectel-modem-version file for modem version matching"
"3.8 : add timeout while bsdiff take long time and cannot end, once timeout(300 sec),override it by source file"
"3.7 : support multifota in full-images fota function"
"3.6 : enable multi fota function by default"
"3.5 : add full image fota function"
"3.4 : update bsdiff  "
"3.3 : support multi fota function  "
"3.2 : support for modem compress fota  "
"3.1 : fix a bug that some system file have been delete when update modem files noly "
"3.0 : Add project version file to update.zip package"
"2.9 : support some special binary for bsdiff"
"2.8 : delete tcpdump and gdb APP"
"2.7 : support modem in rootfs.ubi"
"2.6 : Fix a Dir issue for ubi type"
"2.5 : Fix a block issue"
"2.4 : Fix the specific permission issue"
"2.3 : Fix a add and delete file issue "
"2.2 : modify some hardware link file property "
"2.1 : Add project list and check"
"2.0 : Add ubi file support"
"1.4 : Modify audio acdb file config overwrite upgrade"
"1.3 : Add version infomation in updater-script"
"1.2 : Set all update file permission with target files"
"1.1 : Fix a issue for fullota file, and delete retouch function for 2.0 baseline"
"1.0 : Initial version"
)

version()
{
    echo "Quectel FOTA Tools (SDX55-delta-gentools)"
    if [ "$1" = "-V" -o "$1" = "--history" ]
    then
        quectel_logo
        echo "   History"
        for i in ${!his_ver[@]}
        do
            echo "     v${his_ver[$i]}"
        done
    else
        echo -e "  Version\n     v${his_ver[0]}"
    fi
}

usage()
{
    quectel_logo
    echo "Usage: $0 [fota_type] [OPTION]"
    echo ""
    echo "fota_type: select firmwares that needs to be upgraded"
    echo "    m:[ modem ]"
    echo "    l:[ system ]"
    echo "    o:[ boot ]"
    echo "    a:[ system modem boot ]"
    echo "    mo:[ modem boot ]"
    echo "    om:[ modem boot ]"
    echo "    lo:[ system boot ]"
    echo "    ol:[ system boot ]"
    echo "    lm:[ system modem ]"
    echo "    ml:[ system modem ]"
    echo ""
    echo "OPTION:"
    echo "    --full-images: generate Full FOTA upgrade packge, generate Delta FOTA upgrade packge instead without this option."
    echo "    -v|--version: view the latest change"
    echo "    -V|--history: view all changes"
    echo "    -h|--help: view the help manual"
    echo ""
}

ARGS=$(getopt -o uvVh --long full-images,version,history,help -- "$@")
if [ $? != 0 ]; then
    echo "parse options failed..."
    exit 1
fi

eval set -- "${ARGS}"
#echo $ARGS

while true
do
    case "$1" in
        -u)
            multi_fota=1
            shift
            ;;
        --full-images)
            upgrade_method="FFOTA"
            shift 1
            ;;
        -v|--version|-V|--history)
            version $1
            shift
            exit 0
            ;;
        -h|--help)
            usage
            shift
            exit 0
            ;;
        --)
            shift
            break
            ;;
        *)
            echo "Parameter input errors !!!"
            usage
            exit -1
            ;;
    esac
done

# Optional arguements not in $@ anymore after getopt.
echo "args: $@"

if [ $# -lt 1 ];then
    echo "too few arguements..."
    usage
    exit -1
fi

if [ `echo $1 | wc -L` -gt 4 ]
then
    fota_type=${1%.*}
    expand_str=${1#*.}
elif [ ! -z $1 ]
then
    fota_type=$1
    expand_str=$default_expand_name
else
    fota_type=$default_fota_type
    expand_str=$default_expand_name
fi

ulimit -s unlimited

if [ $upgrade_method == "DFOTA" ];then
    ./ota_from_target_files -t $fota_type -m $expand_str -d MTD -u $multi_fota -i ./${def_dic["source_dir"]}/${zip_dic["source_name"]} ./${def_dic["target_dir"]}/${zip_dic["target_name"]} ${zip_dic["update_name"]}
elif [ $upgrade_method == "FFOTA" ];then
    ./ota_from_target_files -t $fota_type --full-images -d MTD -u $multi_fota ./${def_dic["target_dir"]}/${zip_dic["target_name"]} ${zip_dic["update_name"]}
fi

quectel_logo
$0 "-v"
