#!/usr/bin/env python
# coding=utf-8

import os
import json
import copy
import zipfile

clade_list = [
    "SYSTEM/firmware/image/modem.b_h",
    "SYSTEM/firmware/image/modem.b_l",
    "SYSTEM/firmware/image/modem.b_d",
]

clade2_list = [
    "SYSTEM/firmware/image/clade2uncomp.bin"
]

class QL_GLOBAL:
    def __init__(self):
        self.diff_seg = True
        self.diff_seg_clade2 = True
        self.src_ext = None
        self.dst_ext = None
        self.check_clade_equal()
        self.print_clade()

    def is_diff_seg(self):
        return self.diff_seg;

    def is_diff_seg_clade2(self):
        return self.diff_seg_clade2;

    def print_clade(self):
        if self.src_ext != None:
            if self.src_ext.has_key('tcm_ext'):
                print self.src_ext['tcm_ext']
            if self.src_ext.has_key('clade_ext'):
                print self.src_ext['clade_ext']
            if self.src_ext.has_key('clade2_ext'):
                print self.src_ext['clade2_ext']
        if self.dst_ext != None:
            if self.dst_ext.has_key('tcm_ext'):
                print self.dst_ext['tcm_ext']
            if self.dst_ext.has_key('clade_ext'):
                print self.dst_ext['clade_ext']
            if self.dst_ext.has_key('clade2_ext'):
                print self.dst_ext['clade2_ext']
        else:
            print "Clade None ...."

    def is_clade_temp_file(self,file_name):

        for one_file in clade_list:
            if file_name == one_file:
                return True
           
        return False

    def is_clade2_temp_file(self,file_name):

        for one_file in clade2_list:
            if file_name == one_file:
                return True
           
        return False

    def check_clade_equal(self):
        try:
            src_seg_info = zipfile.ZipFile('./v1/targetfiles.zip', 'r')
            dst_seg_info = zipfile.ZipFile('./v2/targetfiles.zip', 'r')

            src_content = json.loads(src_seg_info.read("SYSTEM/firmware/image/seg_info.txt"),encoding='utf-8')
            dst_content = json.loads(dst_seg_info.read("SYSTEM/firmware/image/seg_info.txt"),encoding='utf-8')

            src_seg_info.close()
            dst_seg_info.close()

            print "old : ",src_content
            print "new : ",dst_content
            
            if src_content.has_key('tcm_ext') and src_content.has_key('clade_ext') \
               and dst_content.has_key('tcm_ext') and dst_content.has_key('clade_ext') \
               and src_content['tcm_ext'] == dst_content['tcm_ext'] \
               and src_content['clade_ext'] == dst_content['clade_ext'] :
                print "seg_info equal!!!!!!!!!!"
                self.diff_seg = False
            else:
                self.diff_seg = True

            if src_content.has_key('clade2_ext') and dst_content.has_key('clade2_ext') \
               and src_content['clade2_ext'] == dst_content['clade2_ext'] :
                self.diff_seg_clade2 = False
            else:
                self.diff_seg_clade2 = True

            if self.diff_seg == False or self.diff_seg_clade2 == False:
                self.src_ext = src_content.copy()
                self.dst_ext = dst_content.copy()
        except:
            self.diff_seg = True
            self.diff_seg_clade2 = True
            pass


if __name__ == "__main__":
    qlg = QL_GLOBAL()
    print qlg.is_diff_seg()
    if qlg.is_diff_seg():
        print "iiTrue"
    else:
        print "iiFalse"
    qlg.print_clade()

