import os
import sys
import struct
import binascii
import zipfile
import shutil
import xml.dom.minidom
from xml.dom.minidom import parse
import pdb
import re

CRC_32_POLYNOMIAL        = 0x04c11db7
CRC_32_MSB_MASK          = 0x80000000
QUEC_IMAGE_HEADER_SIZE   = 4096

page_size = None
header_info = None
xml_programs = None
multi_fota_num = 0
tmp_hb_info_file = "/tmp/MULTIFOTA/hb_info_file.bin"
multi_fota_bin = "/tmp/MULTIFOTA/multifota.bin"

""" Header info struct"""
class Image_hader:
    def __inti__(self):
        self.filename = '';
        self.sequeue = 0;
        self.file_offset = 0;
        self.file_len = 0;
        self.nand_offset = 0;
        self.nand_len = 0;
        self.crc = 0;

class Header:
    def __init__(self):
        self.magic = '';
        self.header_crc = 0;
        self.body_crc = 0;
        self.image_num = 0;
        self.image_size = 0;
        self.module_id = '';
        self.module_version = '';
        self.reserved = '';
        self.image_list = [];

crc32_table = [  
  0x00000000,  0x04c11db7,  0x09823b6e,  0x0d4326d9,
  0x130476dc,  0x17c56b6b,  0x1a864db2,  0x1e475005,
  0x2608edb8,  0x22c9f00f,  0x2f8ad6d6,  0x2b4bcb61,
  0x350c9b64,  0x31cd86d3,  0x3c8ea00a,  0x384fbdbd,
  0x4c11db70,  0x48d0c6c7,  0x4593e01e,  0x4152fda9,
  0x5f15adac,  0x5bd4b01b,  0x569796c2,  0x52568b75,
  0x6a1936c8,  0x6ed82b7f,  0x639b0da6,  0x675a1011,
  0x791d4014,  0x7ddc5da3,  0x709f7b7a,  0x745e66cd,
  0x9823b6e0,  0x9ce2ab57,  0x91a18d8e,  0x95609039,
  0x8b27c03c,  0x8fe6dd8b,  0x82a5fb52,  0x8664e6e5,
  0xbe2b5b58,  0xbaea46ef,  0xb7a96036,  0xb3687d81,
  0xad2f2d84,  0xa9ee3033,  0xa4ad16ea,  0xa06c0b5d,
  0xd4326d90,  0xd0f37027,  0xddb056fe,  0xd9714b49,
  0xc7361b4c,  0xc3f706fb,  0xceb42022,  0xca753d95,
  0xf23a8028,  0xf6fb9d9f,  0xfbb8bb46,  0xff79a6f1,
  0xe13ef6f4,  0xe5ffeb43,  0xe8bccd9a,  0xec7dd02d,
  0x34867077,  0x30476dc0,  0x3d044b19,  0x39c556ae,
  0x278206ab,  0x23431b1c,  0x2e003dc5,  0x2ac12072,
  0x128e9dcf,  0x164f8078,  0x1b0ca6a1,  0x1fcdbb16,
  0x018aeb13,  0x054bf6a4,  0x0808d07d,  0x0cc9cdca,
  0x7897ab07,  0x7c56b6b0,  0x71159069,  0x75d48dde,
  0x6b93dddb,  0x6f52c06c,  0x6211e6b5,  0x66d0fb02,
  0x5e9f46bf,  0x5a5e5b08,  0x571d7dd1,  0x53dc6066,
  0x4d9b3063,  0x495a2dd4,  0x44190b0d,  0x40d816ba,
  0xaca5c697,  0xa864db20,  0xa527fdf9,  0xa1e6e04e,
  0xbfa1b04b,  0xbb60adfc,  0xb6238b25,  0xb2e29692,
  0x8aad2b2f,  0x8e6c3698,  0x832f1041,  0x87ee0df6,
  0x99a95df3,  0x9d684044,  0x902b669d,  0x94ea7b2a,
  0xe0b41de7,  0xe4750050,  0xe9362689,  0xedf73b3e,
  0xf3b06b3b,  0xf771768c,  0xfa325055,  0xfef34de2,
  0xc6bcf05f,  0xc27dede8,  0xcf3ecb31,  0xcbffd686,
  0xd5b88683,  0xd1799b34,  0xdc3abded,  0xd8fba05a,
  0x690ce0ee,  0x6dcdfd59,  0x608edb80,  0x644fc637,
  0x7a089632,  0x7ec98b85,  0x738aad5c,  0x774bb0eb,
  0x4f040d56,  0x4bc510e1,  0x46863638,  0x42472b8f,
  0x5c007b8a,  0x58c1663d,  0x558240e4,  0x51435d53,
  0x251d3b9e,  0x21dc2629,  0x2c9f00f0,  0x285e1d47,
  0x36194d42,  0x32d850f5,  0x3f9b762c,  0x3b5a6b9b,
  0x0315d626,  0x07d4cb91,  0x0a97ed48,  0x0e56f0ff,
  0x1011a0fa,  0x14d0bd4d,  0x19939b94,  0x1d528623,
  0xf12f560e,  0xf5ee4bb9,  0xf8ad6d60,  0xfc6c70d7,
  0xe22b20d2,  0xe6ea3d65,  0xeba91bbc,  0xef68060b,
  0xd727bbb6,  0xd3e6a601,  0xdea580d8,  0xda649d6f,
  0xc423cd6a,  0xc0e2d0dd,  0xcda1f604,  0xc960ebb3,
  0xbd3e8d7e,  0xb9ff90c9,  0xb4bcb610,  0xb07daba7,
  0xae3afba2,  0xaafbe615,  0xa7b8c0cc,  0xa379dd7b,
  0x9b3660c6,  0x9ff77d71,  0x92b45ba8,  0x9675461f,
  0x8832161a,  0x8cf30bad,  0x81b02d74,  0x857130c3,
  0x5d8a9099,  0x594b8d2e,  0x5408abf7,  0x50c9b640,
  0x4e8ee645,  0x4a4ffbf2,  0x470cdd2b,  0x43cdc09c,
  0x7b827d21,  0x7f436096,  0x7200464f,  0x76c15bf8,
  0x68860bfd,  0x6c47164a,  0x61043093,  0x65c52d24,
  0x119b4be9,  0x155a565e,  0x18197087,  0x1cd86d30,
  0x029f3d35,  0x065e2082,  0x0b1d065b,  0x0fdc1bec,
  0x3793a651,  0x3352bbe6,  0x3e119d3f,  0x3ad08088,
  0x2497d08d,  0x2056cd3a,  0x2d15ebe3,  0x29d4f654,
  0xc5a92679,  0xc1683bce,  0xcc2b1d17,  0xc8ea00a0,
  0xd6ad50a5,  0xd26c4d12,  0xdf2f6bcb,  0xdbee767c,
  0xe3a1cbc1,  0xe760d676,  0xea23f0af,  0xeee2ed18,
  0xf0a5bd1d,  0xf464a0aa,  0xf9278673,  0xfde69bc4,
  0x89b8fd09,  0x8d79e0be,  0x803ac667,  0x84fbdbd0,
  0x9abc8bd5,  0x9e7d9662,  0x933eb0bb,  0x97ffad0c,
  0xafb010b1,  0xab710d06,  0xa6322bdf,  0xa2f33668,
  0xbcb4666d,  0xb8757bda,  0xb5365d03,  0xb1f740b4 ]

def print_success_logo():
    print """
                                            __         _ 
                                           / _|       | |
     ___  _   _   ___  ___  ___  ___  ___ | |_  _   _ | |
    / __|| | | | / __|/ __|/ _ \/ __|/ __||  _|| | | || |
    \__ \| |_| || (__| (__|  __/\__ \\\__ \| |  | |_| || |_
    |___/ \__,_| \___|\___|\___||___/|___/|_|   \__,_||___|
     """

def crc_32_calc(buf_ptr):
    seed = 0
    buf_len = len(buf_ptr) * 8
    data = None
    crc = None

    print "crc_32_calc len:", buf_len
    # Generate the CRC by looking up the transformation in a table and
    # XOR-ing it into the CRC, one byte at a time.
    i = 0
    crc = seed
    while (buf_len >= 8):
        crc = crc32_table[ ( (( crc >> 24 ) & 0xffffffff) ^ ( ord(buf_ptr[i]) & 0xff ) ) ] ^ (( crc << 8 ) & 0xffffffff)
        buf_len -= 8
        i += 1

    # Finish calculating the CRC over the trailing data bits. This is done by
    # aligning the remaining data bits with the CRC MSB, and then computing the
    # CRC one bit at a time.
    if (buf_len != 0):
        print "####### crc_len!=0 ######"
        #Align data MSB with CRC MSB.
        data = (ord(buf_ptr)) << 24
        #While there are bits left, compute CRC one bit at a time.
        while (buf_len != 0):
            #If the MSB of the XOR combination of the data and CRC is one, then
            #advance the CRC register by one bit XOR with the CRC polynomial.
            #Otherwise, just advance the CRC by one bit.
            if (((crc ^ data) & CRC_32_MSB_MASK) != 0 ):
                crc <<= 1
                crc ^= CRC_32_POLYNOMIAL
            else:
                crc <<= 1
            buf_len -= 1

            #Advance to the next input data bit and continue.
            data <<= 1

    return (crc & 0xFFFFFFFF)

def get_pattern_file(s_zip, file_pattern):
    for file_name in s_zip.namelist():
        match_obj = re.search(file_pattern, file_name)
        if match_obj is not None:
            return file_name

    print("can't match {} in {}".format(file_pattern, dir))
    return None

def get_xml_file(s_zip, dir):
    xml_file = get_pattern_file(s_zip, dir.rstrip('/') + '/' + r'rawprogram_nand_.*_update\.xml')
    if xml_file is not None:
        return xml_file

    xml_file = get_pattern_file(s_zip, dir.rstrip('/') + '/' + r'rawprogram_nand_.*_factory\.xml')
    if xml_file is not None:
        return xml_file

    return None

def get_page_size(s_zip):
    xmlfile = s_zip.open(get_xml_file(s_zip, 'MULTIFOTA/'))
    DOMTree = xml.dom.minidom.parse(xmlfile)
    data = DOMTree.documentElement
    programs = data.getElementsByTagName("program")

    print "------------------- Now get page size ---------------------------------------"
    for program in programs:
        if program.hasAttribute("SECTOR_SIZE_IN_BYTES"):
            print "get page size: %s" % program.getAttribute("SECTOR_SIZE_IN_BYTES")
            self = program.getAttribute("SECTOR_SIZE_IN_BYTES")
            return self

""" Read xml file to get write address and page size"""
def parese_program_nand_xml(s_zip):
    print "------------------- Now read and  parese xml --------------------------------"
    xmlfile = s_zip.open(get_xml_file(s_zip, 'MULTIFOTA/'))
    DOMTree = xml.dom.minidom.parse(xmlfile)
    data = DOMTree.documentElement
    programs = data.getElementsByTagName("program")
    return programs

def header_info_init(header_info, multi_fota_flist):
    print "--------------------- Now init header info  ----------------------------------"
    global multi_fota_num
    global xml_programs
    multi_fota_bin_offset = QUEC_IMAGE_HEADER_SIZE
    for program in xml_programs:
        if program.hasAttribute("filename"):
            print "------------------- read a multi bin file  ----------------------------------"
            print "partition name: %s" % program.getAttribute("filename")[3:]
            if program.getAttribute("filename")[3:] in multi_fota_flist:
                """multi_fota_flist[multi_image.mbn]=N,mean v2/targetfiles.zip{MULTIFOTA/multi_image.mbn} does not exist"""
                if multi_fota_flist[program.getAttribute("filename")[3:]] == 'N':
                    continue
                image_info = Image_hader()
                image_info.filename = program.getAttribute("filename")[3:]
                image_info.file_len = os.path.getsize(image_info.filename)
                print "file size raw:", image_info.file_len, "\tfile offset raw:", multi_fota_bin_offset
                image_info.file_offset = int(multi_fota_bin_offset)/int(page_size)
                print "file offset :", image_info.file_offset, "\tpage"
 
		if program.hasAttribute("num_partition_sectors"):
                    print "sector size: %s" % program.getAttribute("num_partition_sectors")
                image_info.nand_len = int(program.getAttribute("num_partition_sectors"))

                if program.hasAttribute("SECTOR_SIZE_IN_BYTES"):
                    print "sector size: %s" % program.getAttribute("SECTOR_SIZE_IN_BYTES")
                
                if program.hasAttribute("start_sector"):
                    print "write address: %s" % program.getAttribute("start_sector")
                #image_info.nand_offset = int(program.getAttribute("start_sector"))*int(program.getAttribute("SECTOR_SIZE_IN_BYTES"))
                image_info.nand_offset = int(program.getAttribute("start_sector"))

                with open(image_info.filename) as f:
                    f_buf = f.read()
                    image_info.crc = crc_32_calc(f_buf)
                    f.close()
                print "crc: %s" % image_info.crc

                multi_fota_num += 1
                image_info.sequeue = multi_fota_num
                multi_fota_bin_offset += image_info.file_len

                header_info.image_list.append(image_info)
                del image_info

def print_multi_fota_table(header_info):
    print "Packed files:"
    print '{:-<131}'.format("-")
    for i in range(0, multi_fota_num, 1):
        print "| seq:",'{:<5}'.format(header_info.image_list[i].sequeue), "| filename:", header_info.image_list[i].filename.ljust(15), \
              "| file_offset:", '{:<10}'.format(header_info.image_list[i].file_offset), "| file_len:", '{:<10}'.format(header_info.image_list[i].file_len),\
              "| nand_offset", '{:<10}'.format(header_info.image_list[i].nand_offset), "| crc:", '{:<10}'.format(header_info.image_list[i].crc), "|"

    print '{:-<131}'.format("-")

""" Create out bin """
def create_dir(path):
    path = path.strip()
    path = path.rstrip("/")
    isExists = os.path.exists(path)

    if not isExists:
        os.makedirs(path)
        print 'mkdir ' + path + ' successful'
        return True
    else:
        print path + ' already exists!'
        return False

def create_multi_bin():
    if(os.path.exists(multi_fota_bin)):
        os.remove(multi_fota_bin)
        print multi_fota_bin + " exit, delete."
    file = open(multi_fota_bin, 'w')
    file.close()

def multi_bin_header_init(header_info):
    header_info.magic = "Quec"
    header_info.image_num = multi_fota_num
    #header_info.module_id = ''
    header_info.module_id = "RG500QEAR01A01M4G_HG_20190803A_factory"
    header_info.module_version = "RG500QEAR01A01M4G_HG_20190803A_factory"

def align_file_page(multi_fota_list, page_size):
    print "------------------- Now align file as page size -----------------------------"
    for i in multi_fota_list:
        print (i+':'+multi_fota_list[i])
        """multi_fota_flist[apdp.mbn]=N,mean v2/targetfiles.zip{MULTIFOTA/apdp.mbn} does not exist"""
        if multi_fota_list[i] == 'N':
            continue
        file_size = os.path.getsize(i)
        fill_byte = int(page_size) - int(file_size) % int(page_size)
        if(fill_byte == int(page_size)):
            print "file:", i, "\tnot need fill"
            continue
        print "fill file name:", i, "\tfile size:", file_size, "\tfill byte:", fill_byte
        with open(i,'ab+') as f:
            for i in range(0, fill_byte):
                tail_buf = struct.pack('<B', 0xFF)
                f.write(tail_buf)
            f.close()

def write_body_to_bin():
    with open(multi_fota_bin, 'wb') as f1:
        #f1.seek(4096)
        for i in range(0, multi_fota_num):
            with open(header_info.image_list[i].filename, 'rb') as f2:
                bin_content = f2.read()

            f1.write(bin_content)
            f2.close()
    	f1.close()

def write_header_to_bin(h_info):
    with open(multi_fota_bin, 'rb+') as f1:
        old_content = f1.read()
        with open(tmp_hb_info_file, 'rb+') as f2:
            hb_tmp = f2.read()
        f1.seek(0)
        f1.truncate() #clean file
        f1.write(h_info + hb_tmp)
        f1.seek(QUEC_IMAGE_HEADER_SIZE)
        f1.write(old_content)
        f2.close()
        f1.close()

def load_multi_fota_conf(multi_fota_conf_file, multi_fota_flist):
    with open(multi_fota_conf_file,'r') as f:
        r_line = f.readlines()
        for line in r_line:
            temp = line.strip('\n')
            if "#" in temp[0:1]:
                continue
            multi_fota_flist.setdefault(temp,'N')

def write_to_zip():
    """" wirte multi fota bin to zip """
    t_zip = zipfile.ZipFile('update.zip', "a", compression=zipfile.ZIP_DEFLATED)
    t_zip.write(multi_fota_bin, "MULTIFOTA/"+os.path.basename(multi_fota_bin))
    t_zip.close()

    shutil.rmtree("/tmp/MULTIFOTA")

def package(argv):
    global page_size
    global header_info
    global xml_programs
    global multi_fota_num
    global tmp_hb_info_file
    global multi_fota_bin
    """ This if from multi fota config file"""
    print "------------ Now get multi fota config file----------------------------------"
    multi_fota_flist = {}
    multi_fota_conf_file = "quectel_multifota_filelist.txt"

    header_info = Header()

    work_dir = os.getcwd()
    print os.getcwd()

    #multi_fota_flist = ["abl.elf", "aop.mbn", "devcfg.mbn", "hyp.mbn", "sbl1.mbn", "uefi.elf"]
    load_multi_fota_conf(multi_fota_conf_file, multi_fota_flist)

    """" extract some littel partition bin to tmpfs"""
    create_dir("/tmp/MULTIFOTA")
    s_zip = zipfile.ZipFile('v2/targetfiles.zip', "r")
    s_zip_namelist = s_zip.namelist()
    #print s_zip_namelist
    for name in multi_fota_flist:
        """"if file exis,then extract"""
        if "MULTIFOTA/"+name in s_zip_namelist:
            s_zip.extract("MULTIFOTA/"+name, "/tmp/")
            multi_fota_flist[name] = 'Y'

    print multi_fota_flist

    page_size = get_page_size(s_zip)
    xml_programs = parese_program_nand_xml(s_zip)

    os.chdir("/tmp/MULTIFOTA/")

    align_file_page(multi_fota_flist, page_size)

    header_info_init(header_info, multi_fota_flist)
    print_multi_fota_table(header_info)

    s_zip.close()

    create_multi_bin()
    write_body_to_bin()
    multi_bin_header_init(header_info)

    
    header_info.image_size = os.path.getsize(multi_fota_bin)
    print "image_body_size: ", header_info.image_size
    with open(multi_fota_bin) as f:
        f_buf = f.read()
        header_info.body_crc = crc_32_calc(f_buf)
        print "body crc:%x" % header_info.body_crc

    # calc header crc
    h_info = struct.pack('<I32s64s32sI', header_info.image_size, header_info.module_id[:31].ljust(32, '\0'), header_info.module_version[:63].ljust(64, '\0'), \
                    			header_info.reserved.ljust(32, '\0')[:32], header_info.image_num)
    print binascii.hexlify(h_info)
    header_info.header_crc = crc_32_calc(h_info)
    print "header crc:%x" % header_info.header_crc
    del h_info

    # pack header
    h_info = struct.pack('<4sIII32s64s32sI', header_info.magic.ljust(4, '\0')[:4], header_info.header_crc, header_info.body_crc, \
                    header_info.image_size, header_info.module_id[:31].ljust(32, '\0'), header_info.module_version[:63].ljust(64, '\0'), \
                    header_info.reserved.ljust(32, '\0')[:32], header_info.image_num)
    print binascii.hexlify(h_info)

    if(os.path.exists(tmp_hb_info_file)):
        os.remove(tmp_hb_info_file)
    for i in range(0, multi_fota_num, 1):
        with open(tmp_hb_info_file, 'ab+') as f_hb:
            hb_info = struct.pack('<IIIIII', header_info.image_list[i].sequeue, header_info.image_list[i].file_offset, \
                                        header_info.image_list[i].file_len, header_info.image_list[i].nand_offset, \
                                        header_info.image_list[i].nand_len, header_info.image_list[i].crc)
            f_hb.write(hb_info)
            print binascii.hexlify(hb_info)
            f_hb.close()

    write_header_to_bin(h_info)

    os.chdir(work_dir)
    
    #write_to_zip(multi_fota_bin)

    print_success_logo()
    print "----------- generate multi_fota.bin successful -------------------"

if __name__ == "__main__":
    package(sys.argv)
