#!/bin/bash
params=$@

# 0: disable
# 1: enable
LOG_ENABLE=1

function monitor_logd {
  PID=$1
  while : ; do
    sleep 10
    timeout 5 logger -p 7 "-"
    if [ $? -ne 0 ]; then # timeout
      kill -SIGKILL $PID
      wait $PID
      break
    elif [ ! -d /proc/$PID ]; then
      break
    fi
  done
}

if [ $LOG_ENABLE -eq 1 ]; then
  BIN=/sbin/logd
  while : ; do
    $BIN $params &
    monitor_logd $!
  done
else
  while : ; do cat; done
fi
