#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.


. /lib/functions.sh
. /lib/functions/network.sh
. /lib/netifd/netifd-proto.sh

logEnabled=$(uci get qcmap_lan.@logging[0].enabled)
logFileName=$(uci get qcmap_lan.@logging[0].filename)

function util_run_command() {
    local cmd="$1"  # First parameter: the command to run
    log  $(basename "$0") "util_run_command" $LINENO "$*"

    shift           # Shift the parameters to remove the first one (the command)

    # Execute the command with remaining arguments
    "$cmd" "$@"
}

log() {
    local fileName="$1"
    local functionName="$2"
    local lineNo="$3"
    local extraLog="$4"
    local logText="$(date "+%Y-%m-%d %H:%M:%S") [$fileName][$functionName][$lineNo] $extraLog"
    if [ "$logEnabled" == "1" ]; then
        echo "$logText" >> $logFileName
    fi
    logger -t "QCMAP" "$logText"
}

[ -z "$1" ] && echo "No event provided" && return 1
[ -z "$2" ] && echo "No profile number provided" && return 1

CFG=
CFG=$(uci show network | grep "profile='$2'" | awk -F'.' '{print $2}')
[ -z "$CFG" ] && {
    logger "No CFG found for the profile $2"
    exit 0
}

function ethpdu_up()
{
    [ -f /tmp/ethpduconfig$2 ] || sleep 1;
    [ -f /tmp/ethpduconfig$2 ] && . /tmp/ethpduconfig$2
    vlan_start=$VLAN_START
    vlan_end=$VLAN_END
    interface=$IFNAME
    ETH_MTU=$ETH_MTU
    log $(basename "$0") ":up():" $LINENO ":Add: vlan start:$vlan_start ,vlan end: $vlan_end ,ifname: $interface"
    EthDeviceIndex=$(uci get qcmap_lan.@eth_pdu[0].eth_device_index)

    #Configure VLAN INFO
    if [ $vlan_start -ne 0 ];then
        util_run_command uci set network.${interface}_bridgevlan=bridge-vlan
        util_run_command uci set network.${interface}_bridgevlan.vlan=$vlan_start
        util_run_command uci set network.${interface}_bridgevlan.vlan_end=$vlan_end
        util_run_command uci set network.${interface}_bridgevlan.device="br-lan"
        util_run_command uci set network.${interface}_bridgevlan.ports="eth$EthDeviceIndex:t $interface:t"
        #Save MTU
        #uci set network.@bridge-vlan[-1].mtu=$ETH_MTU
        echo $(basename "$0")":up:"$LINENO":configure vlan: $i"
    fi

    #attach device to interface
    util_run_command uci set network.wan"$2".device="$interface"
    #Add physical port to bridge
#   uci add_list network.@device[0].ports=$interface
    ifname_list=$(uci get network.lan.ifname)
    ifname_list="${ifname_list} $interface"
    util_run_command uci set network.lan.ifname="$ifname_list"
    #commit and reload
    util_run_command uci commit network

    #Save MTU, br-lan mtu will change accordingly
    util_run_command uci set network.eth.mtu=$ETH_MTU

    #save callinfo in qcmap_lan
    util_run_command uci add qcmap_lan EthPduCallInfo
    util_run_command uci set qcmap_lan.@EthPduCallInfo[-1].profile=$2
    util_run_command uci set qcmap_lan.@EthPduCallInfo[-1].EthPduIfName=$interface
    util_run_command uci commit qcmap_lan

    log $(basename "$0") ":up:" $LINENO ":notifying netifd!"
    util_run_command ubus call network.interface down "{ \"interface\" : \"$CFG\" }"
    util_run_command sleep 1
    util_run_command ubus call network.interface up "{ \"interface\" : \"$CFG\" }"

    util_run_command sleep 1
    echo $(basename "$0")":up:"$LINENO":network reloaded successfully!"
    util_run_command ubus call network reload
}

function ethpdu_down()
{
    # source the eth pdu config file
    [ -f /tmp/ethpduconfig$2 ] && . /tmp/ethpduconfig$2
    vlan_start=$VLAN_START
    vlan_end=$VLAN_END
    interface=$IFNAME
    log $(basename "$0") ":down():" $LINENO ":Delete:vlan start:$vlan_start ,vlan end: $vlan_end ,ifname: $interface"
    #Get total vlan number in network file
    util_run_command uci delete network.${interface}_bridgevlan

    #delete device rmnet_ethX from wanX interface
    util_run_command uci delete network.wan"$2".device
    #Delete physical port from bridge
#   uci del_list network.@device[0].ports=$interface
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$interface// | sed "s/ *$//g")
    util_run_command uci set network.lan.ifname="$ifname_list"
    #commit network
    util_run_command uci commit network

    #delete call info from qcmap_lan
    EthPduCallNum=$(grep EthPduCallInfo /etc/config/qcmap_lan | wc -l)
    log  $(basename "$0") ":down():" $LINENO ":total call info in qcmap_lan: $EthPduCallNum"
    for k in $(seq 0 $((EthPduCallNum-1)))
    do
        profileiHandle=$(uci get qcmap_lan.@EthPduCallInfo[$k].profile)
        if [ $2 -eq $profileiHandle ];then
            log $(basename "$0") ":down():" $LINENO ":delete call info from qcmap_lan:$profileiHandle in index:$k"
            util_run_command uci delete qcmap_lan.@EthPduCallInfo[$k]
            util_run_command uci commit qcmap_lan
            break
        fi
    done

    util_run_command ubus call network reload
    log $(basename "$0") ":down():" $LINENO ":network reload successfully!"
    util_run_command ifdown $CFG
}

case "$1" in
    up)
      ethpdu_up $1 $2
      ;;

    down)
      ethpdu_down $1 $2
    ;;

esac
exit 0
