#!/bin/sh
#  Copyright (c) 2021-2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

. /lib/functions.sh
. /lib/functions/network.sh
. /lib/netifd/netifd-proto.sh

[ -z "$1" ] && echo "No event provided" && return 1
[ -z "$2" ] && echo "No profile number provided" && return 1

CFG=
rmnet_find_cfg() {
	local cfg=$1
	local bh_type=$3
	local profile proto ipv6

	config_get proto   $cfg "proto"
	config_get profile $cfg "profile"
	config_get ipv6    $cfg "ipv6"

	if [ "$proto" = "rmnet" ] && [ "$profile" = "$2" ]; then
		if [ "$bh_type" = 2 -a  "$ipv6" = 1 ] || [ "$bh_type" = 1 -a "$ipv6" = 0 ]; then
			CFG=$cfg
			break
		fi
	fi
}

config_load network
config_foreach rmnet_find_cfg interface $2 $3
[ -z "$CFG" ] && {
	logger "No CFG found for the profile $2"
	exit 0
}
case "$1" in
	up)
		[ -f /tmp/ipv4config$2 -o -f /tmp/ipv6config$2 ] || sleep 1;
		ubus call network.interface down "{ \"interface\" : \"$CFG\" }"
		sleep 1
		ubus call network.interface up "{ \"interface\" : \"$CFG\" }"
		;;
	down)
		ifdown $CFG
		;;
esac
exit 0
