#! /bin/sh

#Copyright (c) 2023 Qualcomm Innovation Center, Inc. All rights reserved.
# SPDX-License-Identifier: BSD-3-Clause-Clear.

FILES=/sys/class/block/

create_symlinks_ab()
{
while [ 1 ]
do
     if [[ -d "$1" ]]; then
      echo "directory is exits"
       break
     else
      echo "waiting for directory to create"
     fi
done
cd $1
devices=$(ls)
for device in $devices;do

                        if [ "$(echo "$device" | grep "_b$")" ]; then
                                length=${#device}
                                if [ ${length} -le 2 ]; then
                                        exit
                                fi
                                partition="${device%_b}"
                                if [ -e "$partition" ] && [ ! -e "$partition_a" ]; then
                                        ln -s "$partition" "${partition}_a"
                                fi
                        fi
done

}

create_symlinks()
{
        for file in $FILES/$1*
        do
                blockname=`basename $file`
                if [  $1 == "mtd" ]; then
                        partition_name=`cat $file/device/name`
                else
                        partition_name=`cat $file/uevent | awk '{ for ( n=1; n<=NF; n++ ) if($n ~ "PARTNAME") print $n }' | awk '{split($0,a, "=");print a[2]}'`
                fi
                mkdir -p /dev/block/bootdevice/by-name/
                partition_name=/dev/block/bootdevice/by-name/$partition_name
                target_dev=/dev/$blockname
                ln -s $target_dev $partition_name
        done
}

if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
        create_symlinks mtd
else
        create_symlinks mmc
fi

create_symlinks_ab "/dev/block/bootdevice/by-name/"
