#! /bin/sh

# Copyright (c) 2023 Qualcomm Innovation Center, Inc. All rights reserved.
# SPDX-License-Identifier: BSD-3-Clause-Clear

FILES=/sys/class/block/

CURRENT_SLOT=$(abctl --boot_slot)
echo "Current running slot is :$CURRENT_SLOT" > /dev/kmsg

update_permission()
{
	#In case of MTD, change permissions for mtd block device
        if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
                mtd_block_number=`cat /proc/mtd | grep -i recoveryinfo | sed 's/^mtd//' | awk -F ':' '{print $1}'`
                chown root:disk /dev/mtd$mtd_block_number
                chmod 660 /dev/mtd$mtd_block_number
         else
		 while [ 1 ]
		 do
			if [ -d /dev/block/bootdevice/by-name ]; then
				if [ -b /dev/block/bootdevice/by-name/recoveryinfo ]; then
					chown root:disk /dev/block/bootdevice/by-name/recoveryinfo
					chmod 0660 /dev/block/bootdevice/by-name/recoveryinfo
					break
				else
					break
				fi
			else
				sleep 1
		        fi
		done
	fi
}

panic_on_fail=0

blockdevbyptname()
{
	partition=$1

	if [ -e /dev/block/bootdevice/by-name/$partition ];then
		blockdev=$(readlink /dev/block/bootdevice/by-name/$partition)
		echo "$blockdev"
		return 0
	fi
	echo ""
	return 1
}

mount_data_flag=false
data_format_flag=false

mtd_file=/proc/mtd
ubi_device_number=1
FindAndAttachUBI() {
   partition=$1
   num_volumes=$2

   mtd_block_number=`cat $mtd_file | grep -i "\b$partition\b" | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   if [ -z "$mtd_block_number" ]; then
      echo "MTD : Partition $partition not found" > /dev/kmsg
   else
      echo "MTD : Attaching UBI device /dev/mtdblock$mtd_block_number for $partition @$ubi_device_number" > /dev/kmsg

      ubiattach -m $mtd_block_number -d $ubi_device_number -b 10 /dev/ubi_ctrl
      count=100 # wait for the ubi-device node to be created for a max of (100 * 0.1 = ) 10 seconds
      while [ 1 ]; do
         if [ -c /dev/ubi${ubi_device_number} ]; then
            echo "/dev/ubi${ubi_device_number} created" > /dev/kmsg
            break
         else
            count=$(($count - 1))
            if [ $count -lt 1 ]; then
               echo "/dev/ubi${ubi_device_number} not yet created, rebooting" > /dev/kmsg
               #/sbin/reboot
               break
            else
               sleep 0.1
            fi
         fi
      done

      i=0
      while [ "$i" -lt "$num_volumes" ]; do
         count=50 # wait for the ubi volume node to be created, for max 5 seconds
         volume_node="/dev/ubi${ubi_device_number}_${i}"
         while [ 1 ]; do
            if [ -c $volume_node ]; then
               echo "$volume_node created, proceeding" > /dev/kmsg
               break
            else
               count=$(($count - 1))
               if [ $count -lt 1 ]; then
                  echo "$volume_node not yet created, rebooting .." > /dev/kmsg
                  #/sbin/reboot
                  break
               else
                  echo "$volume_node not yet created, checking again .." > /dev/kmsg
                  sleep 0.1
               fi
            fi
         done
         i=$(($i + 1))
      done
      ubi_device_number=$(($ubi_device_number + 1))
   fi

   ls -al /dev | grep -i "ubi" > /dev/kmsg
}

FindAndMountSquash () {
   volume=$1
   dir=$2
   ubidev=/dev/ubi1_0
   ubiblock_dev=/dev/ubiblock1_0

   if [ ! -d ${dir} ];then
      return 0
   fi

   if [ ! -e $ubiblock_dev ];then
      ubiblock -c $ubidev
   fi

   if [ -e $ubidev ];then
      volname=`/usr/sbin/ubinfo $ubidev | grep Name\: | awk '{print $2}'`
      if [ "$volname" == "$volume" ]; then
         echo "Found Volume: $volname" > /dev/kmsg
         mount -t squashfs $ubiblock_dev $dir -o noexec,nodev,ro
         echo "MTD : Mounting of $ubidev on $dir done" > /dev/kmsg
         break
      fi
   fi
}

FormatUBI() {
   partition=$1
   dir=$2
   ubinub=$3
   mtd_block_number=$4
   device=/dev/ubi${ubinub}
   
   ubidetach -p /dev/mtd$mtd_block_number
   sleep 1
   
   ubiformat /dev/mtd$mtd_block_number -y -v
   sleep 1
   
   ubiattach -m $mtd_block_number -d $ubinub /dev/ubi_ctrl
   sleep 1

   if [ -e $device ];then
      echo "ubiformat $partition success." > /dev/kmsg
   else
      echo "ubiformat $partition failed." > /dev/kmsg
      return 0
   fi

   ubimkvol /dev/ubi${ubinub} -m -N $partition
   sleep 1

   if [ -e ${device}_0  ];then
      echo "ubimkvol success." > /dev/kmsg
      sync
      return 1
   else
      echo "ubimkvol failed." > /dev/kmsg
      return 0
   fi   
}

GetMountResult() {
   partition=$1
   
   mountResult1=`mount | grep $partition`

   if [ "" = "$mountResult1" ]
   then
      echo "Mount $partition fail." > /dev/kmsg
      return 0
   else
      echo "Mount $partition success." > /dev/kmsg
      return 1
   fi
}

FindAndMountUsrdataUBI () {
   partition=$1
   dir=$2
   ubinub=$3
   QuecUsrdataFormatTimes=0
   Var1=0
   Var2=1
   ubiattach_time=0
   device=/dev/ubi${ubinub}_0

   mtd_block_number=`cat $mtd_file | grep -wi $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   echo "MTD : Detected block device : $dir for $partition" > /dev/kmsg
   mkdir -p $dir

   #attatch ubi
   ubiattach -m $mtd_block_number -d  $ubinub /dev/ubi_ctrl
   while [ 1 ]
   do
      if [ -e $device ]
      then
         break
      else
         sleep 0.1
         ubiattach_time=$((ubiattach_time+1))
         #echo "ubiattach wait times= $ubiattach_time"

         if [ "$ubiattach_time" -gt "20" ]
         then
            echo "ubiattach $partition failed. Start to format the $partition partition ..." > /dev/kmsg
            FormatUBI $partition $dir $ubinub $mtd_block_number
            if [ ! -e $device ] ;then
               echo "ubiattach $partition failed." > /dev/kmsg
               return 0
            fi
            break
         fi
      fi
   done

   #mount volume
   mounttimes=0
   while [ 1 ]
   do
      mount -t ubifs /dev/ubi${ubinub}_0 $dir -o bulk_read
      sleep 0.1
      GetMountResult $partition
      if [ $? -eq 1 ]
      then
         return 1
      fi

      mounttimes=$((mounttimes+1))
      if [ "$mounttimes" -gt "20" ]
      then
         echo "Mount failed, Start to format the $partition partition ..." > /dev/kmsg
         FormatUBI $partition $dir $ubinub $mtd_block_number
         if [ ! -e $device ] ;then
            echo "ubiattach $partition failed." > /dev/kmsg
            return 0
         fi
         sleep 1
         mount -t ubifs /dev/ubi${ubinub}_0 $dir -o bulk_read
         sleep 2
         GetMountResult $partition
         return $?
      fi
   done
}

checkMountResult() 
{
    local mountpoint="${1}"
    local mountResult=`mount | grep $mountpoint |grep "rw"`

    if [ "" = "$mountResult" ];then
        echo "$mountpoint mount failure !!!!" > /dev/kmsg
        return 1
    else
        echo "$mountpoint mount success !!!!" > /dev/kmsg
        return 0
    fi
}

mount_bind_usrdata_ubi(){
   part_name=$1
   
   eval FindAndMountUsrdataUBI usrdata /$part_name 2
   if [ "$?" == "1" ]
   then
      mkdir -p /$part_name/etc
      mkdir -p /$part_name/data
      mkdir -p /$part_name/cache
      # Default storage path of the upgrade package
      mkdir -p /$part_name/cache/ufs
      mkdir -p /$part_name/systemrw
      mkdir -p /$part_name/persist
      mkdir -p /var/volatile/tmp
      
      if [ ! -f /usrdata/bind_flag ];then
         cp -a /etc/* /$part_name/etc/
         cp -a /data/* /$part_name/data/

         if [ -d /usrdata/cfg_bak/ ];then
            cp -rf /usrdata/cfg_bak/* /usrdata/
            rm -rf /usrdata/cfg_bak/
         fi

         sync;sync
         sleep 1
         touch /usrdata/bind_flag
         sync
      fi

      mount --bind /$part_name/etc/  /etc
      mount --bind /$part_name/data/  /data
      mount --bind /$part_name/cache/  /cache
      mount --bind /$part_name/systemrw/  /systemrw
      mount --bind /$part_name/persist/  /persist
      mkdir -p /cache/ufs
   fi
}

## quectel-20230425, auto-mount data partiton for ext4 format
mount_data_ext4()
{
	fscktool=/usr/sbin/fsck.ext4                                         
	mkfstool=/usr/sbin/mkfs.ext4
	partition=$1
	mountpoint=$2
	extopt=$3

	blkdev=$(blockdevbyptname $partition)
	mount_data_flag=false
	data_format_flag=false
	mkdir -p $mountpoint
	if [ -e $blkdev ] && [ -d $mountpoint ];then
		echo "$fscktool $blkdev"
		/usr/sbin/fsck.ext4 -p  $blkdev > /dev/kmsg
		rcode=$?
		if [ ! $rcode -eq 0 ] && [ ! $rcode -eq 1 ] ;then
			echo "mount_data_ext4: fsck failed rcode=$rcode, try to format the partition[$blkdev]" > /dev/kmsg
			$mkfstool $blkdev
			data_format_flag=true
			sleep 1
		fi
		mount -t ext4  $blkdev $mountpoint
		if [ $? -eq 0 ];then
			echo "Mount $blkdev on $mountpoint successfully!" > /dev/kmsg
			mount_data_flag=true
			return 0
		else
			echo "Mount $blkdev on $mountpoint failed!" > /dev/kmsg
			return 1
		fi
	fi

	echo "mount_data_ext4: mount $blkdev failed!!!" > /dev/kmsg
}
## quectel-20230425, auto-mount data partiton for ext4 format

## quectel-20230426, mount-bind for usrdata
mount_bind_usrdata()
{
	usrdatapath=$1
	bind_flag=$usrdatapath/bind_flag

	mkdir -p $usrdatapath/data
	mkdir -p $usrdatapath/persist
	mkdir -p $usrdatapath/systemrw
	mkdir -p $usrdatapath/cache/ufs

	if [ ! -f $bind_flag ];then
		cp -Rdp /data/* $usrdatapath/data
		sync;sync
		sleep 1
                echo "bind_flag flag does not exist, backup /usrdata/cfg_bak_data" > /dev/kmsg
                cp -rf /usrdata/cfg_bak_data/* /usrdata/
		#touch $bind_flag
		sync
	fi

	mount --bind $usrdatapath/data /data
	#mount --bind $usrdatapath/persist /persist
	#add by John.lin 20240409,Add the systemrw directory for create wifi soft link file
	mount --bind $usrdatapath/systemrw /systemrw
	#mount --bind $usrdatapath/cache /cache
	mkdir -p /cache/ufs
	mount --bind $usrdatapath/cache/ufs /cache/ufs

	#detele fota download tmpfile.
	if [ -f /cache/ufs/ipth_package.bin.dd ];then
		rm -f /cache/ufs/ipth_package.bin.dd
	fi

        if [ -f /usrdata/.overlay_clr_flag ];then
                rm -rf /overlay/etc-upper
                rm -rf /overlay/.etc-work
                sync
                rm -f /usrdata/.overlay_clr_flag
        fi

        mkdir -p /overlay/etc-upper
        mkdir -p /overlay/.etc-work
        #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
        rm -rf /overlay/etc-upper/config/.*.uci-*

        #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
        mount -t overlay -o lowerdir=/etc,upperdir=/overlay/etc-upper,workdir=/overlay/.etc-work overlay /etc


        if [ ! -f $bind_flag ];then
                echo "bind_flag flag does not exist, backup /usrdata/cfg_bak_etc" > /dev/kmsg
                cp -rf /usrdata/cfg_bak_etc/* /
		touch $bind_flag
		sync
	fi


        #quectel 2024/05/06  Delete /usrdata/cfg_bak_data
        if [ -d /usrdata/cfg_bak_data/ ];then
                echo "Delete /usrdata/cfg_bak_data" > /dev/kmsg
                rm -rf /usrdata/cfg_bak_data/
        fi
        #quectel 2024/05/06  Delete /usrdata/cfg_bak_etc
        if [ -d "/usrdata/cfg_bak_etc" ]; then
                echo "Delete /usrdata/cfg_bak_etc" > /dev/kmsg
                rm -rf /usrdata/cfg_bak_etc/
        fi
}
## quecel-20230426, mount-bind for usrdata

fail_reboot()
{
       create_symlinks $1
       update_permission
       TRIAL_BOOT_STATUS=$(abctl --get_trialboot_status)
       echo "Trial boot status: $TRIAL_BOOT_STATUS" > /dev/kmsg
       echo "Failed to mount modem partition for current running slot, rebooting the device.. " > /dev/kmsg
       if [ $TRIAL_BOOT_STATUS == 0 ]; then
               echo "Marking slot $CURRENT_SLOT as unbootable" > /dev/kmsg
               #set unbootable for current slot
               if [ $CURRENT_SLOT == "_a" ]; then
                        abctl --set_unbootable 0;
               else
                        abctl --set_unbootable 1;
               fi
       fi
       reboot -f
}


soc_id=`cat /sys/devices/soc0/soc_id`
if [ ! -d /firmware/image ]; then
        if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then    
                modem_slot=""
                if [ "$CURRENT_SLOT" == "_b" ];then
                        modem_slot="_b"
                fi

                FindAndAttachUBI modem$modem_slot 1
                FindAndMountSquash modem /firmware
                GetMountResult /firmware
                if [ $? -eq 0 ];then
                     echo "mount /firmware failed"
                     sys_reboot "modem-fail"
                fi
        else

                #+quectel-20230302, use symlink instead for modem partition changing
                #create_symlinks mmc
                modem_slot=""
                if [ "$CURRENT_SLOT" == "_b" ];then
                        modem_slot="_b"
                fi
                if [ -d /dev/block/bootdevice/by-name ];then
                        modemblk=$(blockdevbyptname modem$modem_slot)
                        mount  $modemblk /firmware -o ro
                        sleep 1
                        if [ ! -d /firmware/image ]; then
                              echo "mount modem firmware[$modemblk] failed!" > /dev/kmsg
                              if [ $panic_on_fail -eq 1 ];then
                                    echo "c" > /proc/sysrq-trigger
                                    sleep 100
                              else
                                    sys_reboot "modem-fail"
                              fi
                        fi
                fi
                #-quectel-20230302, use symlink instead for modem partition changing
        fi
fi

echo -n "/firmware/image" > /sys/module/firmware_class/parameters/path

if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
        if [ ! -d /persist ]; then
               echo "creating /persist"
               mkdir -p /persist
        fi
        mount -t ubifs ubi0:persist /persist -o bulk_read
        echo "persist is mounted to /persist"
fi

#Mount cache
if [ ! -d /cache ]; then
        echo "creating /cache dir"
        mkdir -p /cache
fi
if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
        #mount -t ubifs ubi0:cachefs /cache -o bulk_read,context=u:r:cache.miscfile
        #mount -t ubifs ubi0:systemrw /overlay -o bulk_read
        #mount -t ubifs ubi0:usrfs /data -o bulk_read,rw
        eval mount_bind_usrdata_ubi usrdata
else
        eval mount_data_ext4 cache /cache noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto,context=u:r:cache.miscfile
        eval mount_data_ext4 systemrw /overlay noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto
        eval mount_data_ext4 persist  /persist noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto,context=u:r:persist.miscfile
        eval mount_data_ext4 usrdata /usrdata
        if [ $mount_data_flag = true ];then
           mount_bind_usrdata /usrdata
        fi
fi

#johnson-20231118, move overlay mount to mount_bind_usrdata
#if [ $soc_id == "570" ] || [ $soc_id == "571" ]; then
#    mkdir -p /data/overlay-work
#    mkdir -p /data/overlay-work/etc-upper$CURRENT_SLOT
#    mkdir -p /data/overlay-work/.etc-work$CURRENT_SLOT
#    mount -t overlay -o lowerdir=/etc,upperdir=/data/overlay-work/etc-upper$CURRENT_SLOT,workdir=/data/overlay-work/.etc-work$CURRENT_SLOT overlay /etc
#else
#    mkdir -p /overlay/etc-upper$CURRENT_SLOT
#    mkdir -p /overlay/.etc-work$CURRENT_SLOT
#    mount -t overlay -o lowerdir=/etc,upperdir=/overlay/etc-upper$CURRENT_SLOT,workdir=/overlay/.etc-work$CURRENT_SLOT overlay /etc
#fi

# Need Restorecon for /persist & /firmware
RESTORECON=/sbin/restorecon
${RESTORECON} -RF /persist /data
${RESTORECON} -R /etc/ -e /etc/rc.d

#+quectel-20231103, symbol link for rf_band
if [ -e /firmware/image/modem_pr/rf_band ]; then
    ln -s /firmware/image/modem_pr/rf_band /system/rfs/mdm/mpss/shared/rf_band
else
    echo "rf_band not exist"
fi
#-quectel-20231103, symbol link for rf_band
#+quectel-20240913, symbol link for quec_xqcn
if [ -e /firmware/image/modem_pr/quec_xqcn ]; then
    ln -s /firmware/image/modem_pr/quec_xqcn /system/rfs/mdm/mpss/shared/quec_xqcn
else
    echo "qxqcn not exist"
fi
#-quectel-20240913, symbol link for quec_xqcn
