#!/bin/sh

block_path="/dev/block/bootdevice/by-name/"
ab_partition_default="xbl_config xbl_ramdump uefi abl tz tz_devcfg qhee aop aop_devcfg \
                shrm ipa_fw qupfw keymaster cmnlib64 multi_oem multi_qti apdp \
                boot system modem"
mtd_sbl_partition_name="sbl cpucpfw"
mmc_sbl_partition_name="xbl cpucp"
ab_partition_list=""
active_slot=$(abctl --boot_slot)
inactive_slot=""
active_slot_idx=0
inactive_slot_idx=1
device_type="mmc"

if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
    device_type="mtd"
    ab_partition_default="$mtd_sbl_partition_name $ab_partition_default"
else
    device_type="mmc"
    ab_partition_default="$mmc_sbl_partition_name $ab_partition_default"
fi

get_ab_partitions()
{
    cd $(block_path)
    devices=$(ls)
    for device in $devices;do
        if [ "$(echo "$device" | grep "_b")" ]; then
            length=${#device}
            if [ ${length} -le 2 ]; then
                cd -
                exit
            fi
            partition="${device%_b}"
            if [ -e "$partition" ];then
                ab_partition_list="${ab_partition_list} partition"
            fi
        fi
    done
    cd -
}

validate_checksum()
{
   md5_a=$(md5sum $1 | awk '{print $1}')
   md5_b=$(md5sum $2 | awk '{print $1}')
   echo "$1 checksum $md5_a"
   echo "$2 checksum $md5_b"
   if [ "$md5_a" != "$md5_b" ];then
      echo "validate fail"
      return 1
   fi
}

get_mtd_num()
{
    echo $(cat /proc/mtd | grep -i "\b$1\b" | sed 's/^mtd//' | awk -F ':' '{print $1}')
}

write_mtd_raw_partition()
{
    src=$1
    dst=$2
    if [ "$(echo "$src" | grep "_a")" ]; then
      src="${src%_a}"
    fi
    if [ "$(echo "$dst" | grep "_a")" ]; then
      dst="${dst%_a}"
    fi
    mtd_src=/dev/mtd$(get_mtd_num $src)
    echo "sync write $src to $dst" > /dev/kmsg
    mtdimg --delay 10 --flash $dst $mtd_src || return 1
}

write_mmc_raw_partiton()
{
    src=${block_path}/$1
    dst=${block_path}/$2

    echo "sync write $src to $dst" > /dev/kmsg
    dd if=$src of=$dst bs=64k oflag=direct conv=fsync
    validate_checksum $src $dst || return 1
}

write_raw_partition()
{
    src=$1
    dst=$2

    if [ "$device_type" == "mtd" ]; then
        write_mtd_raw_partition $src $dst || return 1
    else
        write_mmc_raw_partiton $src $dst || return 1
    fi
}

mirror_copy_partition()
{
    partition=$1
    echo "mirror_copy_partion $partition"
    if [ -e ${block_path}/${1}_b ];
    then
        write_raw_partition ${partition}$active_slot ${partition}$inactive_slot || return 1
    else
        return 0
    fi
}

mirror_copy_all()
{
    part_list=$@

    echo $part_list
    for partition in $part_list
    do
        mirror_copy_partition $partition || return 1
    done
}


if [ "$active_slot" == "_a" ];then
   inactive_slot="_b"
   active_slot_idx=0
   inactive_slot_idx=1                                                                                    
elif [ "$active_slot" == "_b" ];then
   inactive_slot="_a"
   active_slot_idx=1
   inactive_slot_idx=0                                                                                    
else                                                                                                 
   exit 0
fi

let active_slot_idx=1-inactive_slot_idx
echo "active_slot[$active_slot_idx] inactive_slot[$inactive_slot_idx]" >/dev/kmsg
if [ "$1" == "force" ];then
    echo "force sync inactive partitions, set inactive_slot[$inactive_slot] unbootable" > /dev/kmsg
    abctl --set_unbootable $inactive_slot_idx
fi
unbootable=$(abctl --get_unbootable $inactive_slot_idx)
if [ $unbootable -eq 1 ];then
    echo "inactive slot[$inactive_slot_idx] is unbootable, recovery by sync from active slot" > /dev/kmsg
    sleep 1
    #mirror_copy_all  $(get_ab_partitions)
    mirror_copy_all $ab_partition_default
    if [ $? -ne 0 ];then
        echo "mirror_copy_all failed"
        exit 1
    fi
    echo "inactive slot[$inactive_slot_idx] recovery successfully, clear unbootable bit" > /dev/kmsg
    abctl --clear_unbootable $inactive_slot_idx
    echo "inactive slot[$inactive_slot_idx] unbootable bit = $(abctl --get_unbootable $inactive_slot_idx)" > /dev/kmsg
fi

