#!/bin/sh
# Copyright (c) 2023 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
KMSG_PATH=/dev/kmsg
        case "$1" in
        1)
                echo "Rebooting device into recovery to apply update.zip" > $KMSG_PATH
                sync
                sync
                sync
                sys_reboot recovery
        ;;
        2)
                echo "Creating recovery directory under /cache partition" > $KMSG_PATH
                mkdir /cache/recovery
                chmod 755 /cache/recovery
        ;;
        3)
                echo "Updating update.zip path for recovery module" > $KMSG_PATH
                echo "--update_package=/data/mbimd/update.zip" > /cache/recovery/command
        ;;
        4)
                echo "RNR: Rebooting system during PLDR" > $KMSG_PATH
                sys_reboot
        ;;
        5)
                echo "RNR: Triggering MSSR for FLDR" > $KMSG_PATH
                echo 1 > /sys/kernel/boot_adsp/ssr
        ;;
        6)
                echo "Changing the freq scaling profile to reduce overall update time" > $KMSG_PATH
                echo performance > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
        ;;
        7)
                echo "QBI: SSCTL shutdown" > $KMSG_PATH
                echo stop > /sys/class/remoteproc/remoteproc*/state
        ;;
        *)
                echo "Invalid argument no default action" > $KMSG_PATH
        ;;
        esac
exit 0