#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh

wlan_2g_band="2.4GHz"
wlan_5g_band="5GHz"
wlan_6g_band="6GHz"
ip_octet=28
wifi0_iface_list=""
wifi1_iface_list=""
wifi2_iface_list=""
mld_iface_list=""

QCMAP_PRIMARY_FRONTHAUL_AP=1
QCMAP_GUEST_FRONTHAUL_AP=2
QCMAP_GUEST_FRONTHAUL_AP_2=3
QCMAP_GUEST_FRONTHAUL_AP_3=4
QCMAP_ADDITIONAL_FH_AP_1=5
QCMAP_ADDITIONAL_FH_AP_2=6
QCMAP_ADDITIONAL_FH_AP_3=7
QCMAP_BACKHAUL_AP_R1=8
QCMAP_BACKHAUL_AP_R2=9
QCMAP_SMART_MONITOR_AP=10

#used to support activate hostapd restart
primaryap=1
guestap1=2
guestap2=3
guestap3=4
guestap4=5
guestap5=6
guestap6=7
guestap7=8
guestap8=9
guestap9=10
guestap10=11
guestap11=12
guestap12=13
guestap13=14
guestap14=15
guestap15=16
guestap16=17
guestap17=18
guestap18=19
guestap19=20
guestap20=21

primaryap_vlan_id=1
guestapone_vlan_id=2
guestaptwo_vlan_id=3
guestapthree_vlan_id=4

QCMAP_PRIMARY_AP=1
QCMAP_GUEST_AP=2
QCMAP_GUEST_AP_2=3
QCMAP_GUEST_AP_3=4
QCMAP_ALL_AP=5
QCMAP_GUEST_AP_4=6
QCMAP_GUEST_AP_5=7
QCMAP_GUEST_AP_6=8
QCMAP_GUEST_AP_7=9
QCMAP_GUEST_AP_8=10
QCMAP_GUEST_AP_9=11
QCMAP_GUEST_AP_10=12
QCMAP_GUEST_AP_11=13
QCMAP_GUEST_AP_12=14
QCMAP_GUEST_AP_13=15
QCMAP_GUEST_AP_14=16
QCMAP_GUEST_AP_15=17
QCMAP_GUEST_AP_16=18
QCMAP_GUEST_AP_17=19
QCMAP_GUEST_AP_18=20
QCMAP_GUEST_AP_19=21
QCMAP_GUEST_AP_20=22

QCMAP_ALL_MLD=21

QCMAP_HOSTAPD_RESTART=3

#this needs to be updated once we get the CDT info
CDT_WLAN_WKK_ATTACH=3
CDT_WLAN_HMT_ATTACH=2
CDT_LGA=5

#Get CDT info and platform version
PLATFORM_VERSION=$(cat /sys/devices/soc0/platform_version)
cdt_type_origin=$(cat /sys/devices/soc0/platform_subtype_id)
CDT_TYPE=$cdt_type_origin

if [ $CDT_LGA -eq $cdt_type_origin ]; then
  if [ $((${PLATFORM_VERSION}>>16)) -eq 2 ]; then
    CDT_TYPE=$CDT_WLAN_WKK_ATTACH
  elif [ $((${PLATFORM_VERSION}>>16)) -eq 1 ]; then
    CDT_TYPE=$CDT_WLAN_HMT_ATTACH
  fi
fi

wlan_dev_prefix="wifi"

function set_ezmesh_config() {
  local ezmesh_enable=$1
  uci set qcmap_ezmesh.@ezmesh[0].enable_state=$ezmesh_enable
  if [ ! -z "$2" ]; then
    local ezmesh_device_mode=$2
    uci set qcmap_ezmesh.@ezmesh[0].device_mode=$ezmesh_device_mode
  fi
  if [ ! -z "$3" ]; then
    local ezmesh_capability=$3
    uci set qcmap_ezmesh.@ezmesh[0].capability=$ezmesh_capability
  fi
  if [ ! -z "$4" ]; then
    local ap_config_len=$4
    uci set qcmap_ezmesh.@ezmesh[0].ap_config_len=$ap_config_len
  fi
  uci commit qcmap_ezmesh

  # Restore default wireless config when enabling ezmesh with new config on HMT
  if [ $# -gt 1 -a $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
    ucitool restore_default_config wireless

    # R6 capability requires 11be mode
    if [ $ezmesh_capability -ge 6 ]; then
      sed -i "s/11axg/11beg/g" /etc/config/wireless
      sed -i "s/11axa/11bea/g" /etc/config/wireless
    fi
  fi

  log  $(basename "$0") "set_ezmesh_config" $LINENO "set_ezmesh_config with Enable:$ezmesh_enable, Device Mode:$ezmesh_device_mode Capability:$ezmesh_capability and No:of VAPs:$ap_config_len done !!!"
}

function set_ezmesh_ap_config() {
  local band=$1
  local guest_profile=$2
  local ezmesh_aptype=$3
  local wlan_ap_type=$4
  local vap_mode=$5
  local mld_index=$6

  case $wlan_ap_type in
    $QCMAP_PRIMARY_AP)
      uci set qcmap_ezmesh.@primaryap[0].band=$band
      uci set qcmap_ezmesh.@primaryap[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@primaryap[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@primaryap[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@primaryap[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@primaryap[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_primary_ap_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP)
      uci set qcmap_ezmesh.@guestap1[0].band=$band
      uci set qcmap_ezmesh.@guestap1[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap1[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap1[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap1[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap1[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap1_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_2)
      uci set qcmap_ezmesh.@guestap2[0].band=$band
      uci set qcmap_ezmesh.@guestap2[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap2[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap2[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap2[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap2[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap2_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_3)
      uci set qcmap_ezmesh.@guestap3[0].band=$band
      uci set qcmap_ezmesh.@guestap3[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap3[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap3[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap3[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap3[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap3_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_4)
      uci set qcmap_ezmesh.@guestap4[0].band=$band
      uci set qcmap_ezmesh.@guestap4[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap4[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap4[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap4[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap4[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap4_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_5)
      uci set qcmap_ezmesh.@guestap5[0].band=$band
      uci set qcmap_ezmesh.@guestap5[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap5[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap5[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap5[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap5[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap5_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_6)
      uci set qcmap_ezmesh.@guestap6[0].band=$band
      uci set qcmap_ezmesh.@guestap6[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap6[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap6[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap6[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap6[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap6_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_7)
      uci set qcmap_ezmesh.@guestap7[0].band=$band
      uci set qcmap_ezmesh.@guestap7[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap7[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap7[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap7[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap7[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap7_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_8)
      uci set qcmap_ezmesh.@guestap8[0].band=$band
      uci set qcmap_ezmesh.@guestap8[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap8[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap8[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap8[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap8[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap8_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_9)
      uci set qcmap_ezmesh.@guestap9[0].band=$band
      uci set qcmap_ezmesh.@guestap9[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap9[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap9[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap9[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap9[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap9_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_10)
      uci set qcmap_ezmesh.@guestap10[0].band=$band
      uci set qcmap_ezmesh.@guestap10[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap10[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap10[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap10[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap10[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap10_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_11)
      uci set qcmap_ezmesh.@guestap11[0].band=$band
      uci set qcmap_ezmesh.@guestap11[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap11[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap11[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap11[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap11[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap11_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_12)
      uci set qcmap_ezmesh.@guestap12[0].band=$band
      uci set qcmap_ezmesh.@guestap12[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap12[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap12[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap12[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap12[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap12_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_13)
      uci set qcmap_ezmesh.@guestap13[0].band=$band
      uci set qcmap_ezmesh.@guestap13[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap13[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap13[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap13[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap13[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap13_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_14)
      uci set qcmap_ezmesh.@guestap14[0].band=$band
      uci set qcmap_ezmesh.@guestap14[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap14[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap14[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap14[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap14[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap14_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_15)
      uci set qcmap_ezmesh.@guestap15[0].band=$band
      uci set qcmap_ezmesh.@guestap15[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap15[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap15[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap15[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap15[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap15_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_16)
      uci set qcmap_ezmesh.@guestap16[0].band=$band
      uci set qcmap_ezmesh.@guestap16[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap16[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap16[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap16[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap16[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap16_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_17)
      uci set qcmap_ezmesh.@guestap17[0].band=$band
      uci set qcmap_ezmesh.@guestap17[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap17[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap17[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap17[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap17[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap17_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_18)
      uci set qcmap_ezmesh.@guestap18[0].band=$band
      uci set qcmap_ezmesh.@guestap18[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap18[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap18[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap18[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap18[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap18_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_19)
      uci set qcmap_ezmesh.@guestap19[0].band=$band
      uci set qcmap_ezmesh.@guestap19[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap19[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap19[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap19[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap19[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap19_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;

    $QCMAP_GUEST_AP_20)
      uci set qcmap_ezmesh.@guestap20[0].band=$band
      uci set qcmap_ezmesh.@guestap20[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap20[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap20[0].wlan_ap_type=$wlan_ap_type
      uci set qcmap_ezmesh.@guestap20[0].vap_mode=$vap_mode
      uci set qcmap_ezmesh.@guestap20[0].mld_index=$mld_index
      log $(basename "$0") "set_ezmesh_guest_ap20_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype, is MLO enabled AP:$vap_mode, mld:$mld_index"
      ;;
  esac

  uci commit qcmap_ezmesh
}

function set_ezmesh_per_band_count() {
  local ap_count_2g=$1
  local ap_count_5g=$2
  local ap_count_6g=$3

  uci set qcmap_ezmesh.@ezmesh[0].ap_count_2g=$ap_count_2g
  uci set qcmap_ezmesh.@ezmesh[0].ap_count_5g=$ap_count_5g
  uci set qcmap_ezmesh.@ezmesh[0].ap_count_6g=$ap_count_6g
  uci commit qcmap_ezmesh

  uci set repacd.MAPConfig.FirstConfigRequired='1'
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_per_band_count" $LINENO "No.of APs 2G:$ap_count_2g, 5G:$ap_count_5g, 6G:$ap_count_6g done !!!"
}

function set_ezmesh_r2_traffic_separation() {
  local traffic_separation=$1

  uci set qcmap_ezmesh.@r2_config[0].traffic_separation=$traffic_separation
  uci commit qcmap_ezmesh

  #update the repacd about the traffic separation info
  uci set repacd.MAPConfig.MapTrafficSeparationEnable=$traffic_separation
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_r2_traffic_separation" $LINENO "Traffic separation:$traffic_separation done !!!"
}

function set_ezmesh_vlan_config() {
  local no_of_vlans=$1
  local vlan_id1=$2
  local fh_ap1_type=$3
  local vlan_id2=$4
  local fh_ap2_type=$5
  local vlan_id3=$6
  local fh_ap3_type=$7
  local vlan_id4=$8
  local fh_ap4_type=$9

  uci set qcmap_ezmesh.@r2_config[0].no_of_vlans=$no_of_vlans
  uci set qcmap_ezmesh.@r2_config[0].primaryap_vlan_id=$vlan_id1
  uci set qcmap_ezmesh.@r2_config[0].primaryap_fh_type=$fh_ap1_type
  uci set qcmap_ezmesh.@r2_config[0].guestapone_vlan_id=$vlan_id2
  uci set qcmap_ezmesh.@r2_config[0].guestapone_fh_type=$fh_ap2_type
  if [ ! -z "$vlan_id3" ]; then
    uci set qcmap_ezmesh.@r2_config[0].guestaptwo_vlan_id=$vlan_id3
    uci set qcmap_ezmesh.@r2_config[0].guestaptwo_fh_type=$fh_ap3_type
  fi
  if [ ! -z "$vlan_id4" ]; then
    uci set qcmap_ezmesh.@r2_config[0].guestapthree_vlan_id=$vlan_id4
    uci set qcmap_ezmesh.@r2_config[0].guestapthree_fh_type=$fh_ap4_type
  fi
  uci commit qcmap_ezmesh

  #update the repacd about the vlan and bridge names info
  uci set repacd.MAPConfig.SkipDhcpConfigSettings='1'
  uci set repacd.MAPConfig.NumberOfVLANSupported=$no_of_vlans
  uci set repacd.repacd.ManagedNetwork="lan"
  uci set repacd.MAPConfig.VlanIDNwPrimary=$vlan_id1
  uci set repacd.MAPConfig.VlanNetworkPrimary="lan"
  uci set repacd.MAPConfig.VlanIDNwOne=$vlan_id2
  uci set repacd.MAPConfig.VlanNetworkOne="lan${vlan_id2}"
  if [ ! -z "$vlan_id3" ]; then
  uci set repacd.MAPConfig.VlanIDNwTwo=$vlan_id3
  uci set repacd.MAPConfig.VlanNetworkTwo="lan${vlan_id3}"
  fi
  if [ ! -z "$vlan_id4" ]; then
  uci set repacd.MAPConfig.VlanIDNwThree=$vlan_id4
  uci set repacd.MAPConfig.VlanNetworkThree="lan${vlan_id4}"
  fi
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_vlan_config" $LINENO "Traffic separation:$traffic_separation, Vlan:$vlan_id1, $vlan_id2, $vlan_id3, $vlan_id4 done !!!"
}

function set_ezmesh_r3_service_priority() {
  local service_priority=$1

  uci set qcmap_ezmesh.@r3_config[0].service_priority=$service_priority
  uci commit qcmap_ezmesh

  log  $(basename "$0") "set_ezmesh_r3_service_priority" $LINENO "Service Priority:$service_priority done !!!"
}

function update_ezmesh_wireless_config() {
  local file=$1
  local band=$2
  local wifi_dev=$3
  local max=8
  local ip_octet_tmp=$4
  local wifi0_band=5
  local wifi1_band=2
  local wifi2_band=6
  local count=0


  #Get totoal config count required in specific band.
  if [ $band -eq 2 ]; then
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_2g)
  elif [ $band -eq 5 ]; then
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_5g)
  else
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_6g)
  fi

  if [ $count -eq 0 ]; then
    log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "not using ${band}G config count=$count"
    return
  fi

  echo "count = $count"
  #Configure IP address to AP.
  #Link local IP will set by wifi script, update link local IP to AP wireless config.
  for i in `seq 0 $((count-1))`
  do
    log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "Setting IP addr to AP config"
    uci set $file.@wifi-iface[$i].ipaddr="169.254.$((ip_octet_tmp)).1"
    ip_octet_tmp=$((ip_octet_tmp+1))
    uci commit
  done

  #update ip octet for other radio.
  ip_octet=$ip_octet_tmp

  log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "*****Valid count:$count band:$band***"
  #delete unused AP config.
  for i in `seq $count $max`
  do
    uci delete $file.@wifi-iface[$count]
    uci commit $file
  done

  uci commit $file
  #append config to wireless config file
  log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "valid config found with band:$band"
  cat /etc/config/$file >> /etc/config/wireless

}

function set_ezmesh_update_wireless() {
  local wifi_dev2 wifi_dev2_mac_addr
  local wifi_dev5 wifi_dev5_mac_addr
  local wifi_dev6 wifi_dev6_mac_addr
  local tmp band

  #Get wifi devices.
  local wifi_devices=$(ls /sys/class/net | grep wifi)
  for device in $wifi_devices
  do
    tmp=$(cfg80211tool $device g_oper_reg_info)
    band=$(echo $tmp | awk '{ print $4 }' | cut -c 6)
    case $band in
      2)
        wifi_dev2=$device
        wifi_dev2_mac_addr=$(cat /sys/class/net/$wifi_dev2/address)
        ;;
      5)
        wifi_dev5=$device
        wifi_dev5_mac_addr=$(cat /sys/class/net/$wifi_dev5/address)
        ;;
      6)
        wifi_dev6=$device
        wifi_dev6_mac_addr=$(cat /sys/class/net/$wifi_dev6/address)
        ;;
      *)
        echo "Invalid Band"
    esac
  done

  echo > /etc/config/wireless

  #update 2g wireless file to tmp
  cp /etc/config/default_wifi_configs/2g_wireless /etc/config/2g_wireless
  sed -i "s/wifiX/$wifi_dev2/g" /etc/config/2g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev2_mac_addr/g" /etc/config/2g_wireless
  update_ezmesh_wireless_config 2g_wireless 2 $wifi_dev2 $ip_octet

  #update 5g wireless file to tmp
  cp /etc/config/default_wifi_configs/5g_wireless /etc/config/5g_wireless
  sed -i "s/wifiX/$wifi_dev5/g" /etc/config/5g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev5_mac_addr/g" /etc/config/5g_wireless
  update_ezmesh_wireless_config 5g_wireless 5 $wifi_dev5 $ip_octet

  #update 6g wireless file to tmp
  cp /etc/config/default_wifi_configs/6g_wireless /etc/config/6g_wireless
  sed -i "s/wifiX/$wifi_dev6/g" /etc/config/6g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev6_mac_addr/g" /etc/config/6g_wireless
  update_ezmesh_wireless_config 6g_wireless 6 $wifi_dev6 $ip_octet

  log $(basename "$0") "set_ezmesh_update_wireless" $LINENO "/etc/config/wireless updated"
  #delete /etc/confog/Xg_wireless
  rm /etc/config/2g_wireless
  rm /etc/config/5g_wireless
  rm /etc/config/6g_wireless

}

function set_ezmesh_update_ifaces() {
  local wifi_ifaces_count=$(uci show wireless | grep -i "wifi-iface" | awk -F'[][]' '{print $2}' | tail -1)
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)
  local traffic_separation=$(uci get qcmap_ezmesh.@r2_config[0].traffic_separation)
  local no_of_vlans=$(uci get qcmap_ezmesh.@r2_config[0].no_of_vlans)
  local vlan_id1 vlan_id2 vlan_id3 vlan_id4
  local guest1_type guest2_type guest3_type
  if [ $traffic_separation == "1" ]; then
    for i in `seq $no_of_vlans`
    do
      case $i in
        $primaryap_vlan_id)
          vlan_id1=$(uci get qcmap_ezmesh.@r2_config[0].primaryap_vlan_id)
        ;;

        $guestapone_vlan_id)
          vlan_id2=$(uci get qcmap_ezmesh.@r2_config[0].guestapone_vlan_id)
          guest1_type=$(uci get qcmap_ezmesh.@r2_config[0].guestapone_fh_type)
        ;;

        $guestaptwo_vlan_id)
          vlan_id3=$(uci get qcmap_ezmesh.@r2_config[0].guestaptwo_vlan_id)
          guest2_type=$(uci get qcmap_ezmesh.@r2_config[0].guestaptwo_fh_type)
        ;;

        $guestapthree_vlan_id)
          vlan_id4=$(uci get qcmap_ezmesh.@r2_config[0].guestapthree_vlan_id)
          guest3_type=$(uci get qcmap_ezmesh.@r2_config[0].guestapthree_fh_type)
        ;;
      esac
    done
  fi
  local intf device band_info band mapBssType network ipaddr ap_type add_fh_vap_idx mld
  local ezmesh_band ezmesh_type

  #delete if any STA interface attach to wanwlan
  uci delete network.wanwlan.ifname 2> /dev/null

  log $(basename "$0") "" $LINENO "parsing wireless file"

  for i in `seq 0 $((wifi_ifaces_count))`
  do
    intf=$(uci get wireless.@wifi-iface[$i].ifname)
    mld=$(uci get wireless.@wifi-iface[$i].mld)
    mld=${mld:3}
    log $(basename "$0") "" $LINENO "vap $intf mld$mld found in wireless file"
    if [ ! -z "$intf" ]; then
      device=$(uci get wireless.@wifi-iface[$i].device)
      band_info=$(cfg80211tool $device g_oper_reg_info | grep -i band | awk -F ',' '{print $3}' | awk -F '=' '{print $2}')
      if [ $band_info == "$wlan_2g_band" ]; then
        band=2
      elif [ $band_info == "$wlan_5g_band" ]; then
        band=5
      elif [ $band_info == "$wlan_6g_band" ]; then
        band=6
      fi
      mapBssType=$(uci get wireless.@wifi-iface[$i].MapBSSType)
      ipaddr=$(uci get wireless.@wifi-iface[$i].ipaddr)
      if [ $mapBssType == '32' ]; then
        network=$(uci get wireless.@wifi-iface[$i].network)
        if [ ! -z "$vlan_id2" ] && [ $network == "lan${vlan_id2}" ]; then
          ap_type=$guest1_type
        elif [ ! -z "$vlan_id3" ] && [ $network == "lan${vlan_id3}" ]; then
          ap_type=$guest2_type
        elif [ ! -z "$vlan_id4" ] && [ $network == "lan${vlan_id4}" ]; then
          ap_type=$guest3_type
        else
          add_fh_vap_idx=$(uci get wireless.@wifi-iface[$i].additional_fh_vap_index)
          if [ -z "$add_fh_vap_idx" ] && [ $network == "lan" ]; then
            ap_type=$QCMAP_PRIMARY_FRONTHAUL_AP
          else
            if [ $add_fh_vap_idx == '1' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_1
            elif [ $add_fh_vap_idx == '2' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_2
            elif [ $add_fh_vap_idx == '3' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_3
            fi
          fi
        fi
      elif [ $mapBssType == '64' ] || [ $mapBssType == '68' ]; then
        ap_type=$QCMAP_BACKHAUL_AP_R1
      elif [ $mapBssType == '72' ]; then
        ap_type=$QCMAP_BACKHAUL_AP_R2
      elif [ -z "$mapBssType" ]; then
        ap_type=$QCMAP_SMART_MONITOR_AP
      fi

      for j in `seq $ezmesh_ap_len`
      do
        case $j in
          $primaryap)
            ezmesh_band=$(uci get qcmap_ezmesh.@primaryap[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@primaryap[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@primaryap[0].ifname=$intf
              uci set qcmap_ezmesh.@primaryap[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to primaryap"
            fi
          ;;

          $guestap1)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap1[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap1[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap1[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap1[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap1"
            fi
          ;;

          $guestap2)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap2[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap2[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap2[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap2[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap2"
            fi
          ;;

          $guestap3)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap3[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap3[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap3[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap3[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap3"
            fi
          ;;

          $guestap4)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap4[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap4[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap4[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap4[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap4"
            fi
          ;;

          $guestap5)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap5[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap5[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap5[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap5[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap5"
            fi
          ;;

          $guestap6)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap6[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap6[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap6[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap6[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap6"
            fi
          ;;

          $guestap7)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap7[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap7[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap7[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap7[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap7"
            fi
          ;;

          $guestap8)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap8[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap8[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap8[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap8[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap8"
            fi
          ;;

          $guestap9)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap9[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap9[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap9[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap9[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap9"
            fi
          ;;

          $guestap10)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap10[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap10[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap10[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap10[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap10"
            fi
          ;;

          $guestap11)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap11[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap11[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap11[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap11[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap11"
            fi
          ;;

          $guestap12)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap12[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap12[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap12[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap12[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap12"
            fi
          ;;

          $guestap13)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap13[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap13[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap13[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap13[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap13"
            fi
          ;;

          $guestap14)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap14[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap14[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap14[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap14[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap14"
            fi
          ;;

          $guestap15)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap15[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap15[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap15[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap15[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap15"
            fi
          ;;

          $guestap16)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap16[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap16[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap16[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap16[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap16"
            fi
          ;;

          $guestap17)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap17[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap17[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap17[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap17[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap17"
            fi
          ;;

          $guestap18)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap18[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap18[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap18[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap18[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap18"
            fi
          ;;

          $guestap19)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap19[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap19[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap19[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap19[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap19"
            fi
          ;;

          $guestap20)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap20[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap20[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap20[0].ifname=$intf
              uci set qcmap_ezmesh.@guestap20[0].mld_index=$mld
              log $(basename "$0") "" $LINENO "adding $intf mld $mld to guestap20"
            fi
          ;;
        esac
        uci commit qcmap_ezmesh
      done
    fi

    #update the ifname to network lan config
    if [ ! -z "$intf" ] && [ ! -z "$mapBssType" ];then
      uci set network.$intf="interface"
      uci set network.$intf.device="$intf"
      uci set network.$intf.proto="static"
      uci set network.$intf.ipv6="1"
      uci set network.$intf.ipaddr="$ipaddr"
      uci set network.$intf.netmask="255.255.255.0"
      uci commit network
    fi
  done
}

function delete_ezmesh_ifaces_config() {
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)
  local traffic_separation=$(uci get qcmap_ezmesh.@r2_config[0].traffic_separation)
  local no_of_vlans=$(uci get qcmap_ezmesh.@r2_config[0].no_of_vlans)
  local ezmesh_type intf

  for i in `seq $ezmesh_ap_len`
  do
    case $i in
      $primaryap)
        ezmesh_type=$(uci get qcmap_ezmesh.@primaryap[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
        uci set qcmap_ezmesh.@primaryap[0].ifname=" "
        uci set qcmap_ezmesh.@primaryap[0].mld='0'
      ;;

      $guestap1)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap1[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
        uci set qcmap_ezmesh.@guestap1[0].ifname=" "
        uci set qcmap_ezmesh.@guestap1[0].mld='0'
      ;;

      $guestap2)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap2[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
        uci set qcmap_ezmesh.@guestap2[0].ifname=" "
        uci set qcmap_ezmesh.@guestap2[0].mld='0'
      ;;

      $guestap3)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap3[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
        uci set qcmap_ezmesh.@guestap3[0].ifname=" "
        uci set qcmap_ezmesh.@guestap3[0].mld='0'
      ;;

      $guestap4)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap4[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
        uci set qcmap_ezmesh.@guestap4[0].ifname=" "
        uci set qcmap_ezmesh.@guestap4[0].mld='0'
      ;;

      $guestap5)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap5[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
        uci set qcmap_ezmesh.@guestap5[0].ifname=" "
        uci set qcmap_ezmesh.@guestap5[0].mld='0'
      ;;

      $guestap6)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap6[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
        uci set qcmap_ezmesh.@guestap6[0].ifname=" "
        uci set qcmap_ezmesh.@guestap6[0].mld='0'
      ;;

      $guestap7)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap7[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
        uci set qcmap_ezmesh.@guestap7[0].ifname=" "
        uci set qcmap_ezmesh.@guestap7[0].mld='0'
      ;;

      $guestap8)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap8[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
        uci set qcmap_ezmesh.@guestap8[0].ifname=" "
        uci set qcmap_ezmesh.@guestap8[0].mld='0'
      ;;

      $guestap9)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap9[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
        uci set qcmap_ezmesh.@guestap9[0].ifname=" "
        uci set qcmap_ezmesh.@guestap9[0].mld='0'
      ;;

      $guestap10)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap10[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
        uci set qcmap_ezmesh.@guestap10[0].ifname=" "
        uci set qcmap_ezmesh.@guestap10[0].mld='0'
      ;;

      $guestap11)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap11[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
        uci set qcmap_ezmesh.@guestap11[0].ifname=" "
        uci set qcmap_ezmesh.@guestap11[0].mld='0'
      ;;

      $guestap12)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap12[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
        uci set qcmap_ezmesh.@guestap12[0].ifname=" "
        uci set qcmap_ezmesh.@guestap12[0].mld='0'
      ;;

      $guestap13)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap13[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
        uci set qcmap_ezmesh.@guestap13[0].ifname=" "
        uci set qcmap_ezmesh.@guestap13[0].mld='0'
      ;;

      $guestap14)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap14[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap14[0].ifname)
        uci set qcmap_ezmesh.@guestap14[0].ifname=" "
        uci set qcmap_ezmesh.@guestap14[0].mld='0'
      ;;

      $guestap15)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap15[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap15[0].ifname)
        uci set qcmap_ezmesh.@guestap15[0].ifname=" "
        uci set qcmap_ezmesh.@guestap15[0].mld='0'
      ;;

      $guestap16)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap16[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap16[0].ifname)
        uci set qcmap_ezmesh.@guestap16[0].ifname=" "
        uci set qcmap_ezmesh.@guestap16[0].mld='0'
      ;;

      $guestap17)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap17[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap17[0].ifname)
        uci set qcmap_ezmesh.@guestap17[0].ifname=" "
        uci set qcmap_ezmesh.@guestap17[0].mld='0'
      ;;

      $guestap18)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap18[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap18[0].ifname)
        uci set qcmap_ezmesh.@guestap18[0].ifname=" "
        uci set qcmap_ezmesh.@guestap18[0].mld='0'
      ;;

      $guestap19)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap19[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap19[0].ifname)
        uci set qcmap_ezmesh.@guestap19[0].ifname=" "
        uci set qcmap_ezmesh.@guestap19[0].mld='0'
      ;;

      $guestap20)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap20[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap20[0].ifname)
        uci set qcmap_ezmesh.@guestap20[0].ifname=" "
        uci set qcmap_ezmesh.@guestap20[0].mld='0'
      ;;

    esac
    uci commit qcmap_ezmesh

    #delete the ifname config from network lan config
    if [ ! -z "$intf" ] && [ $ezmesh_type != '0' ];then
      uci delete network.$intf 2> /dev/null
      uci commit network
    fi
  done
}

function set_ezmesh_repacd_start() {
  uci set repacd.repacd.Enable='1'
  uci set repacd.repacd.Ezmesh='1'
  uci set repacd.MAPConfig.AssignIPAddressPerVAP='1'
  uci commit repacd

  /etc/init.d/repacd start
}

function set_ezmesh_repacd_stop() {
  local clean_up_config=$(uci get qcmap_ezmesh.@ezmesh[0].clean_up_config)

  delete_ezmesh_ifaces_config
  uci set repacd.repacd.Enable='0'
  uci set repacd.repacd.Ezmesh='0'
  uci set repacd.MAPConfig.ShutDownServices='1'
  if [ $clean_up_config == '1' ]; then
    uci set repacd.MAPConfig.CleanUpEzmeshConfig='1'
  fi
  uci commit repacd

  if [ $clean_up_config == '1' ]; then
    /etc/init.d/repacd stop
  else
    /sbin/wifi down
  fi
}

function set_ezmesh_repacd_restart() {
  uci set repacd.repacd.Enable='1'
  uci set repacd.repacd.Ezmesh='1'
  uci set repacd.MAPConfig.AssignIPAddressPerVAP='1'
  uci commit repacd

  /sbin/wifi up
}

function set_ezmesh_repacd_restore() {
  uci set repacd.repacd.Enable='0'
  uci set repacd.repacd.Ezmesh='0'
  uci set repacd.MAPConfig.ShutDownServices='1'
  uci set repacd.MAPConfig.CleanUpEzmeshConfig='1'
  uci commit repacd

  /etc/init.d/repacd stop
}

function enable_ezmesh_on_bootup() {
  # we need to enable config in wireless config before wifi up
  # as it is disabled as part of reset_wlan_atbootup
  sed -i "s/disabled '1'/disabled '0'/g" /etc/config/wireless

  /sbin/wifi
}

function ezmesh_restart_wwan_profile() {
  local wwan_profile=$1

  if [ -n "$wwan_profile" ]; then
    if [ -f /tmp/ipv4config$wwan_profile ]; then
      /lib/netifd/rmnet_update.sh "up" $wwan_profile 1
    fi
    if [ -f /tmp/ipv6config$wwan_profile ]; then
      /lib/netifd/rmnet_update.sh "up" $wwan_profile 2
    fi
  fi
}

function add_iface_to_list() {
  local intf=$1
  local idx

  case $CDT_TYPE in
    $CDT_WLAN_HMT_ATTACH) idx=$(ucitool get_device $intf | awk '{ print $1 }' | cut -c 5);;
    $CDT_WLAN_WKK_ATTACH|*) idx=$(echo $intf | awk '{ print $1 }' | cut -c 4);;
  esac

  if [ $idx == 0 ]; then
    wifi0_iface_list="${wifi0_iface_list} $intf"
  elif [ $idx == 1 ]; then
    wifi1_iface_list="${wifi1_iface_list} $intf"
  else
    wifi2_iface_list="${wifi2_iface_list} $intf"
  fi

  log $(basename "$0") "add_iface_to_list" $LINENO "adding $intf to idx:$idx"
}

function activate_ezmesh_hostapd_restart() {
  local activate_cmd

  if [ ! -z "$mld_iface_list" ]; then
    activate_cmd="${activate_cmd} "${mld_iface_list}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at mld: $activate_cmd"
  fi

  if [ ! -z "$wifi0_iface_list" ]; then
    activate_cmd="${activate_cmd}${wlan_dev_prefix}0 "${wifi0_iface_list}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi0: $activate_cmd"
  fi

  if [ ! -z "$wifi1_iface_list" ]; then
    activate_cmd="${activate_cmd}${wlan_dev_prefix}1 "${wifi1_iface_list}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi1: $activate_cmd"
  fi

  if [ ! -z "$wifi2_iface_list" ]; then
    activate_cmd="${activate_cmd}${wlan_dev_prefix}2 "${wifi2_iface_list}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi2: $activate_cmd"
  fi

  log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command before call : $activate_cmd"

  #Activate hostapd for mldX and athX vaps using "wifi multi_up" command as it takes care of mldX, athX ifaces down and up internally
  wifi multi_up $activate_cmd >> /dev/null
  log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "[Done] wifi multi_up $activate_cmd"

  echo "Activate Hostpad Success"
}

function activate_ezmesh_hostapd_config() {
  local ap_list_len=$1
  local action=$2
  local mld_list_len=$3

  if [ $action -ne $QCMAP_HOSTAPD_RESTART ]; then
    log $(basename "$0") "activate_ezmesh_hostapd_config" $LINENO "Invalid action type: $action"
    return
  fi

  wifi0_iface_list=""
  wifi1_iface_list=""
  wifi2_iface_list=""

  mld_iface_list=""

  echo "Activate EZMesh Hostapd config is Valid"
  log  $(basename "$0") "activate_ezmesh_hostapd_config" $LINENO "AP List len:$ap_list_len, Action Type:$action, MLD List len:$mld_list_len done !!!"
}

function activate_ezmesh_hostapd_ap_all_config() {
  local ap_type=$1
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)

  #wifi multi_up wifiX <athX list from this wifiX>
  #wifi multi_down wifiX <athX list from this wifiX>
  #wifi multi_up wifiX athXA athXB wifiY athYA athYB

  #get wireless config state.
  #wlan_state=$(uci -q get wireless.@wifi-iface[0].disabled)
  #if [ $wlan_state == 1 ]; then
  #  log $(basename "$0") "activate_ezmesh_hostapd_ap_all_config" $LINENO "WLAN is disabled can't start hostapd"
  #  return
  #fi

  if [ $ap_type == $QCMAP_ALL_AP ] && [ $ezmesh_ap_len -ne 0 ]; then
    for i in `seq $ezmesh_ap_len`
    do
      case $i in
        $primaryap)
          intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap1)
          intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap2)
          intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap3)
          intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap4)
          intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap5)
          intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap6)
          intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap7)
          intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap8)
          intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap9)
          intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap10)
          intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap11)
          intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap12)
          intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap13)
          intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap14)
          intf=$(uci get qcmap_ezmesh.@guestap14[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap15)
          intf=$(uci get qcmap_ezmesh.@guestap15[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap16)
          intf=$(uci get qcmap_ezmesh.@guestap16[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap17)
          intf=$(uci get qcmap_ezmesh.@guestap17[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap18)
          intf=$(uci get qcmap_ezmesh.@guestap18[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap19)
          intf=$(uci get qcmap_ezmesh.@guestap19[0].ifname)
          add_iface_to_list $intf
        ;;

        $guestap20)
          intf=$(uci get qcmap_ezmesh.@guestap20[0].ifname)
          add_iface_to_list $intf
        ;;
      esac
    done
  else
    log $(basename "$0") "activate_ezmesh_hostapd_ap_all_config" $LINENO "Invalid ap_type: $ap_type or ezmesh_ap_len: $ezmesh_ap_len"
    return
  fi

  echo "Activate EZMesh Hostapd AP config success"
}

function activate_ezmesh_hostapd_ap_config() {
  local ap_len=$1
  local ap_string=$2
  local ap_type

  #wifi multi_up wifiX <athX list from this wifiX>
  #wifi multi_down wifiX <athX list from this wifiX>
  #wifi multi_up wifiX athXA athXB wifiY athYA athYB

  for i in $ap_string
  do
    ap_type=$i
    log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "i = $i and ap_type: $ap_type"
    case $ap_type in
      $QCMAP_PRIMARY_AP)
        wlan_type=$(uci get qcmap_ezmesh.@primaryap[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP)
        wlan_type=$(uci get qcmap_ezmesh.@guestap1[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_2)
        wlan_type=$(uci get qcmap_ezmesh.@guestap2[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_3)
        wlan_type=$(uci get qcmap_ezmesh.@guestap3[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_4)
        wlan_type=$(uci get qcmap_ezmesh.@guestap4[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_5)
        wlan_type=$(uci get qcmap_ezmesh.@guestap5[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_6)
        wlan_type=$(uci get qcmap_ezmesh.@guestap6[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_7)
        wlan_type=$(uci get qcmap_ezmesh.@guestap7[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_8)
        wlan_type=$(uci get qcmap_ezmesh.@guestap8[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_9)
        wlan_type=$(uci get qcmap_ezmesh.@guestap9[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_10)
        wlan_type=$(uci get qcmap_ezmesh.@guestap10[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_11)
        wlan_type=$(uci get qcmap_ezmesh.@guestap11[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_12)
        wlan_type=$(uci get qcmap_ezmesh.@guestap12[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_13)
        wlan_type=$(uci get qcmap_ezmesh.@guestap13[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_14)
        wlan_type=$(uci get qcmap_ezmesh.@guestap14[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap14[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_15)
        wlan_type=$(uci get qcmap_ezmesh.@guestap15[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap15[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_16)
        wlan_type=$(uci get qcmap_ezmesh.@guestap16[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap16[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_17)
        wlan_type=$(uci get qcmap_ezmesh.@guestap17[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap17[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_18)
        wlan_type=$(uci get qcmap_ezmesh.@guestap18[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap18[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_19)
        wlan_type=$(uci get qcmap_ezmesh.@guestap19[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap19[0].ifname)
          add_iface_to_list $intf
        fi
        ;;

      $QCMAP_GUEST_AP_20)
        wlan_type=$(uci get qcmap_ezmesh.@guestap20[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap20[0].ifname)
          add_iface_to_list $intf
        fi
        ;;
    *)
      log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "Invalid ap_type"
      return
    esac
  done

  echo "Activate EZMesh Hostapd AP config success"
}

function activate_ezmesh_hostapd_mld_all_config() {
  local mld_type=$1

  if [ $mld_type == $QCMAP_ALL_MLD ]; then
    local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)

    #Make a list of primaryap and guestap words to avoid making case clauses
    local aplist="primaryap"
    for i in $(seq $(($ezmesh_ap_len-1)) )
    do
      aplist="${aplist} guestap$i"
    done

    log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO "aplist: $aplist"

    # iterate over all VAPs in qcmap_ezmesh and make a list of unique mlds
    for i in $aplist
    do
      vap_mode=$(uci get qcmap_ezmesh.@$i[0].vap_mode)
      log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO "vap_mode: $vap_mode"

      # only read mld for MLO
      if [ $vap_mode == 1 ]; then
        log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO "found MLO"
        mld_index=$(uci get qcmap_ezmesh.@$i[0].mld)
        log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO "mld_index: $mld_index"

        local duplicate_mld=0
        for j in $mld_iface_list
        do
          if [ mld$mld_index == $j ]; then
            duplicate_mld=1
            log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO "duplicate mld"
            break
          fi
        done

        if [ $duplicate_mld == 0 ]; then
          mld_iface_list="${mld_iface_list} mld$mld_index"
          log $(basename "$0") "activate_ezmesh_hostapd_mld_config" $LINENO " added $mld_index to mld_iface_list $mld_iface_list"
        fi
      fi
    done
  fi

  echo "Activate EZMesh Hostapd MLD all config success"
}

function set_ezmesh_extender_network_cfg() {
  local extender_mode_enable=$1

  #If extender mode enable, then replace network with extender network cfg
  if [ $extender_mode_enable -eq 1 ]; then
    uci set dhcp.lan.ignore=1
    uci commit dhcp
    rm -rf /etc/config/network
    cat /etc/data/ezmesh_extender_network_cfg > /etc/config/network
  #If extender mode disable, then replace extender network with defualt network cfg
  elif [ $extender_mode_enable -eq 0 ]; then
    uci set dhcp.lan.ignore=0
    uci commit dhcp
    rm -rf /etc/config/network
    cat /etc/data/default_qcmap_network_cfg > /etc/config/network
  fi

  /etc/init.d/network reload
  /etc/init.d/dnsmasq reload

  log  $(basename "$0") "set_ezmesh_extender_network_cfg" $LINENO "extender_mode_enable:$extender_mode_enable done !!!"
}

function set_ezmesh_mlo_config() {
  # update qcmap_ezmesh and run repacd, wsplcd commands

  uci set qcmap_ezmesh.@ezmesh_mlo[0].enable_state_mlo=$1
  uci set repacd.MAPConfig.EnableMLO=$1
  uci set wsplcd.config.EnableMLO=$1
  log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "state $1"
  if [ ! -z "$2" ]; then

    # arg_idx will act as indicator of argument position in arg list
    local arg_idx=1

    #increment by 1. New value = 2
    arg_idx=$(($arg_idx+1))
    log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "arg_idx: $arg_idx"

    #store arg_idx th argument in ap_mld_mapping_len
    eval local ap_mld_mapping_len=\$\{$arg_idx\}
    uci set qcmap_ezmesh.@ezmesh_mlo[0].ap_mld_mapping_len=$ap_mld_mapping_len
    log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ap_mld_mapping_len $ap_mld_mapping_len"

    local mld_index

    #run this loop for each different mld_ap_type
    for num_ap_mld_mapping in $(seq $ap_mld_mapping_len)
    do

        arg_idx=$(($arg_idx+1))
        eval mld_index=\$\{$arg_idx\}

        arg_idx=$(($arg_idx+1))
        eval ezmesh_mld_ap_type=\$\{$arg_idx\}

        if [ $ezmesh_mld_ap_type != AdditionalFHVAP ]; then
          uci set repacd.MAPConfig.$ezmesh_mld_ap_type=$mld_index
        fi

        log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld info of ezmesh_mld_ap $num_ap_mld_mapping"
        case $num_ap_mld_mapping in
          1)
            uci set qcmap_ezmesh.@ezmesh_mld_ap1[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap1[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          2)
            uci set qcmap_ezmesh.@ezmesh_mld_ap2[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap2[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          3)
            uci set qcmap_ezmesh.@ezmesh_mld_ap3[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap3[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          4)
            uci set qcmap_ezmesh.@ezmesh_mld_ap4[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap4[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          5)
            uci set qcmap_ezmesh.@ezmesh_mld_ap5[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap5[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          6)
            uci set qcmap_ezmesh.@ezmesh_mld_ap6[0].mld_index=$mld_index
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing mld_index $mld_index"

            uci set qcmap_ezmesh.@ezmesh_mld_ap6[0].ezmesh_mld_ap_type=$ezmesh_mld_ap_type
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "storing ezmesh_mld_ap_type $ezmesh_mld_ap_type"

            ;;
          *)
            log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "Invalid num_ap_mld_mapping " $num_ap_mld_mapping

            ;;
        esac
    done
    arg_idx=$(($arg_idx+1))
    log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "arg_idx: $arg_idx"

    local mld_config
    eval mld_config=\$\{$arg_idx\}

    log $(basename "$0") "set_ezmesh_mlo_config" $LINENO "mld_config " $mld_config
    uci set qcmap_ezmesh.@ezmesh_mlo[0].mld_config="$mld_config"
    uci set repacd.MAPConfig.MLDConfig="$mld_config"
  fi

  uci commit qcmap_ezmesh
  uci commit wsplcd
  uci commit repacd

}

function activate_ezmesh_hostapd_mld_ap_config {

 # arg_idx will act as indicator of argument position in arg list
 local arg_idx=1 num_vaps=0 cmd=''
 eval arg_value=\$\{$arg_idx\}

 if [ "$arg_value" = "legacy" ]; then
   log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart Legacy VAPs"
   #increment by 1. New value = 2
   arg_idx=$(($arg_idx+1))

   eval arg_value=\$\{$arg_idx\}

   if [ $arg_value == $QCMAP_ALL_AP ]; then
     log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart all Legacy VAPs"
     activate_ezmesh_hostapd_ap_all_config $arg_value
   else
     log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart mentioned Legacy VAPs"

     num_vaps=$arg_value

     for i in $(seq $num_vaps)
     do
       arg_idx=$(($arg_idx+1))
       eval arg_value=\$\{$arg_idx\}
       cmd="${cmd} $arg_value"
     done
     activate_ezmesh_hostapd_ap_config $num_vaps "$cmd"
   fi

   #update arg_idx to '' or 'mlo'
   arg_idx=$(($arg_idx+1))
   eval arg_value=\$\{$arg_idx\}

 fi

 if [ $arg_value = "mlo" ]; then
   log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart MLO VAPs"

   arg_idx=$(($arg_idx+1))
   eval arg_value=\$\{$arg_idx\}
   if [ $arg_value == $QCMAP_ALL_MLD ]; then

     log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart all MLO VAPs"
     activate_ezmesh_hostapd_mld_all_config $arg_value

   else

     log $(basename "$0") "activate_ezmesh_hostapd_mld_ap_config" $LINENO "Request to restart mentioned MLO VAPs"
     num_vaps=$arg_value
     for i in $(seq $num_vaps)
     do
       arg_idx=$(($arg_idx+1))
       eval arg_value=\$\{$arg_idx\}
       mld_iface_list="${mld_iface_list} mld$arg_value"
     done
   fi
 fi


 activate_ezmesh_hostapd_restart // add mlds in activate cmd, then add wifi0, wifi1, wifi2, then restart via multi_up

}


function check_hwmode_11be {
  local tmp band hwmode
  #Get wifi devices.
  local wifi_devices

  if [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
    # HMT doesn't have /sys/class/net/wifiX
    wifi_devices="wifi0 wifi1"
  else
    wifi_devices=$(ls /sys/class/net | grep ^wifi)
  fi
  for device in $wifi_devices
  do
    tmp=$(cfg80211tool $device g_oper_reg_info)
    band=$(echo $tmp | awk '{ print $4 }' | cut -c 6)

    hwmode=$(uci get wireless.$device.hwmode)
    log $(basename "$0") "check_hwmode_11be" $LINENO "hwmode: $hwmode device: $device band: $band"
    if [[ $hwmode == "11be"* ]]; then
      case $band in
      2)
        uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band2=1
        ;;
      5)
        uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band5=1
        ;;
      6)
        uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band6=1
        ;;
      *)
        log $(basename "$0") "check_hwmode_11be" $LINENO " Invalid Band"
      esac
    fi
  done

  # Set hwmode_11be_bandX to 1 as hwmode in HMT default wireless is 11ax*
  if [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
    uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band2=1
    uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band5=1
    uci set qcmap_ezmesh.@ezmesh_mlo[0].hwmode_11be_band6=1
  fi

  uci commit qcmap_ezmesh
}

case $1 in
  set_ezmesh_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_config" $LINENO "set_ezmesh_config"
      #$2 refers to ezmesh enable/disabe, $3 refers to device mode, $4 refers to capability and $5 refers to ap config len
      set_ezmesh_config $2 $3 $4 $5
    fi
    ;;

  set_ezmesh_ap_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_ap_config" $LINENO "set_ezmesh_ap_config"
      #$2 refers to band, $3 refers to guest profile, $4 refers to ezmesh ap type, $5 refers to wlan ap index
      #$6 refers to vap_mode and $7 refers to mld_index
      set_ezmesh_ap_config $2 $3 $4 $5 $6 $7
    fi
    ;;

  set_ezmesh_per_band_count)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_per_band_count" $LINENO "set_ezmesh_per_band_count"
      #$2 refers to no:of 2GHz vaps $3 refers to no:of 5GHz vaps and $4 refers to no:of 6GHz vaps count
      set_ezmesh_per_band_count $2 $3 $4
    fi
    ;;

  set_ezmesh_r2_traffic_separation)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_r2_traffic_separation" $LINENO "set_ezmesh_r2_traffic_separation"
      #$2 refers to traffic separation flag enable/disable
      set_ezmesh_r2_traffic_separation $2
    fi
    ;;

  set_ezmesh_vlan_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_vlan_config" $LINENO "set_ezmesh_vlan_config"
      #$2 refers to no:of vlans, $3 refers to vlan id1, $4 refers to fh ap associated with vlan id1
      #$5 refers to vlan id2, $6 refers to fh ap associated with vlan id2
      #$7 refers to vlan id3, $8 refers to fh ap associated with vlan id3
      #$9 refers to vlan id4 and $10 refers to fh ap associated with vlan id4
      set_ezmesh_vlan_config $2 $3 $4 $5 $6 $7 $8 $9 ${10}
    fi
    ;;

  set_ezmesh_r3_service_priority)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_r3_service_priority" $LINENO "set_ezmesh_r3_service_priority"
      #$2 refers to service priority flag enable/disable
      set_ezmesh_r3_service_priority $2
    fi
    ;;

  set_ezmesh_update_wireless)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] ; then
      log  $(basename "$0") "case:set_ezmesh_update_wireless" $LINENO "set_ezmesh_update_wireless"
      #API is not in use
      set_ezmesh_update_wireless
    fi
    ;;

  set_ezmesh_update_ifaces)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_update_ifaces" $LINENO "set_ezmesh_update_ifaces"
      #This API is responsible for updating athX ifaces to qcmap_ezmesh uci config
      set_ezmesh_update_ifaces
    fi
    ;;

  set_ezmesh_repacd_start)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_start" $LINENO "set_ezmesh_repacd_start"
      #This API is responsible for starting repacd to bring up ezmesh
      set_ezmesh_repacd_start
    fi
    ;;

  set_ezmesh_repacd_stop)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_stop" $LINENO "set_ezmesh_repacd_stop"
      #This API is responsible for stopping repacd to bring down ezmesh
      set_ezmesh_repacd_stop
    fi
    ;;

  set_ezmesh_repacd_restart)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_restart" $LINENO "set_ezmesh_repacd_restart"
      #This API is responsible for re-starting repacd to bring up ezmesh with existing config
      set_ezmesh_repacd_restart
    fi
    ;;

  set_ezmesh_repacd_restore)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_restore" $LINENO "set_ezmesh_repacd_restore"
      set_ezmesh_repacd_restore
    fi
    ;;

  enable_ezmesh_on_bootup)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:enable_ezmesh_on_bootup" $LINENO "enable_ezmesh_on_bootup"
      #This API is responsible for bringing up wifi as part of reboot with ezmesh enabled
      enable_ezmesh_on_bootup
    fi
    ;;

  ezmesh_restart_wwan_profile)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:ezmesh_restart_wwan_profile" $LINENO "ezmesh_restart_wwan_profile"
      #This API is responsible for restarting wwan profile after all ezmesh vlans mapped/un-mapped
      ezmesh_restart_wwan_profile $2
    fi

   ;;

  activate_ezmesh_hostapd_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_config" $LINENO "activate_ezmesh_hostapd_config"
      #$2 refers to no:of vaps count $3 refers to hostapd restart action $4 refers to no:of mlds count
      activate_ezmesh_hostapd_config $2 $3 $4
    fi
    ;;

  activate_ezmesh_hostapd_ap_all_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_ap_all_config" $LINENO "activate_ezmesh_hostapd_ap_all_config"
      #$2 refers to ap type or wlan index which needs to get restarted
      activate_ezmesh_hostapd_ap_all_config $2
    fi
    ;;

  activate_ezmesh_hostapd_ap_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_ap_config" $LINENO "activate_ezmesh_hostapd_ap_config"
      #$2 refers to no:of vaps count
      #$3 onwards refer to ap type or wlan index which needs to get restarted till 21 vaps
      activate_ezmesh_hostapd_ap_config $2 "$3 $4 $5 $6 $7 $8 $9 ${10} ${11} ${12} ${13} ${14} ${15} ${16} ${17} ${18} ${19} ${20} ${21} ${22} ${23}"
    fi
    ;;

  activate_ezmesh_hostapd_mld_all_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_mld_all_config" $LINENO "activate_ezmesh_hostapd_mld_all_config"
      #$2 refers to mld which needs to get restarted. It could be QCMAP_ALL_MLD as well
      activate_ezmesh_hostapd_mld_all_config $2
    fi
    ;;

  activate_ezmesh_hostapd_restart)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_restart" $LINENO "activate_ezmesh_hostapd_restart"
      #This API is responsible for executing wifi_multi_up/down command
      activate_ezmesh_hostapd_restart
    fi
    ;;

  activate_ezmesh_hostapd_mld_ap_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_mld_ap_config" $LINENO "activate_ezmesh_hostapd_mld_ap_config"
      #Arguments
      #[ legacy QCMAP_ALL_AP/<no. of vaps count>   <ap type or wlan indices which need to be restarted till 21 vaps] [ mlo QCMAP_ALL_MLD/<no. of MLDs count>    <mld interface indices which need to be restarted till 21 mlds]
      #[] - optional segment
      #example1 legacy 5
      #example2 mld 2 11 15
      #example3 mld 21
      #example4 legacy 4 1 12 3 2 mld 2 11 15
      #example5 legacy 4 1 12 3 2 mld 21
      #example6 legacy 5 mld 21

      #This API internally calls activate_ezmesh_hostapd_ap_all_config/activate_ezmesh_hostapd_ap_config, then activate_ezmesh_hostapd_mld_all_config, and finally activate_ezmesh_hostapd_restart.

      # remove activate_ezmesh_hostapd_mld_ap_config <37 chars> from arg list and pass args starting at 38th char
      activate_ezmesh_hostapd_mld_ap_config "${@:38}"
    fi
    ;;

  set_ezmesh_extender_network_cfg)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_extender_network_cfg" $LINENO "set_ezmesh_extender_network_cfg"
      #$2 refers to enable/disable extender mode flag value
      set_ezmesh_extender_network_cfg $2
    fi
    ;;

  set_ezmesh_mlo_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_mlo_config" $LINENO "set_ezmesh_mlo_config"
      #$2 refers to enable/disable mlo flag
      #$3 refers to number of different types of VAPs to have mlo config
      #$4 mld index
      #$5 mld type like FronthaulMld, BackhaulMld, etc.
      #and so on. Last argument is MLDConfig string to be updated to repacd

      # remove set_ezmesh_mlo_config <21 chars> from arg list and pass args starting at 22th char
      set_ezmesh_mlo_config "${@:22}"
    fi
    ;;

  check_hwmode_11be)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ] || [ $CDT_WLAN_HMT_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:check_hwmode_11be" $LINENO "check_hwmode_11be"
      check_hwmode_11be
    fi
    ;;

  *)

    log  $(basename "$0") "case: Invalid" $LINENO "Invalid option"
    ;;

esac

