#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

. /etc/data/mbbUtils.sh

CDT_WLAN_WKK_ATTACH=3
CDT_WLAN_HMT_ATTACH=2
CDT_LGA=5

CDT_TYPE=$(cat /sys/devices/soc0/platform_subtype_id)
PLATFORM_VERSION=$(cat /sys/devices/soc0/platform_version)

if [ $CDT_LGA -eq $CDT_TYPE ]; then
  if [ $((${PLATFORM_VERSION}>>16)) -eq 2 ]; then
    CDT_TYPE=$CDT_WLAN_WKK_ATTACH
  elif [ $((${PLATFORM_VERSION}>>16)) -eq 1 ]; then
    CDT_TYPE=$CDT_WLAN_HMT_ATTACH
  fi
fi

##when subtype equals 5 (LGA), need further check platform version wether its HMT or WKK
if [ $CDT_WLAN_WKK_ATTACH -eq $CDT_TYPE ]; then
      /etc/data/wlanConfig_wkk.sh $@
else
      /etc/data/wlanConfig_hmt.sh $@
fi

