#!/bin/sh
#  Copyright (c) 2025 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#Usage: For logging
source /etc/data/mbbUtils.sh

#source common functions and util_execute_uci
. /etc/data/lanUtils.sh

# Usage: ./qosConfig.sh add_qos_dscp_mark_for_dl_sw hdl <handle_value> dscp_mark <mark_value> src_ip <ip addr> dst_ip <dst_ip>
                                                    #sport_start <port no> sport_end <port no> dport_start <port no> dport_end <port no>
# Usage: ./qosConfig.sh del_qos_dscp_mark_for_dl_sw hdl <handle_value> dscp_mark <mark_value> src_ip <ip addr> dst_ip <dst_ip>
                                                    #sport_start <port no> sport_end <port no> dport_start <port no> dport_end <port no>

QCMAP_QOS_HANDLE_STR="hdl"
QCMAP_QOS_DSCP_MARK_STR="dscp_mark"
QCMAP_QOS_SRC_MAC_STR="src_mac"
QCMAP_QOS_SRC_IP_STR="src_ip"
QCMAP_QOS_DEST_IP_STR="dst_ip"
QCMAP_QOS_PROTO_STR="proto"
QCMAP_QOS_SRC_PORT_START_STR="sport_start"
QCMAP_QOS_SRC_PORT_END_STR="sport_end"
QCMAP_QOS_DEST_PORT_START_STR="dport_start"
QCMAP_QOS_DEST_PORT_END_STR="dport_end"

function add_qos_dscp_mark_for_dl_sw() {
  local no_of_args=$#
  local start=1         #start from count 1 till end of args
  local increment=2     #increment by 2 since we read arg_str and arg_value in one instance
  local arg_str arg_value is_valid_rule
  local handle dscp_mark
  local src_mac src_ip dst_ip proto
  local sport_start sport_end dport_start dport_end

  for i in `seq $start $increment $no_of_args`
  do
    arg_str=$1
    shift 1
    arg_value=$1
    shift 1
    case $arg_str in
      $QCMAP_QOS_HANDLE_STR)
        handle=$arg_value
        if [ ! -z "$handle" ]; then
          local idx=0
          local found=0
          while true
          do
            local rule_name=$(uci get firewall.@rule[$idx].name)
            if [ -z "$rule_name" ]; then
              break
            fi
            if [ "$rule_name" = "QoS_$handle" ]; then
              found=1
              break
            fi
            idx=$((idx+1))
          done
          if [ $found -eq 1 ]; then
            log $(basename "$0") "add_qos_dscp_mark_for_dl_sw" $LINENO "DSCP Mark rule is already present for handle=$handle at idx=$idx"
            return
          else
            util_execute_uci add firewall rule
            util_execute_uci_set firewall.@rule[-1].name "QoS_$handle"
            util_execute_uci_set firewall.@rule[-1].target "DSCP"
            util_execute_uci_set firewall.@rule[-1].src "wan"
            util_execute_uci_set firewall.@rule[-1].dest "lan_wan"
            log $(basename "$0") "add_qos_dscp_mark_for_dl_sw" $LINENO "Adding DSCP Mark rule for handle=$handle"
          fi
        else
          log $(basename "$0") "add_qos_dscp_mark_for_dl_sw" $LINENO "Invalid handle=$handle passed, so exiting"
          return
        fi
      ;;
      $QCMAP_QOS_DSCP_MARK_STR)
        dscp_mark=$arg_value
        if [ ! -z "$dscp_mark" ]; then
          util_execute_uci_set firewall.@rule[-1].set_dscp "$dscp_mark"
        fi
      ;;
      $QCMAP_QOS_SRC_MAC_STR)
        src_mac=$arg_value
        if [ ! -z "$src_mac" ]; then
          util_execute_uci_set firewall.@rule[-1].src_mac "$src_mac"
        fi
      ;;
      $QCMAP_QOS_SRC_IP_STR)
        src_ip=$arg_value
        if [ ! -z "$src_ip" ]; then
          util_execute_uci_set firewall.@rule[-1].src_ip "$src_ip"
        fi
      ;;
      $QCMAP_QOS_DEST_IP_STR)
        dst_ip=$arg_value
        if [ ! -z "$dst_ip" ]; then
          util_execute_uci_set firewall.@rule[-1].dest_ip "$dst_ip"
        fi
      ;;
      $QCMAP_QOS_PROTO_STR)
        proto=$arg_value
        if [ ! -z "$proto" ]; then
          util_execute_uci_set firewall.@rule[-1].proto "$proto"
        fi
      ;;
      $QCMAP_QOS_SRC_PORT_START_STR)
        sport_start=$arg_value
      ;;
      $QCMAP_QOS_SRC_PORT_END_STR)
        sport_end=$arg_value
      ;;
      $QCMAP_QOS_DEST_PORT_START_STR)
        dport_start=$arg_value
      ;;
      $QCMAP_QOS_DEST_PORT_END_STR)
        dport_end=$arg_value
      ;;

      *)
        log $(basename "$0") "add_qos_dscp_mark_for_dl_sw" $LINENO "Invalid param passed arg_str=$arg_str, arg_value=$arg_value"
      ;;
    esac
  done

  if [ ! -z "$sport_start" ] && [ ! -z "$sport_end" ]; then
    if [ "$sport_start" == "$sport_end" ] ;then
      util_execute_uci_set firewall.@rule[-1].src_port "$sport_start"
    else
      util_execute_uci_set firewall.@rule[-1].src_port "$sport_start-$sport_end"
    fi
  elif [ ! -z "$sport_start" ]; then
    util_execute_uci_set firewall.@rule[-1].src_port "$sport_start"
  elif [ ! -z "$sport_end" ]; then
    util_execute_uci_set firewall.@rule[-1].src_port "$sport_end"
  fi

  if [ ! -z "$dport_start" ] && [ ! -z "$dport_end" ]; then
    if [ "$dport_start" == "$dport_end" ] ;then
      util_execute_uci_set firewall.@rule[-1].dest_port "$dport_start"
    else
      util_execute_uci_set firewall.@rule[-1].dest_port "$dport_start-$dport_end"
    fi
  elif [ ! -z "$dport_start" ]; then
    util_execute_uci_set firewall.@rule[-1].dest_port "$dport_start"
  elif [ ! -z "$dport_end" ]; then
    util_execute_uci_set firewall.@rule[-1].dest_port "$dport_end"
  fi

  uci commit firewall
  /etc/init.d/firewall reload
}

function del_qos_dscp_mark_for_dl_sw() {
  shift 1           #skip the first arg 'hdl'
  local handle=$1
  local idx=0
  local found=0

  if [ ! -z "$handle" ]; then
    log $(basename "$0") "del_qos_dscp_mark_for_dl_sw" $LINENO "Deleting DSCP Mark rule for handle=$handle"
    while true
    do
      local rule_name=$(uci get firewall.@rule[$idx].name)
      if [ -z "$rule_name" ]; then
        break
      fi
      if [ "$rule_name" = "QoS_$handle" ]; then
        found=1
        break
      fi
      idx=$((idx+1))
    done
    if [ $found -eq 1 ]; then
      util_execute_uci delete firewall.@rule[$idx]
      uci commit firewall
      /etc/init.d/firewall reload
    fi
  else
    log $(basename "$0") "del_qos_dscp_mark_for_dl_sw" $LINENO "Invalid handle=$handle passed, so exiting"
    return
  fi
}

case $1 in
  add_qos_dscp_mark_for_dl_sw)
    #Remove add_qos_dscp_mark_for_dl_sw string which is of 27 chars from argument list and pass args starting at 28th char
    add_qos_dscp_mark_for_dl_sw "${@:28}"
    ;;
  del_qos_dscp_mark_for_dl_sw)
    #Remove del_qos_dscp_mark_for_dl_sw string which is of 27 chars from argument list and pass args starting at 28th char
    del_qos_dscp_mark_for_dl_sw "${@:28}"
    ;;
  *)
    logger "Invalid option"
    ;;
esac

