#!/bin/sh

LOCK_FILE=/var/run/ql_wanlan_adapt_sh.lock

function do_wanlan_adapt
{
    link_up_ifname=$1
    found_nic_index=
    detected_wan_proto=
    detected_wan_ifname=
    current_conf=
    current_wan_proto=
    new_conf=
    reload=
    all_ifnames=

    for i in $(seq 0 1); do
        ifname=$(uci get qcmap_lan.@eth_nic_config[$i].ifname)
        if [ "$ifname" == "$link_up_ifname" ]; then
            found_nic_index=$i
        fi

        if [ -n "$all_ifnames" ]; then
            all_ifnames=$all_ifnames,$ifname
        else
            all_ifnames=$ifname
        fi
    done

    logger -t wanlan_adapt $link_up_ifname up

    if [ -z "$found_nic_index" ]; then
        return
    fi

    while read line; do
        detected_wan_ifname=$(echo "$line" | cut -d ':' -f 1)
        detected_wan_proto=$(echo "$line" | cut -d ' ' -f 2)

        if [ "$detected_wan_proto" != "dhcp" -a "$detected_wan_proto" != "pppoe" ]; then
            detected_wan_proto=
            detected_wan_ifname=
            continue
        else
            logger -t wanlan_adapt detected $detected_wan_ifname $detected_wan_proto
            break
        fi
    done < <(ql_detect_wan $all_ifnames)

    for i in $(seq 0 1); do
        type=$(uci get qcmap_lan.@eth_nic_config[$i].type)
        if [ $type -eq 1 ]; then
            type=WAN
            current_wan_proto=$(uci get network.waneth.proto)
        else
            type=LAN
        fi

        ifname=$(uci get qcmap_lan.@eth_nic_config[$i].ifname)

        if [ -n "$current_conf" ]; then
            current_conf=$current_conf,$ifname,$type
        else
            current_conf=$ifname,$type
        fi

        new_type=LAN
        if [ "$ifname" == "$detected_wan_ifname" ]; then
            new_type=WAN
        fi

        if [ -n "$new_conf" ]; then
            new_conf=$new_conf,$ifname,$new_type
        else
            new_conf=$ifname,$new_type
        fi

    done

    logger -t wanlan_adapt "current_conf" $current_conf $current_wan_proto
    logger -t wanlan_adapt "new_conf" $new_conf $detected_wan_proto

    if [ "$current_wan_proto" != "$detected_wan_proto" ]; then
        uci set network.waneth.proto=$detected_wan_proto

        if [ "$detected_wan_proto" == "pppoe" ]; then
            # For servers that require authentication, customers need to set their own accounts and passwords.
            # For servers that do not require authentication, set any account and password here.
            uci set network.waneth.username="test"
            uci set network.waneth.password="123"
        fi

        reload=1
    fi

    if [ "$new_conf" != "$current_conf" ]; then
        ql_qcmap_cli wan_lan $new_conf
        reload=1
    fi

    if [ -n "$reload" ]; then
        uci commit network
        /etc/init.d/network reload
    fi
}


enable=$(uci get ql_cust_config.@qcmap_configs[0].wanlan_adapt_enable)

if [ "$enable" == "1" ]; then

    exec 200>"$LOCK_FILE"
    if ! flock -n 200; then
        exit
    fi

    do_wanlan_adapt $1
fi