#!/bin/sh
#  Copyright (c) 2025 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

. /etc/data/mbbUtils.sh

function util_run_command() {
    local cmd="$1"  # First parameter: the command to run
    log  $(basename "$0") "util_run_command" $LINENO "$*"

    shift           # Shift the parameters to remove the first one (the command)

    # Execute the command with remaining arguments
    "$cmd" "$@"
}

function install_dhcp_ebtables_rule()
{
   if ebtables -L | grep -q "67:68"; then
      log $(basename "$0") "install_ebtables_non_bridge_mode" $LINENO "ebtables rules for dhcp forward drop already present"
   else
     util_run_command ebtables -I FORWARD -p IPv4 --ip-protocol udp --ip-destination-port 67:68 -j DROP
   fi

   if ebtables -L | grep -q "ip6-icmp-type"; then
      log $(basename "$0") "install_ebtables_non_bridge_mode" $LINENO "ebtables rules for ICMPv6 RA/RS forward drop already present"
   else
     util_run_command ebtables -I FORWARD -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 134 -j DROP
     util_run_command ebtables -I FORWARD -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 133 -j DROP
   fi

}

function uninstall_dhcp_ebtables_rule()
{
  #delete IPv6 RA/RS forward chain drop rule: station bridge mode we forward RS/RA directly
  util_run_command ebtables -I FORWARD -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 134 -j DROP
  util_run_command ebtables -I FORWARD -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 133 -j DROP

  #IPv4 DHCP forward chain drop rule no need delete, we always need it
  #station bridge mode we still have dnsmasq act as dhcp proxy
}

function apply_ebtables_rules()
{
  local dhcp_proxy=$(uci -q get dhcp.lan.dhcp_proxy)
  if [ "$dhcp_proxy" == "1" ];then
    uninstall_dhcp_ebtables_rule
  else
    install_dhcp_ebtables_rule
  fi
}

apply_ebtables_rules

