#!/bin/sh

# Copyright (c) 2023 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.

pid=""

if [ "$1" == "0" ] ; then
  touch /etc/data/mtpe_db.csv
  chmod a+rw /etc/data/mtpe_db.csv

# kill a TCP or PING test sub-process by search-terms
elif [ "$1" == "1" ] ; then
  if [ "$2" == "0" ] ; then
    # search for ping test by address
    ps | grep -i "$3" | awk '{printf "%s\n", $1}' | head -n -1 | xargs kill -9
  else
    ps | grep -i "$2" | awk '{printf "%s\n", $1}' | head -n -1 | xargs kill -9
  fi

# get ip address from url and store it in temporary file
elif [ "$1" == "2" ] ; then
  rm /tmp/mtpe_ip_address.txt
  nslookup -query=A $2 | awk '/Address/ && NR==6 {print $2}' > /tmp/mtpe_ip_address.txt
elif [ "$1" == "3" ] ; then
  rm /tmp/mtpe_ip_address.txt
  nslookup -query=AAAA $2 | awk '/Address/ && NR==6 {print $2}' > /tmp/mtpe_ip_address.txt
else
  exit 1
fi
