#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#  Usage: bt_tethering.sh bring_up_bt bt_tethering_mode
#  Usage: bt_tethering.sh bring_down_bt bt_tethering_mode

#source log file.
. /etc/data/mbbUtils.sh
. /etc/data/lanUtils.sh

eval static_ip_bt="169.254.5.1"

QCMAP_BT_Tethering_MODE_LAN=0
QCMAP_BT_Tethering_MODE_WAN=1


if [[ "$#" -le 0 ]]; then
    log  $(basename "$0") $LINENO ": Usage " "bt_tethering.sh bring_up_bt mode"
    log  $(basename "$0") $LINENO ": Usage " "bt_tethering.sh bring_down_bt mode"
    return 1
elif [ \( "$1" == "bring_up_bt" \) -a \( "$#" -ne 2 \) ]; then
    log  $(basename "$0") $LINENO ": Usage " "bt_tethering.sh bring_up_bt mode"
    return 1
elif [ \( "$1" == "bring_down_bt" \) -a \( "$#" -ne 2 \) ]; then
    log  $(basename "$0") $LINENO ": Usage " "bt_tethering.sh bring_down_bt mode"
    return 1
fi


#Set BT Config to network for LAN mode.
function utility_network_bt_interface_LAN() {
  local bt_up=$1
  local ipaddr=$2
  local ifname_list

  if [ $bt_up -eq 1 ] ; then
    log $(basename "$0") "utility_network_bt_interface_LAN" $LINENO "Add bt-pan lan configuration in network"
    ifname_list=$(util_execute_uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')    #Remove first/last and trailing spaces if any
    ifname_list="${ifname_list} bt-pan"
    util_execute_uci_set network.lan.ifname "$ifname_list"
    util_execute_uci set network.bt="interface"
    util_execute_uci set network.bt.device="bt-pan"
    util_execute_uci set network.bt.proto="static"
    util_execute_uci set network.bt.ipaddr=$ipaddr
    util_execute_uci set network.bt.netmask="255.255.255.0"

  elif [ $bt_up -eq 0 ] ; then
    log $(basename "$0") "utility_network_bt_interface_LAN" $LINENO "Del bt-pan lan configuration in network"
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/bt-pan//)
    util_execute_uci_set network.lan.ifname "$ifname_list"
    util_execute_uci delete network.bt

  fi
  util_execute_uci commit network
}

#Set BT Config to network for WAN mode.
function utility_network_bt_interface_WAN() {
  local bt_up=$1
  local wanbt_status=`util_execute_uci -q get qcmap_lan.@mwan3track[0].wanbt`

  log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "utility_network_wlan_interface_WAN for bt-pan"
  if [ $bt_up -eq 1 ] ; then
  log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "Add bt-pan wan configuration in network"
    util_execute_uci set network.wanbt="interface"
    util_execute_uci set network.wanbt.device="bt-pan"
    util_execute_uci set network.wanbt.proto="dhcp"
    util_execute_uci commit network

    if [ $wanbt_status -eq 0 ] ; then
      log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "usr default cfg wanbt disabled, need to enable wanbt mwan3track"
      util_execute_uci set mwan3.wanbt.enabled='1'
      util_execute_uci set mwan3.wanbt_v6.enabled='1'
      util_execute_uci commit mwan3
      qcmap_reload_mwan3
    elif [ $wanbt_status -eq 1 ] ; then
      log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "usr default cfg wanbt enabled, no need to enable wanbt mwan3track"
      return
    fi

  elif [ $bt_up -eq 0 ] ; then
    log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "Del bt-pan wan configuration in network"
    util_execute_uci delete network.wanbt
    util_execute_uci commit network

    if [ $wanbt_status -eq 0 ] ; then
      log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "usr default cfg wanbt disabled, need to disable wanbt mwan3track"
      util_execute_uci set mwan3.wanbt.enabled='0'
      util_execute_uci set mwan3.wanbt_v6.enabled='0'
      util_execute_uci commit mwan3
      qcmap_reload_mwan3
    elif [ $wanbt_status -eq 1 ] ; then
      log $(basename "$0") "utility_network_bt_interface_WAN" $LINENO "usr default cfg wanbt enabled, no need to disable wanbt mwan3track"
      return
    fi
  fi
}

#Bring up BT Tethering.
function BringupBTTethering() {
  local bt_tethering_mode=$1

  if [ $bt_tethering_mode == $QCMAP_BT_Tethering_MODE_LAN ] ; then
    utility_network_bt_interface_LAN 1 $(eval "echo \${static_ip_bt}")
  elif [ $bt_tethering_mode == $QCMAP_BT_Tethering_MODE_WAN ] ; then
    utility_network_bt_interface_WAN 1
  fi

  ubus call network reload
}

#Bring down BT Tethering.
function BringdownBTTethering() {
  local bt_tethering_mode=$1

  if [ $bt_tethering_mode == $QCMAP_BT_Tethering_MODE_LAN ] ; then
    utility_network_bt_interface_LAN 0 $(eval "echo \${static_ip_bt}")
  elif [ $bt_tethering_mode == $QCMAP_BT_Tethering_MODE_WAN ] ; then
    utility_network_bt_interface_WAN 0
  fi

  ubus call network reload
}

case $1 in
  bring_up_bt)
    BringupBTTethering $2
    ;;
  bring_down_bt)
    BringdownBTTethering $2
    ;;
  *)
    log $(basename "$0") $LINENO "case: " "Invalid option"
    ;;
esac
