#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh

#source common functions
. /etc/data/lanUtils.sh

[ -z "$1" ] && echo "No event provided" && return 1

function eth_pdu_mode_enable() {
    local default_ifname
    local eth_idx=$1
    local tsn_mode=$2
    log $(basename "$0") "eth_pdu_mode_enable()" $LINENO "eth pdu mode set to enable."
    #Save the exisiting default lan ifname
    default_ifname=$(util_execute_uci get network.lan.ifname)
    util_execute_uci_set qcmap_lan.@eth_pdu[0].default_ifname "$default_ifname"
    util_execute_uci_set network.lan.ifname eth$eth_idx
    util_execute_uci delete network.lan.ipaddr
    util_execute_uci delete network.lan.netmask

    if [ $eth_idx -eq 0 ]; then
      util_execute_uci delete network.eth.ipaddr
      util_execute_uci delete network.eth.netmask
      util_execute_uci delete network.eth_nic2
    fi

    if [ $eth_idx -eq 1 ]; then
      util_execute_uci delete network.eth_nic2.ipaddr
      util_execute_uci delete network.eth_nic2.netmask
      util_execute_uci delete network.eth
    fi

    util_execute_uci_set network.dummy interface
    util_execute_uci_set network.dummy.device eth$eth_idx
    util_execute_uci_set network.lan.vlan_filtering 1
    util_execute_uci commit network
    #configure qcmap_lan
    util_execute_uci_set qcmap_lan.@eth_pdu[0].enable 1
    util_execute_uci_set qcmap_lan.@eth_pdu[0].eth_device_index $eth_idx
    util_execute_uci_set qcmap_lan.@eth_pdu[0].tsn_mode $tsn_mode
    util_execute_uci commit qcmap_lan
    if [ $tsn_mode -eq 1 ]; then
      ipa tsn enable
    fi

}

function eth_pdu_mode_disable() {
    local default_ifname
    log $(basename "$0") "eth_pdu_mode_disable()" $LINENO "eth pdu mode set to disable."
    #get default ifname.
    default_ifname=$(util_execute_uci get qcmap_lan.@eth_pdu[0].default_ifname)
    util_execute_uci_set network.lan.ifname "$default_ifname"
    util_execute_uci_set network.lan.ipaddr 192.168.224.1
    util_execute_uci_set network.lan.netmask 255.255.254.0
    util_execute_uci_set network.eth interface
    util_execute_uci_set network.eth.device eth0
    util_execute_uci_set network.eth.proto static
    util_execute_uci_set network.eth.ipv6 "1"
    util_execute_uci_set network.eth.ipaddr 169.254.22.1
    util_execute_uci_set network.eth.netmask 255.255.255.0
    util_execute_uci_set network.eth_nic2 interface
    util_execute_uci_set network.eth_nic2.device eth1
    util_execute_uci_set network.eth_nic2.proto static
    util_execute_uci_set network.eth_nic2.ipaddr 169.254.23.1
    util_execute_uci_set network.eth_nic2.ipv6 "1"
    util_execute_uci_set network.eth_nic2.netmask 255.255.255.0
    util_execute_uci delete network.lan.vlan_filtering
    util_execute_uci delete network.dummy
    util_execute_uci commit network
    #configure qcmap_lan
    util_execute_uci_set qcmap_lan.@eth_pdu[0].enable 0
    util_execute_uci_set qcmap_lan.@eth_pdu[0].eth_device_index $1
    util_execute_uci_set qcmap_lan.@eth_pdu[0].tsn_mode $2
    util_execute_uci commit qcmap_lan
    ipa tsn disable
}

function eth_pdu_link_config() {
    local current_ethpdu_mode
    local current_device_idx
    local current_tsn_mode
    local new_device_idx=$1
    local new_tsn_mode=$2
    log $(basename "$0") "eth_pdu_link_config()" $LINENO "update eth pdu link mode.idx: $new_device_idx, tsn mode: $new_tsn_mode"
    #get current eth pdu mode.
    current_ethpdu_mode=$(util_execute_uci get qcmap_lan.@eth_pdu[0].enable)
    if [ $current_ethpdu_mode -eq 0 ]; then
      return 1
    fi
    current_device_idx=$(util_execute_uci get qcmap_lan.@eth_pdu[0].eth_device_index)
    current_tsn_mode=$(util_execute_uci get qcmap_lan.@eth_pdu[0].tsn_mode)

    util_execute_uci_set network.dummy.device eth$new_device_idx
    util_execute_uci commit network

    if [ $current_device_idx -ne $new_device_idx ]; then
      log $(basename "$0") "eth_pdu_link_config()" $LINENO "update eth device index."
      util_execute_uci_set qcmap_lan.@eth_pdu[0].eth_device_index $new_device_idx
      #toggling eth device to let server refresh the index
      ifconfig eth$new_device_idx down
      sleep 1
      ifconfig eth$new_device_idx up
    fi

    if [ $current_tsn_mode -ne $new_tsn_mode ]; then
      log $(basename "$0") "eth_pdu_link_config()" $LINENO "update tsn mode."
      util_execute_uci_set qcmap_lan.@eth_pdu[0].tsn_mode $new_tsn_mode
      if [ $new_tsn_mode -eq 0 ];then
        ipa tsn disable
      fi

      if [ $new_tsn_mode -eq 1 ];then
        ipa tsn enable
      fi
      #need to reboot to make the configuration active.
	  util_execute_uci commit qcmap_lan
      sleep 1
      reboot
    fi

    util_execute_uci commit qcmap_lan
}


function eth_pdu_bootup_cfg() {
    log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "bootup configure."
    #0.1 set pvid value to be 0 for all bridge interfaces as WA for WKK VLAN tag issue.
    echo   0 > /sys/class/net/br-lan/bridge/default_pvid
    #0.2 set pvid value to all vlan bridges
    max=$(util_execute_uci get qcmap_lan.@no_of_configs[0].no_of_vlans)
    log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "total vlan bridges: $max."
    if [ $max -gt 0 ]; then
        for i in $(seq $max)
        do
            vlan_id=$(util_execute_uci get qcmap_lan.@vlan[$((i-1))].vlan_id)
            echo   0 > /sys/class/net/br-lan$vlan_id/bridge/default_pvid
            log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "config default pvid value for vlan id: $vlan_id."
        done
    fi

    #1. get totoal number of bridge-vlan and delete them
    total_br_vlan_info_num=$(grep bridge-vlan /etc/config/network | wc -l)
    log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "total vlan info in network: $total_br_vlan_info_num."
    if [ $total_br_vlan_info_num -gt 0 ];then
        for i in $(seq 0 $((total_br_vlan_info_num-1)))
        do
            log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "delete vlan info."
            util_execute_uci delete network.@bridge-vlan[-1]
        done
    fi
    util_execute_uci commit network
    ubus call network reload
    #2. get total number of call info and delete the info from network
    CallNum=$(grep EthPduCallInfo /etc/config/qcmap_lan | wc -l)
    EthDeviceIndex=$(util_execute_uci get qcmap_lan.@eth_pdu[0].eth_device_index)
    EthPduMode=$(util_execute_uci get qcmap_lan.@eth_pdu[0].enable)
    log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "total call number in qcmap_lan: $CallNum.eth pdu mode:$EthPduMode,device index:$EthDeviceIndex."
    if [ $CallNum -gt 0 ];then
        for j in $(seq 0 $((CallNum-1)))
        do
            profileiHandle=$(util_execute_uci get qcmap_lan.@EthPduCallInfo[$j].profile)
            EthPduIfname=$(util_execute_uci get qcmap_lan.@EthPduCallInfo[$j].EthPduIfName)
            log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "get profile: $profileiHandle, ifname: $EthPduIfname from in call info at index: $j"
            #delete device rmnet_ethX from wanX interface
            util_execute_uci delete network.wan"$profileiHandle".device
        done
    fi

    # No need to set the network lan config as it will be updated as part of disable/enable ETH PDU
    #eth pdu mode disable case,set default ifname
    #if [ $EthPduMode -eq 0 ]; then
    #  util_execute_uci_set network.lan.ifname 'eth0 eth1 ecm0 rndis0'
    #fi

    #eth pdu mode enable case,set ifname per device index
    if [ $EthPduMode -eq 1 ]; then
      util_execute_uci_set network.lan.ifname eth$EthDeviceIndex
    fi

    util_execute_uci commit network
    ubus call network reload

    if [ $CallNum -gt 0 ];then
        for k in $(seq 0 $((CallNum-1)))
        do
            log $(basename "$0") "eth_pdu_bootup_cfg()" $LINENO "delete call info from qcmap_lan at index: $k"
            util_execute_uci delete qcmap_lan.@EthPduCallInfo[-1]
        done
        util_execute_uci commit qcmap_lan
    fi
}

case "$1" in
    enable)
      eth_pdu_mode_enable $2 $3
    ;;
    disable)
      eth_pdu_mode_disable $2 $3
    ;;
    ethpdu_link_config)
      eth_pdu_link_config $2 $3
    ;;
    ethpdu_bootup_cfg)
      eth_pdu_bootup_cfg
    ;;
    *)
    log $(basename "$0") "backhaulEthPduConfig.sh" $LINENO "Invalid option"
    ;;
esac
