#!/bin/sh
#  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
#  All rights reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.


#source NetIfD related files
. /lib/functions.sh
. /lib/functions/network.sh
. /lib/netifd/netifd-proto.sh

#source lanUtils.sh
. /etc/data/lanUtils.sh

[ -z "$1" ] && echo "No event provided" && return 1

function set_eogre_config() {
    uci set qcmap_lan.@eogre_info[0].ep_ip_family=$1
    uci set qcmap_lan.@eogre_info[0].ep_dst_addr=$2

    uci commit qcmap_lan
    log $(basename "$0")":set_eogre_config:"$LINENO":EoGRE interface config set successfully"
}

function create_tunnel() {
    local ip_family=$(uci get qcmap_lan.@eogre_info[0].ep_ip_family)
    local dst_addr=$(uci get qcmap_lan.@eogre_info[0].ep_dst_addr)
    local eogre_tunnel_up=$(uci get qcmap_lan.@eogre_info[0].eogre_tunnel_up)
    local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)
    local profile_id=-1
    local ifname=$(uci get network.lan.ifname)
    profile_id=$(util_get_default_pdn)

    if [ -z $dst_addr ] || [ $eogre_tunnel_up -ne 0 ]; then
      log $(basename "$0") "create_tunnel:" $LINENO "No dst_addr/tunnel up, exiting!"
      exit 1
    fi

    uci delete network.lan.ipaddr
    uci delete network.lan.netmask
    uci set network.lan.ifname="$ifname "@gretap2
    uci set network.gretap2="interface"
    if [ "$eogre_encap_limit" != "none" ]; then
      ipa -X EoGREOptionV6 enable
      uci set network.gretap2.encaplimit=$eogre_encap_limit
    else
      ipa -X EoGREOptionV6 disable
    fi

    if [ $profile_id -eq -1 ]; then
      log $(basename "$0") "create_tunnel:" $LINENO "No default pdn, exiting!"
      exit 1
    else
      if [ $ip_family -eq 4 ]; then
           [ -f /tmp/ipv4config$profile_id ] && . /tmp/ipv4config$profile_id
           ip=$PUBLIC_IP
           mtu=$IPV4MTU

           uci set network.gretap2.ipaddr=$ip
           uci set network.gretap2.peeraddr=$dst_addr
           uci set network.gretap2.proto="gretap"
           uci set qcmap_lan.@eogre_info[0].ep_src_addr=$ip
      elif [ $ip_family -eq 6 ]; then
           [ -f /tmp/ipv6config$profile_id ] && . /tmp/ipv6config$profile_id
           ip6=$PUBLIC_IP6
           mtu=$IPV6MTU

           uci set network.gretap2.ip6addr=$ip6
           uci set network.gretap2.peer6addr=$dst_addr
           uci set network.gretap2.proto="grev6tap"
           uci set qcmap_lan.@eogre_info[0].ep_src_addr=$ip6
      fi
      uci set qcmap_lan.@eogre_info[0].eogre_tunnel_up=1
      update_eogre_tunnel_mtu $profile_id $ip_family $mtu
      ubus call network reload
      log $(basename "$0") "create_tunnel:" $LINENO "EoGRE tunnel created successfully"
    fi
}

function add_vlan_pcp_to_dscp_map() {

    local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)
    local idx
    if [ $2 -eq 0 ]; then
      idx=$(($2+1))
    else
     idx=$(uci get qcmap_lan.@eogre_info[0].vlan_pcp_idx)
     idx=$((idx+1))
    fi
    uci set qcmap_lan.@eogre_info[0].vlan_id$idx=$3
    uci set qcmap_lan.@eogre_info[0].pcp$idx=$4
    uci set qcmap_lan.@eogre_info[0].dscp$idx=$5
    uci set qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length=$(($2+1))
    uci set qcmap_lan.@eogre_info[0].vlan_pcp_idx=$idx
    uci commit qcmap_lan
    log $(basename "$0")":Add_vlan_and_pcp_to_dscp:"$LINENO":Vlan, PCP to DSCP mapping added"

    if [ $1 == 1 ]; then
      local ip_family=$(uci get qcmap_lan.@eogre_info[0].ep_ip_family)
      local dev_name
      local profile_id=-1

      profile_id=$(util_get_default_pdn)
      if [ $profile_id -eq -1 ]; then
        log $(basename "$0") "add_vlan_pcp_to_dscp_map:" $LINENO "No default pdn, exiting!"
        exit 1
      fi
      #Source config file
      config_file_name=/tmp/ipv${ip_family}config${profile_id}
      [ -f "$config_file_name" ] && . "$config_file_name"
      dev_name=$IFNAME

      if [ $ip_family -eq 4 ]; then
        iptables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x24&0xff00>>0xd=$4 && 0x24&0xfff=$3" -j DSCP --set-dscp $5
      elif [ $ip_family -eq 6 ]; then
        if [ "$eogre_encap_limit" == "none" ]; then
          ip6tables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x38&0xff00>>0xd=$4 && 0x38&0xfff=$3" -j DSCP --set-dscp $5
        else
          ip6tables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x40&0xff00>>0xd=$4 && 0x40&0xfff=$3" -j DSCP --set-dscp $5
        fi
      fi
      log $(basename "$0")":Add_vlan_and_pcp_to_dscp:"$LINENO":Installed Vlan, PCP to DSCP mapping rules"
    fi
}

function install_all_vlan_and_pcp_to_dscp_rules() {
    local vlan_pcp_to_dscp_length=$(uci get qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length)
    local ip_family=$(uci get qcmap_lan.@eogre_info[0].ep_ip_family)
    local eogre_tunnel_up=$(uci get qcmap_lan.@eogre_info[0].eogre_tunnel_up)
    local dev_name
    local profile_id=-1
    local idx
    local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)
    local vlan_string=""

    profile_id=$(util_get_default_pdn)
    if [ $profile_id -eq -1 ]; then
      log $(basename "$0") "install_all_vlan_and_pcp_to_dscp_rules:" $LINENO "No default pdn, exiting!"
      exit 1
    fi
    #Source config file
    config_file_name=/tmp/ipv${ip_family}config${profile_id}
    [ -f "$config_file_name" ] && . "$config_file_name"
    dev_name=$IFNAME

    if [ -n $vlan_pcp_to_dscp_length ] && [ -n $eogre_tunnel_up ]; then
      idx=$vlan_pcp_to_dscp_length
      for i in $(seq 1 $idx)
      do
        local vlan_id=$(uci get qcmap_lan.@eogre_info[0].vlan_id$i)
        local pcp=$(uci get qcmap_lan.@eogre_info[0].pcp$i)
        local dscp=$(uci get qcmap_lan.@eogre_info[0].dscp$i)
        
        vlan_string="$vlan_string $vlan_id $pcp $dscp"
        
        if [ $ip_family -eq 4 ]; then
          iptables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x24&0xff00>>0xd=$pcp && 0x24&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
        elif [ $ip_family -eq 6 ]; then
          if [ "$eogre_encap_limit" == "none" ]; then
            ip6tables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x38&0xff00>>0xd=$pcp && 0x38&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
          else
            ip6tables -t mangle -A POSTROUTING -o $dev_name -m u32 --u32 "0x40&0xff00>>0xd=$pcp && 0x40&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
          fi
        fi
      done
    ipa dscpvlanpcpmap add num_vlan $vlan_pcp_to_dscp_length$vlan_string
    fi
    log $(basename "$0")":install_vlan_and_pcp_to_dscp_rules:"$LINENO":Installed Vlan, PCP to DSCP mapping rules"
}

function delete_vlan_pcp_to_dscp_map() {

    local vlan_pcp_to_dscp_length=$(uci get qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length)
    local idx
    local length
    local dscp=0
    local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)

    if [ -n $vlan_pcp_to_dscp_length ]; then
      idx=$(uci get qcmap_lan.@eogre_info[0].vlan_pcp_idx)
      length=$vlan_pcp_to_dscp_length
      for i in $(seq 1 $idx)
      do
        if [ -n $(uci get qcmap_lan.@eogre_info[0].vlan_id$i) ]; then
          if [ $2 -eq $(uci get qcmap_lan.@eogre_info[0].vlan_id$i) ] && [ $3 -eq $(uci get qcmap_lan.@eogre_info[0].pcp$i) ]; then
            uci delete qcmap_lan.@eogre_info[0].vlan_id$i
            uci delete qcmap_lan.@eogre_info[0].pcp$i
            dscp=$(uci get qcmap_lan.@eogre_info[0].dscp$i)
            uci delete qcmap_lan.@eogre_info[0].dscp$i
            uci set qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length=$((length-1))
            log $(basename "$0")":delete_vlan_pcp_to_dscp_map:"$LINENO":Vlan, PCP to DSCP mapping deleted"
            break
          fi
        fi
      done
      if [ -z $(uci get qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length) ]; then
         uci set qcmap_lan.@eogre_info[0].vlan_pcp_idx=0
      fi
      uci commit qcmap_lan
    fi

    if [ $1 == 1 ]; then
      local ip_family=$(uci get qcmap_lan.@eogre_info[0].ep_ip_family)
      local dev_name
      local profile_id=-1

      profile_id=$(util_get_default_pdn)
      if [ $profile_id -eq -1 ]; then
        log $(basename "$0") "delete_vlan_pcp_to_dscp_map:" $LINENO "No default pdn, exiting!"
        exit 1
      fi
      #Source config file
      config_file_name=/tmp/ipv${ip_family}config${profile_id}
      [ -f "$config_file_name" ] && . "$config_file_name"
      dev_name=$IFNAME

      if [ $ip_family -eq 4 ]; then
        iptables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x24&0xff00>>0xd=$3 && 0x24&0xfff=$2" -j DSCP --set-dscp $dscp
      elif [ $ip_family -eq 6 ]; then
        if [ "$eogre_encap_limit" == "none" ]; then
          ip6tables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x38&0xff00>>0xd=$3 && 0x38&0xfff=$2" -j DSCP --set-dscp $dscp
        else
          ip6tables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x40&0xff00>>0xd=$3 && 0x40&0xfff=$2" -j DSCP --set-dscp $dscp
        fi
      fi
      log $(basename "$0")":delete_vlan_pcp_to_dscp_map:"$LINENO":Vlan, PCP to DSCP mapping rule deleted"
    fi
}

function delete_all_vlan_and_pcp_to_dscp_rules() {

    local vlan_pcp_to_dscp_length=$(uci get qcmap_lan.@eogre_info[0].vlan_pcp_to_dscp_length)
    local ip_family=$(uci get qcmap_lan.@eogre_info[0].ep_ip_family)
    local dev_name
    local profile_id=-1
    local idx
    local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)

    profile_id=$(util_get_default_pdn)
    if [ $profile_id -eq -1 ]; then
      log $(basename "$0") "delete_all_vlan_and_pcp_to_dscp_rules:" $LINENO "No default pdn, exiting!"
      exit 1
    fi
    #Source config file
    config_file_name=/tmp/ipv${ip_family}config${profile_id}
    [ -f "$config_file_name" ] && . "$config_file_name"
    dev_name=$IFNAME

    if [ -n $vlan_pcp_to_dscp_length ]; then
      idx=$vlan_pcp_to_dscp_length
      for i in $(seq 1 $idx)
      do
        local vlan_id=$(uci get qcmap_lan.@eogre_info[0].vlan_id$i)
        local pcp=$(uci get qcmap_lan.@eogre_info[0].pcp$i)
        local dscp=$(uci get qcmap_lan.@eogre_info[0].dscp$i)

        if [ $ip_family -eq 4 ]; then
          iptables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x24&0xff00>>0xd=$pcp && 0x24&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
        elif [ $ip_family -eq 6 ]; then
          if [ "$eogre_encap_limit" == "none" ]; then
            ip6tables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x38&0xff00>>0xd=$pcp && 0x38&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
          else
            ip6tables -t mangle -D POSTROUTING -o $dev_name -m u32 --u32 "0x40&0xff00>>0xd=$pcp && 0x40&0xfff=$vlan_id" -j DSCP --set-dscp $dscp
          fi
        fi
      done
      log $(basename "$0")":delete_all_vlan_and_pcp_to_dscp_rules:"$LINENO":Vlan, PCP to DSCP mapping rules deleted"
      ipa dscpvlanpcpmap del
    fi
}

function destroy_tunnel() {
  local lan_ifname=$(uci get network.lan.ifname)
  local ifname

  ifname=$(echo "$lan_ifname" | sed "s/ @gretap2//g" | sed "s/@gretap2//g" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')
  uci set network.lan.ifname="$ifname"
  uci delete network.gretap2
  uci delete qcmap_lan.@eogre_info[0].ep_src_addr
  uci set qcmap_lan.@eogre_info[0].eogre_tunnel_up=0

  local gw_ip=$(uci get qcmap_lan.lan.ip)
  local net_mask=$(uci get qcmap_lan.lan.netmask)

  #Update gw_ip and netmask in network config
  uci set network.lan.ipaddr="$gw_ip"
  uci set network.lan.netmask="$net_mask"

  uci commit qcmap_lan
  uci commit network
  ubus call network reload
  log $(basename "$0") "destroy_tunnel:" $LINENO "EoGRE tunnel destroyed successfully"
}

function update_eogre_tunnel_mtu() {
  local profile_id=-1
  profile_id=$(util_get_default_pdn)
  local eogre_encap_limit=$(uci get qcmap_lan.@no_of_configs[0].eogre_encap_limit)

  if [ $profile_id -eq -1 ]; then
    log $(basename "$0") "update_eogre_tunnel_mtu:" $LINENO "No default pdn, exiting!"
    exit 1
  elif [ $profile_id -ne $1 ]; then
    log $(basename "$0") "update_eogre_tunnel_mtu:" $LINENO "MTU update not for default pdn, exiting!"
    exit 1
  else
    if [ $2 -eq 4 ]; then
        uci set network.gretap2.mtu=$(($3-42))
    elif [ $2 -eq 6 ]; then
        if [ "$eogre_encap_limit" != "none" ]; then
            uci set network.gretap2.mtu=$(($3-70))
        else
            uci set network.gretap2.mtu=$(($3-62))
        fi
    fi
    uci commit network
    uci set qcmap_lan.@eogre_info[0].eogre_mtu=$(uci get network.gretap2.mtu)
    uci commit qcmap_lan
    log $(basename "$0")":update_eogre_tunnel_mtu:"$LINENO":EoGRE tunnel MTU updated successfully"
  fi
}

case "$1" in
    set_eogre_config)
      set_eogre_config $2 $3
      #$2-ip_family $4-dst_addr
    ;;
    create_tunnel)
      create_tunnel
    ;;
    add_vlan_pcp_to_dscp_map)
      add_vlan_pcp_to_dscp_map $2 $3 $4 $5 $6
      #$2- eogre_tunnel_created $3- vlan_pcp_to_dscp_length $4 - vlan_id $5 - pcp $6 - dscp
    ;;
    install_vlan_and_pcp_to_dscp_rules)
      install_all_vlan_and_pcp_to_dscp_rules
    ;;
    delete_vlan_pcp_to_dscp_map)
      delete_vlan_pcp_to_dscp_map $2 $3 $4
      #$2- eogre_tunnel_created $3 - vlan_id $4 - pcp
    ;;
    delete_vlan_pcp_to_dscp_rules)
      delete_all_vlan_and_pcp_to_dscp_rules
    ;;
    destroy_tunnel)
      destroy_tunnel
    ;;
    update_eogre_tunnel_mtu)
      update_eogre_tunnel_mtu $2 $3 $4
      #$2- profile_id for which MTU is updated $3- ip_family $4- MTU
    ;;
    *)
    echo "Invalid option"
    ;;
esac
