#ifndef _QL_USB_H_
#define _QL_USB_H_

#include "ql_rawdata_api.h"
#include "quectel-features-config.h"

#define QL_USBCFG_DIR "/data/usb"

#ifdef QUECTEL_USB_NET_DEFAULT_MBIM
    #define USB_NET_DEFAULE USB_NET_MBIM
#else
    #define USB_NET_DEFAULE USB_NET_RMNET
#endif

#define NET_INTERFACE_DEFAULE (QL_DATA_INTERFACE_USB)
#define DIAG_INTERFACE_DEFAULE (QL_DATA_INTERFACE_USB)

#ifndef USB_PRODUCT
#ifdef QUECTEL_PRODUCT_NAME
#define USB_PRODUCT	QUECTEL_PRODUCT_NAME
#else
#define USB_PRODUCT	("LTE-A Module")
#endif
#endif

#define USB_VID_DEFAULE       (0x2c7c)
//sdx7x usb product id - 0x0122
#define USB_PID_DEFAULE       (0x0122)

/* +/ zac.chen-2024/02/21 JIRA SWSDX7X-823: The rndis mode uses a separate pid*/
#ifdef QL_G_BRANCH_SDX7X
#define USB_PID_FOR_RNDIS       (0x0133)
#endif
/* -/ zac.chen-2024/02/21 JIRA SWSDX7X-823: The rndis mode uses a separate pid*/

#define USB_MANUFA_DEFAULT    ("Quectel")
#define USB_MAXPOWER_DEFAULE  (900)

#define USB_SPEED_HIGH 0x20 /* usb 2.0 */
#define USB_SPEED_SUPER 0x30 /* usb 3.0 */
#define USB_SPEED_3_1_GEN1 0x31 /* USB3.1 Gen1 */
#define USB_SPEED_3_1_GEN2 0x32 /* USB3.1 Gen2 */

int check_usb_config(ql_rawdata_usb_cfg_type *usb_cfg, char *path);
int __ql_init_read_usb_cfg(ql_rawdata_usb_cfg_type *usb_cfg);

#endif
