#!/bin/sh

<<COMMENT
-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when         who          what, where, why
  ----------   ---------    -----------------------------------------------------------------------
  2025/02/24   tau.wu       add
-------------------------------------------------------------------------------------------------
COMMENT

do_upgrade_ab() {
    v "do_upgrade_ab[$(basename "$1")], enter"
    /usr/bin/fotainfo -p "$(basename "$1")"
    /usr/bin/abfota_update "start-fota"
    v "do_upgrade_ab, exit"
}

platform_check_image() {
    v "platform_check_image:[$1], magic:[$(get_magic_word $1 cat)]"
    case "$(get_magic_word $1 cat)" in
        # .gz files
        1f8b) ;;
        # .zip files (magic word for zip files)
        504b) ;;
        *)
        v "Invalid sysupgrade file."
        return 1
        ;;
    esac

    return 0
}

platform_do_upgrade() {
    v "platform_do_upgrade, enter"

    do_upgrade_ab $1

    return 0
}
