#!/bin/sh
#  Copyright (c) 2019,2021-2022 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

[ -n "$INCLUDE_ONLY" ] || {
	. /lib/functions.sh
	. /lib/functions/network.sh
	. ../netifd-proto.sh
	init_proto "$@"
}

proto_rmnet_setup() {
	local cfg="$1"
	#Call rmnet management script below!!
	logger "start rmnet $cfg"
	/lib/netifd/rmnet.script setup $cfg
	logger "update rmnet done"
}

proto_rmnet_teardown() {
	local cfg="$1"
	#Tear down rmnet manager script here.*/
	logger "stop rmnet cfg:$cfg"
	/lib/netifd/rmnet.script down $cfg
}

proto_rmnet_init_config() {
	#ddno_device=1
	available=1
	proto_config_add_array "downstream:list(string)"
	proto_config_add_int "profile"
	proto_config_add_int "bind"
}

[ -n "$INCLUDE_ONLY" ] || {
	add_protocol rmnet
}
