#! /bin/sh

#Copyright (c) 2021-2022 Qualcomm Innovation Center, Inc. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted (subject to the limitations in the
# disclaimer below) provided that the following conditions are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
#   * Redistributions in binary form must reproduce the above
#     copyright notice, this list of conditions and the following
#     disclaimer in the documentation and/or other materials provided
#     with the distribution.
#
#   * Neither the name of Qualcomm Innovation Center, Inc. nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
#
# NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE
# GRANTED BY THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

FILES=/sys/class/block/

create_symlinks()
{
        for file in $FILES/$1*
        do
                blockname=`basename $file`
                if [  $1 == "mtd" ]; then
                        partition_name=`cat $file/device/name`
                else
                        partition_name=`cat $file/uevent | awk '{ for ( n=1; n<=NF; n++ ) if($n ~ "PARTNAME") print $n }' | awk '{split($0,a, "=");print a[2]}'`
                fi
                mkdir -p /dev/block/bootdevice/by-name/
                partition_name=/dev/block/bootdevice/by-name/$partition_name
                target_dev=/dev/$blockname
                ln -s $target_dev $partition_name
        done
}

mount_data_flag=false
data_format_flag=false
## quectel-20230425, auto-mount data partiton for ext4 format
mount_data_ext4()
{
	fscktool=/usr/sbin/fsck.ext4                                         
	mkfstool=/usr/sbin/mkfs.ext4
	blkdev=$1
	mountpoint=$2
        extopt=$3

	mount_data_flag=false
	data_format_flag=false
	mkdir -p $mountpoint
	if [ -e $blkdev ] && [ -d $mountpoint ];then
		echo "$fscktool $blkdev"
        	/usr/sbin/fsck.ext4 -p  $blkdev > /dev/kmsg
                rcode=$?
        	if [ ! $rcode -eq 0 ];then
			echo "mount_data_ext4: fsck failed rcode=$rcode, try to format the partition[$blkdev]" > /dev/kmsg
                	$mkfstool $blkdev
			data_format_flag=true
                	sleep 1
        	fi
        	mount -t ext4  $blkdev $mountpoint
                if [ $? -eq 0 ];then
			echo "Mount $blkdev on $mountpoint successfully!" > /dev/kmsg
			mount_data_flag=true
			return 0
		fi
	fi

	echo "mount_data_ext4: mount $blkdev failed!!!" > /dev/kmsg
}
## quectel-20230425, auto-mount data partiton for ext4 format
mtd_file=/proc/mtd
ubi_device_number=1
FindAndAttachUBI() {
   partition=$1
   num_volumes=$2

   mtd_block_number=`cat $mtd_file | grep -i "\b$partition\b" | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   if [ -z "$mtd_block_number" ]; then
      echo "MTD : Partition $partition not found" > /dev/kmsg
   else
      echo "MTD : Attaching UBI device /dev/mtdblock$mtd_block_number for $partition @$ubi_device_number" > /dev/kmsg

      ubiattach -m $mtd_block_number -d $ubi_device_number /dev/ubi_ctrl
      count=1000 # wait for the ubi-device node to be created for a max of (1000 * 0.010 = ) 10 seconds
      while [ 1 ]; do
         if [ -c /dev/ubi${ubi_device_number} ]; then
            echo "/dev/ubi${ubi_device_number} created" > /dev/kmsg
            break
         else
            count=$(($count - 1))
            if [ $count -lt 1 ]; then
               echo "/dev/ubi${ubi_device_number} not yet created, rebooting" > /dev/kmsg
               /sbin/reboot
               break
            else
               sleep 0.010
            fi
         fi
      done

      i=0
      while [ "$i" -lt "$num_volumes" ]; do
         count=500 # wait for the ubi volume node to be created, for max 5 seconds
         volume_node="/dev/ubi${ubi_device_number}_${i}"
         while [ 1 ]; do
            if [ -c $volume_node ]; then
               echo "$volume_node created, proceeding" > /dev/kmsg
               break
            else
               count=$(($count - 1))
               if [ $count -lt 1 ]; then
                  echo "$volume_node not yet created, rebooting .." > /dev/kmsg
                  /sbin/reboot
                  break
               else
                  echo "$volume_node not yet created, checking again .." > /dev/kmsg
                  sleep 0.010
               fi
            fi
         done
         i=$(($i + 1))
      done
      ubi_device_number=$(($ubi_device_number + 1))
   fi

   ls -al /dev | grep -i "ubi" > /dev/kmsg
}

FindAndMountUBI () {
   volume=$1
   dir=$2
   fstab_only="$3"

   echo "MTD : Looking for UBI volume : $dir for $volume" > /dev/kmsg
   mkdir -p $dir

   # Skip ubi0 for recoveryfs
   for ubidev in /dev/ubi[1-99]_*; do
      volname=`ubinfo $ubidev | grep Name\: | awk '{print $2}'`
      if [ "$volname" == "$volume" ]; then
         echo "Found Volume: $volname" > /dev/kmsg
         if [ "$fstab_only" != "1" ]; then
            mount -t ubifs $ubidev $dir -o bulk_read
            echo "MTD : Mounting of $ubidev on $dir done" > /dev/kmsg
         fi
         UpdateRecoveryVolume $volume $dir "ubifs" $ubidev
         break
      fi
   done
}

FormatUBI() {
   partition=$1
   dir=$2
   ubinub=$3
   mtd_block_number=$4
   device=/dev/ubi${ubinub}
   
   ubidetach -p /dev/mtd$mtd_block_number
   sleep 1
   
   ubiformat /dev/mtd$mtd_block_number -y -v
   sleep 1
   
   ubiattach -m $mtd_block_number -d $ubinub /dev/ubi_ctrl
   sleep 1

   if [ -e $device ];then
      echo "ubiformat $partition success." > /dev/kmsg
   else
      echo "ubiformat $partition failed." > /dev/kmsg
      return 0
   fi

   ubimkvol /dev/ubi${ubinub} -m -N $partition
   sleep 1

   if [ -e ${device}_0  ];then
      echo "ubimkvol success." > /dev/kmsg
      sync
      return 1
   else
      echo "ubimkvol failed." > /dev/kmsg
      return 0
   fi   
}

GetMountResult() {
   partition=$1
   
   mountResult1=`mount | grep $partition`

   if [ "" = "$mountResult1" ]
   then
      echo "Mount $partition fail." > /dev/kmsg
      return 0
   else
      echo "Mount $partition success." > /dev/kmsg
      return 1
   fi
}

FindAndMountUsrdataUBI () {
   partition=$1
   dir=$2
   ubinub=$3
   QuecUsrdataFormatTimes=0
   Var1=0
   Var2=1
   ubiattach_time=0
   device=/dev/ubi${ubinub}_0

   mtd_block_number=`cat $mtd_file | grep -wi $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   echo "MTD : Detected block device : $dir for $partition" > /dev/kmsg
   mkdir -p $dir

   #attatch ubi
   ubiattach -m $mtd_block_number -d  $ubinub /dev/ubi_ctrl
   while [ 1 ]
   do
      if [ -e $device ]
      then
         break
      else
         sleep 0.01
         ubiattach_time=$((ubiattach_time+1))
         #echo "ubiattach wait times= $ubiattach_time"

         if [ "$ubiattach_time" -gt "200" ]
         then
            echo "ubiattach $partition failed. Start to format the $partition partition ..." > /dev/kmsg
            FormatUBI $partition $dir $ubinub $mtd_block_number
            if [ ! -e $device ] ;then
               echo "ubiattach $partition failed." > /dev/kmsg
               return 0
            fi
            break
         fi
      fi
   done

   #mount volume
   mounttimes=0
   while [ 1 ]
   do
      mount -t ubifs /dev/ubi${ubinub}_0 $dir -o bulk_read
      sleep 0.1
      GetMountResult $partition
      if [ $? -eq 1 ]
      then
         return 1
      fi

      mounttimes=$((mounttimes+1))
      if [ "$mounttimes" -gt "20" ]
      then
         echo "Mount failed, Start to format the $partition partition ..." > /dev/kmsg
         FormatUBI $partition $dir $ubinub $mtd_block_number
         if [ ! -e $device ] ;then
            echo "ubiattach $partition failed." > /dev/kmsg
            return 0
         fi
         sleep 1
         mount -t ubifs /dev/ubi${ubinub}_0 $dir -o bulk_read
         sleep 2
         GetMountResult $partition
         return $?
      fi
   done
}

#add by quectel
checkMountResult() 
{
    local mountpoint="${1}"
    local mountResult=`mount | grep $mountpoint |grep "rw"`

    if [ "" = "$mountResult" ];then
        echo "$mountpoint mount failure !!!!" > /dev/kmsg
        return 1
    else
        echo "$mountpoint mount success !!!!" > /dev/kmsg
        return 0
    fi
}

#check cache partition is mount,remove temporary file,refer to fota
remove_temp_file_on_cache()
{
    local temp_file_on_cache="\
      /cache/saved.file\
      /cache/linux-rootfs.ubifs\
      /cache/linux-usrfs.ubifs\
      /data/backup_rootfs\
      /cache/modem.ubifs\
      /cache/fota/ipth_package.bin\
      /cache/fota/ipth_package.bin.dd\
      /cache/ufs/ipth_package.bin.dd\
      /cache/clade*.bin\
      "
   
    checkMountResult "cache"
    if [ $? -eq 1  ];then
        echo "cache partition mount failure" > /dev/kmsg
        return
    fi

    for s in ${temp_file_on_cache}
    do
        if [ -f ${s} ];then
            sha1sum ${s} >> /cache/fota_sha_tmp.log
        elif [ -d ${s} ];then
            find ${s} -type f -exec sha1sum {} \; >> /cache/fota_sha_tmp.log
        fi

        rm -rf ${s}
    done

    if [ -e /cache/fota_sha_tmp.log ];then
        mv /cache/fota_sha_tmp.log /cache/fota_sha1sum.log
    fi
}
#add end

mount_bind_usrdata_ubi(){
   part_name=$1
   
   eval FindAndMountUsrdataUBI usrdata /$part_name 2
   if [ "$?" == "1" ]
   then
      mkdir -p /$part_name/etc
      mkdir -p /$part_name/data
      mkdir -p /$part_name/cache
      # Default storage path of the upgrade package
      mkdir -p /$part_name/cache/ufs
      mkdir -p /$part_name/systemrw
      mkdir -p /$part_name/persist
      mkdir -p /var/volatile/tmp
      
      if [ ! -f /usrdata/bind_flag ];then
         cp -a /etc/* /$part_name/etc/
         cp -a /data/* /$part_name/data/

         if [ -d /usrdata/cfg_bak/ ];then
            cp -rf /usrdata/cfg_bak/* /usrdata/
            rm -rf /usrdata/cfg_bak/
         fi

         sync;sync
         sleep 1
         touch /usrdata/bind_flag
         sync
      fi

      mount --bind /$part_name/etc/  /etc
      mount --bind /$part_name/data/  /data
      mount --bind /$part_name/cache/  /cache
      mount --bind /$part_name/systemrw/  /systemrw
      mount --bind /$part_name/persist/  /persist
      mkdir -p /cache/ufs
   fi
}

## quectel-20230426, mount-bind for usrdata
mount_bind_usrdata_ext4()
{
	usrdatapath=$1
	bind_flag=$usrdatapath/bind_flag

	mkdir -p $usrdatapath/data
	mkdir -p $usrdatapath/persist
	mkdir -p $usrdatapath/systemrw
	mkdir -p $usrdatapath/cache/ufs

	if [ ! -f $bind_flag ];then
		cp -Rdp /data/* $usrdatapath/data
		sync;sync
		sleep 1
		touch $bind_flag
		sync
	fi
        
	mount --bind $usrdatapath/data /data
	#mount --bind $usrdatapath/persist /persist
	#mount --bind $usrdatapath/systemrw /systemrw
	#mount --bind $usrdatapath/cache /cache
	mkdir -p /cache/ufs
	mount --bind $usrdatapath/cache/ufs /cache/ufs
}
## quecel-20230426, mount-bind for usrdata

if [ ! -d /firmware/image ]; then
        if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
                create_symlinks mtd
                mtd_block_number=`cat /proc/mtd | grep -i modem | sed 's/^mtd//' | awk -F ':' '{print $1}'`
                echo "MTD : Detected block device : firmware for modem "
                mkdir -p $dir

                #ubiattach -m $mtd_block_number -d 1 /dev/ubi_ctrl
                FindAndAttachUBI modem 1
                FindAndMountUBI modem /firmware 0
        else
                #+quectel-20230302, use symlink instead for modem partition changing
                create_symlinks mmc
                #mount /dev/mmcblk0p1 /firmware -o ro,context=u:r:qcfirmware.miscfile
                if [ -d /dev/block/bootdevice/by-name ];then
                       mount -t vfat /dev/block/bootdevice/by-name/modem /firmware -o ro
                fi
                #-quectel-20230302, use symlink instead for modem partition changing
                #create_symlinks mmc
        fi
fi

echo -n "/firmware/image" > /sys/module/firmware_class/parameters/path

if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
	if [ ! -d /persist ]; then
		echo "creating /persist"
		mkdir -p /persist
	fi
	mount -t ubifs ubi0:persist /persist -o bulk_read
	echo "persist is mounted to /persist"
fi

#Mount cache
if [ ! -d /cache ]; then
        echo "creating /cache dir"
        mkdir -p /cache
fi

soc_id=`cat /sys/devices/soc0/soc_id`
if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
        #mount -t ubifs ubi0:cachefs /cache -o bulk_read
        #if [ $soc_id != "570" ] && [ $soc_id != "571" ]; then
        #    mount -t ubifs ubi0:systemrw /overlay -o bulk_read
        #fi
        #mount -t ubifs /dev/ubi0_1 /data -o bulk_read,rw
        eval mount_bind_usrdata_ubi usrdata
else
        mount_data_ext4 /dev/block/bootdevice/by-name/cache /cache noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto,context=u:r:cache.miscfile
        mount_data_ext4 /dev/block/bootdevice/by-name/systemrw /overlay noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto
        mount_data_ext4 /dev/block/bootdevice/by-name/persist /persist noatime,data=ordered,noauto_da_alloc,discard,noexec,nodev,nosuid,noauto,context=u:r:persist.miscfile
        mount_data_ext4 /dev/block/bootdevice/by-name/usrdata /usrdata
        if [ $mount_data_flag = true ];then
              mount_bind_usrdata /usrdata
        fi
fi

if [ -f /proc/mtd ] && [ `cat /proc/mtd | wc -l` -ge "2" ]; then
    mkdir -p /usrdata/overlay-work
    mkdir -p /usrdata/overlay-work/etc-upper
    mkdir -p /usrdata/overlay-work/.etc-work
    #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
    rm -rf /overlay/etc-upper/config/.*.uci-*
    #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
    mount -t overlay -o lowerdir=/etc,upperdir=/usrdata/overlay-work/etc-upper,workdir=/usrdata/overlay-work/.etc-work overlay /etc
    #disable rmts on mtd device
    if [ -x /etc/init.d/rmtstorage.init ];then
       /etc/init.d/rmtstorage.init disable
    fi
else
    mkdir -p /overlay/etc-upper
    mkdir -p /overlay/.etc-work
    #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
    rm -rf /overlay/etc-upper/config/.*.uci-*
    #+quectel-20240109 , tmp files are useless for next boot and will cause mount failure
    mount -t overlay -o lowerdir=/etc,upperdir=/overlay/etc-upper,workdir=/overlay/.etc-work overlay /etc
fi

remove_temp_file_on_cache

RESTORECON=/sbin/restorecon
${RESTORECON} -R  /etc -e /etc/rc.d

# For  Boot KPI we will call restorcon only  for the first boot
# any new files will get labeled on creation

if [ ! -f /persist/.autolabeled ]; then
     # Need Restorecon for /persist
     ${RESTORECON} -RF /persist
     touch  /persist/.autolabeled
fi

if [ ! -f /data/.autolabeled ]; then
        # Need Restorecon for /data
        ${RESTORECON} -RF /data
        touch  /data/.autolabeled
fi


#+quectel-20231103, symbol link for rf_band
if [ -e /firmware/image/modem_pr/rf_band ]; then
    ln -s /firmware/image/modem_pr/rf_band /system/rfs/mdm/mpss/shared/rf_band
else
    echo "rf_band not exist"
fi
#-quectel-20231103, symbol link for rf_band
#+quectel-20240913, symbol link for quec_xqcn
if [ -e /firmware/image/modem_pr/quec_xqcn ]; then
    ln -s /firmware/image/modem_pr/quec_xqcn /system/rfs/mdm/mpss/shared/quec_xqcn
else
    echo "qxqcn not exist"
fi
#-quectel-20240913, symbol link for quec_xqcn

