#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh

wlan_2g_band="2.4GHz"
wlan_5g_band="5GHz"
wlan_6g_band="6GHz"
ip_octet=28
wifi0_athlist=""
wifi1_athlist=""
wifi2_athlist=""

QCMAP_PRIMARY_FRONTHAUL_AP=1
QCMAP_GUEST_FRONTHAUL_AP=2
QCMAP_GUEST_FRONTHAUL_AP_2=3
QCMAP_GUEST_FRONTHAUL_AP_3=4
QCMAP_ADDITIONAL_FH_AP_1=5
QCMAP_ADDITIONAL_FH_AP_2=6
QCMAP_ADDITIONAL_FH_AP_3=7
QCMAP_BACKHAUL_AP_R1=8
QCMAP_BACKHAUL_AP_R2=9
QCMAP_SMART_MONITOR_AP=10

#used to support activate hostapd restart
primaryap=1
guestap1=2
guestap2=3
guestap3=4
guestap4=5
guestap5=6
guestap6=7
guestap7=8
guestap8=9
guestap9=10
guestap10=11
guestap11=12
guestap12=13
guestap13=14

primaryap_vlan_id=1
guestapone_vlan_id=2
guestaptwo_vlan_id=3
guestapthree_vlan_id=4

QCMAP_PRIMARY_AP=1
QCMAP_GUEST_AP=2
QCMAP_GUEST_AP_2=3
QCMAP_GUEST_AP_3=4
QCMAP_ALL_AP=5
QCMAP_GUEST_AP_4=6
QCMAP_GUEST_AP_5=7
QCMAP_GUEST_AP_6=8
QCMAP_GUEST_AP_7=9
QCMAP_GUEST_AP_8=10
QCMAP_GUEST_AP_9=11
QCMAP_GUEST_AP_10=12
QCMAP_GUEST_AP_11=13
QCMAP_GUEST_AP_12=14
QCMAP_GUEST_AP_13=15

QCMAP_HOSTAPD_RESTART=3

#this needs to be updated once we get the CDT info
CDT_WLAN_WKK_ATTACH=3
#Get CDT info.

CDT_TYPE=$(cat /sys/devices/soc0/platform_subtype_id)

function set_ezmesh_config() {
  local ezmesh_enable=$1
  uci set qcmap_ezmesh.@ezmesh[0].enable_state=$ezmesh_enable
  if [ ! -z "$2" ]; then
    local ezmesh_capability=$2
    uci set qcmap_ezmesh.@ezmesh[0].capability=$ezmesh_capability
  fi
  if [ ! -z "$3" ]; then
    local ap_config_len=$3
    uci set qcmap_ezmesh.@ezmesh[0].ap_config_len=$ap_config_len
  fi
  uci commit qcmap_ezmesh

  log  $(basename "$0") "set_ezmesh_config" $LINENO "set_ezmesh_config with Enable:$ezmesh_enable, Capability:$ezmesh_capability and No:of VAPs:$ap_config_len done !!!"
}

function set_ezmesh_ap_config() {
  local band=$1
  local guest_profile=$2
  local ezmesh_aptype=$3
  local wlan_ap_type=$4

  case $wlan_ap_type in
    $QCMAP_PRIMARY_AP)
      uci set qcmap_ezmesh.@primaryap[0].band=$band
      uci set qcmap_ezmesh.@primaryap[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@primaryap[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@primaryap[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_primary_ap_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP)
      uci set qcmap_ezmesh.@guestap1[0].band=$band
      uci set qcmap_ezmesh.@guestap1[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap1[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap1[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap1_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_2)
      uci set qcmap_ezmesh.@guestap2[0].band=$band
      uci set qcmap_ezmesh.@guestap2[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap2[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap2[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap2_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_3)
      uci set qcmap_ezmesh.@guestap3[0].band=$band
      uci set qcmap_ezmesh.@guestap3[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap3[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap3[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap3_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_4)
      uci set qcmap_ezmesh.@guestap4[0].band=$band
      uci set qcmap_ezmesh.@guestap4[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap4[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap4[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap4_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_5)
      uci set qcmap_ezmesh.@guestap5[0].band=$band
      uci set qcmap_ezmesh.@guestap5[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap5[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap5[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap5_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_6)
      uci set qcmap_ezmesh.@guestap6[0].band=$band
      uci set qcmap_ezmesh.@guestap6[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap6[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap6[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap6_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_7)
      uci set qcmap_ezmesh.@guestap7[0].band=$band
      uci set qcmap_ezmesh.@guestap7[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap7[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap7[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap7_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_8)
      uci set qcmap_ezmesh.@guestap8[0].band=$band
      uci set qcmap_ezmesh.@guestap8[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap8[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap8[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap8_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_9)
      uci set qcmap_ezmesh.@guestap9[0].band=$band
      uci set qcmap_ezmesh.@guestap9[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap9[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap9[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap9_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_10)
      uci set qcmap_ezmesh.@guestap10[0].band=$band
      uci set qcmap_ezmesh.@guestap10[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap10[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap10[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap10_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_11)
      uci set qcmap_ezmesh.@guestap11[0].band=$band
      uci set qcmap_ezmesh.@guestap11[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap11[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap11[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap11_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_12)
      uci set qcmap_ezmesh.@guestap12[0].band=$band
      uci set qcmap_ezmesh.@guestap12[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap12[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap12[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap12_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;

    $QCMAP_GUEST_AP_13)
      uci set qcmap_ezmesh.@guestap13[0].band=$band
      uci set qcmap_ezmesh.@guestap13[0].ezmesh_aptype=$ezmesh_aptype
      uci set qcmap_ezmesh.@guestap13[0].accessprofile=$guest_profile
      uci set qcmap_ezmesh.@guestap13[0].wlan_ap_type=$wlan_ap_type
      log $(basename "$0") "set_ezmesh_guest_ap13_config" $LINENO "Band:$band, Ezmesh type:$ezmesh_aptype"
      ;;
  esac

  uci commit qcmap_ezmesh
}

function set_ezmesh_per_band_count() {
  local ap_count_2g=$1
  local ap_count_5g=$2
  local ap_count_6g=$3

  uci set qcmap_ezmesh.@ezmesh[0].ap_count_2g=$ap_count_2g
  uci set qcmap_ezmesh.@ezmesh[0].ap_count_5g=$ap_count_5g
  uci set qcmap_ezmesh.@ezmesh[0].ap_count_6g=$ap_count_6g
  uci commit qcmap_ezmesh

  uci set repacd.MAPConfig.FirstConfigRequired='1'
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_per_band_count" $LINENO "No.of APs 2G:$ap_count_2g, 5G:$ap_count_5g, 6G:$ap_count_6g done !!!"
}

function set_ezmesh_r2_traffic_separation() {
  local traffic_separation=$1

  uci set qcmap_ezmesh.@r2_config[0].traffic_separation=$traffic_separation
  uci commit qcmap_ezmesh

  #update the repacd about the traffic separation info
  uci set repacd.MAPConfig.MapTrafficSeparationEnable=$traffic_separation
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_r2_traffic_separation" $LINENO "Traffic separation:$traffic_separation done !!!"
}

function set_ezmesh_vlan_config() {
  local no_of_vlans=$1
  local vlan_id1=$2
  local fh_ap1_type=$3
  local vlan_id2=$4
  local fh_ap2_type=$5
  local vlan_id3=$6
  local fh_ap3_type=$7
  local vlan_id4=$8
  local fh_ap4_type=$9

  uci set qcmap_ezmesh.@r2_config[0].no_of_vlans=$no_of_vlans
  uci set qcmap_ezmesh.@r2_config[0].primaryap_vlan_id=$vlan_id1
  uci set qcmap_ezmesh.@r2_config[0].primaryap_fh_type=$fh_ap1_type
  uci set qcmap_ezmesh.@r2_config[0].guestapone_vlan_id=$vlan_id2
  uci set qcmap_ezmesh.@r2_config[0].guestapone_fh_type=$fh_ap2_type
  if [ ! -z "$vlan_id3" ]; then
    uci set qcmap_ezmesh.@r2_config[0].guestaptwo_vlan_id=$vlan_id3
    uci set qcmap_ezmesh.@r2_config[0].guestaptwo_fh_type=$fh_ap3_type
  fi
  if [ ! -z "$vlan_id4" ]; then
    uci set qcmap_ezmesh.@r2_config[0].guestapthree_vlan_id=$vlan_id4
    uci set qcmap_ezmesh.@r2_config[0].guestapthree_fh_type=$fh_ap4_type
  fi
  uci commit qcmap_ezmesh

  #update the repacd about the vlan and bridge names info
  uci set repacd.MAPConfig.SkipDhcpConfigSettings='1'
  uci set repacd.MAPConfig.NumberOfVLANSupported=$no_of_vlans
  uci set repacd.repacd.ManagedNetwork="lan"
  uci set repacd.MAPConfig.VlanIDNwPrimary=$vlan_id1
  uci set repacd.MAPConfig.VlanNetworkPrimary="lan"
  uci set repacd.MAPConfig.VlanIDNwOne=$vlan_id2
  uci set repacd.MAPConfig.VlanNetworkOne="lan${vlan_id2}"
  if [ ! -z "$vlan_id3" ]; then
  uci set repacd.MAPConfig.VlanIDNwTwo=$vlan_id3
  uci set repacd.MAPConfig.VlanNetworkTwo="lan${vlan_id3}"
  fi
  if [ ! -z "$vlan_id4" ]; then
  uci set repacd.MAPConfig.VlanIDNwThree=$vlan_id4
  uci set repacd.MAPConfig.VlanNetworkThree="lan${vlan_id4}"
  fi
  uci commit repacd

  log  $(basename "$0") "set_ezmesh_vlan_config" $LINENO "Traffic separation:$traffic_separation, Vlan:$vlan_id1, $vlan_id2, $vlan_id3, $vlan_id4 done !!!"
}

function set_ezmesh_r3_service_priority() {
  local service_priority=$1

  uci set qcmap_ezmesh.@r3_config[0].service_priority=$service_priority
  uci commit qcmap_ezmesh

  log  $(basename "$0") "set_ezmesh_r3_service_priority" $LINENO "Service Priority:$service_priority done !!!"
}

function update_ezmesh_wireless_config() {
  local file=$1
  local band=$2
  local wifi_dev=$3
  local max=8
  local ip_octet_tmp=$4
  local wifi0_band=5
  local wifi1_band=2
  local wifi2_band=6
  local count=0


  #Get totoal config count required in specific band.
  if [ $band -eq 2 ]; then
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_2g)
  elif [ $band -eq 5 ]; then
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_5g)
  else
    count=$(uci get qcmap_ezmesh.@ezmesh[0].ap_count_6g)
  fi

  if [ $count -eq 0 ]; then
    log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "not using ${band}G config count=$count"
    return
  fi

  echo "count = $count"
  #Configure IP address to AP.
  #Link local IP will set by wifi script, update link local IP to AP wireless config.
  for i in `seq 0 $((count-1))`
  do
    log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "Setting IP addr to AP config"
    uci set $file.@wifi-iface[$i].ipaddr="169.254.$((ip_octet_tmp)).1"
    ip_octet_tmp=$((ip_octet_tmp+1))
    uci commit
  done

  #update ip octet for other radio.
  ip_octet=$ip_octet_tmp

  log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "*****Valid count:$count band:$band***"
  #delete unused AP config.
  for i in `seq $count $max`
  do
    uci delete $file.@wifi-iface[$count]
    uci commit $file
  done

  uci commit $file
  #append config to wireless config file
  log $(basename "$0") "update_ezmesh_wireless_config" $LINENO "valid config found with band:$band"
  cat /etc/config/$file >> /etc/config/wireless

}

function set_ezmesh_update_wireless() {
  local wifi_dev2 wifi_dev2_mac_addr
  local wifi_dev5 wifi_dev5_mac_addr
  local wifi_dev6 wifi_dev6_mac_addr
  local tmp band

  #Get wifi devices.
  local wifi_devices=$(ls /sys/class/net | grep wifi)
  for device in $wifi_devices
  do
    tmp=$(cfg80211tool $device g_oper_reg_info)
    band=$(echo $tmp | awk '{ print $4 }' | cut -c 6)
    case $band in
      2)
        wifi_dev2=$device
        wifi_dev2_mac_addr=$(cat /sys/class/net/$wifi_dev2/address)
        ;;
      5)
        wifi_dev5=$device
        wifi_dev5_mac_addr=$(cat /sys/class/net/$wifi_dev5/address)
        ;;
      6)
        wifi_dev6=$device
        wifi_dev6_mac_addr=$(cat /sys/class/net/$wifi_dev6/address)
        ;;
      *)
        echo "Invalid Band"
    esac
  done

  echo > /etc/config/wireless

  #update 2g wireless file to tmp
  cp /etc/config/default_wifi_configs/2g_wireless /etc/config/2g_wireless
  sed -i "s/wifiX/$wifi_dev2/g" /etc/config/2g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev2_mac_addr/g" /etc/config/2g_wireless
  update_ezmesh_wireless_config 2g_wireless 2 $wifi_dev2 $ip_octet

  #update 5g wireless file to tmp
  cp /etc/config/default_wifi_configs/5g_wireless /etc/config/5g_wireless
  sed -i "s/wifiX/$wifi_dev5/g" /etc/config/5g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev5_mac_addr/g" /etc/config/5g_wireless
  update_ezmesh_wireless_config 5g_wireless 5 $wifi_dev5 $ip_octet

  #update 6g wireless file to tmp
  cp /etc/config/default_wifi_configs/6g_wireless /etc/config/6g_wireless
  sed -i "s/wifiX/$wifi_dev6/g" /etc/config/6g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev6_mac_addr/g" /etc/config/6g_wireless
  update_ezmesh_wireless_config 6g_wireless 6 $wifi_dev6 $ip_octet

  log $(basename "$0") "set_ezmesh_update_wireless" $LINENO "/etc/config/wireless updated"
  #delete /etc/confog/Xg_wireless
  rm /etc/config/2g_wireless
  rm /etc/config/5g_wireless
  rm /etc/config/6g_wireless

}

function set_ezmesh_update_ifaces() {
  local wifi_ifaces_count=$(uci show wireless | grep -i "wifi-iface" | awk -F'[][]' '{print $2}' | tail -1)
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)
  local traffic_separation=$(uci get qcmap_ezmesh.@r2_config[0].traffic_separation)
  local no_of_vlans=$(uci get qcmap_ezmesh.@r2_config[0].no_of_vlans)
  local vlan_id1 vlan_id2 vlan_id3 vlan_id4
  local guest1_type guest2_type guest3_type
  if [ $traffic_separation == "1" ]; then
    for i in `seq $no_of_vlans`
    do
      case $i in
        $primaryap_vlan_id)
          vlan_id1=$(uci get qcmap_ezmesh.@r2_config[0].primaryap_vlan_id)
        ;;

        $guestapone_vlan_id)
          vlan_id2=$(uci get qcmap_ezmesh.@r2_config[0].guestapone_vlan_id)
          guest1_type=$(uci get qcmap_ezmesh.@r2_config[0].guestapone_fh_type)
        ;;

        $guestaptwo_vlan_id)
          vlan_id3=$(uci get qcmap_ezmesh.@r2_config[0].guestaptwo_vlan_id)
          guest2_type=$(uci get qcmap_ezmesh.@r2_config[0].guestaptwo_fh_type)
        ;;

        $guestapthree_vlan_id)
          vlan_id4=$(uci get qcmap_ezmesh.@r2_config[0].guestapthree_vlan_id)
          guest3_type=$(uci get qcmap_ezmesh.@r2_config[0].guestapthree_fh_type)
        ;;
      esac
    done
  fi
  local intf device band_info band mapBssType network ipaddr ap_type add_fh_vap_idx
  local ezmesh_band ezmesh_type

  #delete if any STA interface attach to wanwlan
  uci delete network.wanwlan.ifname 2> /dev/null

  for i in `seq 0 $((wifi_ifaces_count))`
  do
    intf=$(uci get wireless.@wifi-iface[$i].ifname)
    if [ ! -z "$intf" ]; then
      device=$(uci get wireless.@wifi-iface[$i].device)
      band_info=$(cfg80211tool $device g_oper_reg_info | grep -i band | awk -F ',' '{print $3}' | awk -F '=' '{print $2}')
      if [ $band_info == "$wlan_2g_band" ]; then
        band=2
      elif [ $band_info == "$wlan_5g_band" ]; then
        band=5
      elif [ $band_info == "$wlan_6g_band" ]; then
        band=6
      fi
      mapBssType=$(uci get wireless.@wifi-iface[$i].MapBSSType)
      ipaddr=$(uci get wireless.@wifi-iface[$i].ipaddr)
      if [ $mapBssType == '32' ]; then
        network=$(uci get wireless.@wifi-iface[$i].network)
        if [ ! -z "$vlan_id2" ] && [ $network == "lan${vlan_id2}" ]; then
          ap_type=$guest1_type
        elif [ ! -z "$vlan_id3" ] && [ $network == "lan${vlan_id3}" ]; then
          ap_type=$guest2_type
        elif [ ! -z "$vlan_id4" ] && [ $network == "lan${vlan_id4}" ]; then
          ap_type=$guest3_type
        else
          add_fh_vap_idx=$(uci get wireless.@wifi-iface[$i].additional_fh_vap_index)
          if [ -z "$add_fh_vap_idx" ] && [ $network == "lan" ]; then
            ap_type=$QCMAP_PRIMARY_FRONTHAUL_AP
          else
            if [ $add_fh_vap_idx == '1' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_1
            elif [ $add_fh_vap_idx == '2' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_2
            elif [ $add_fh_vap_idx == '3' ]; then
              ap_type=$QCMAP_ADDITIONAL_FH_AP_3
            fi
          fi
        fi
      elif [ $mapBssType == '64' ] || [ $mapBssType == '68' ]; then
        ap_type=$QCMAP_BACKHAUL_AP_R1
      elif [ $mapBssType == '72' ]; then
        ap_type=$QCMAP_BACKHAUL_AP_R2
      elif [ -z "$mapBssType" ]; then
        ap_type=$QCMAP_SMART_MONITOR_AP
      fi

      for j in `seq $ezmesh_ap_len`
      do
        case $j in
          $primaryap)
            ezmesh_band=$(uci get qcmap_ezmesh.@primaryap[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@primaryap[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@primaryap[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to primaryap"
            fi
          ;;

          $guestap1)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap1[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap1[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap1[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap1"
            fi
          ;;

          $guestap2)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap2[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap2[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap2[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap2"
            fi
          ;;

          $guestap3)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap3[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap3[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap3[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap3"
            fi
          ;;

          $guestap4)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap4[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap4[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap4[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap4"
            fi
          ;;

          $guestap5)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap5[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap5[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap5[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap5"
            fi
          ;;

          $guestap6)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap6[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap6[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap6[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap6"
            fi
          ;;

          $guestap7)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap7[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap7[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap7[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap7"
            fi
          ;;

          $guestap8)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap8[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap8[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap8[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap8"
            fi
          ;;

          $guestap9)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap9[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap9[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap9[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap9"
            fi
          ;;

          $guestap10)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap10[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap10[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap10[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap10"
            fi
          ;;

          $guestap11)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap11[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap11[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap11[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap11"
            fi
          ;;

          $guestap12)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap12[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap12[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap12[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap12"
            fi
          ;;

          $guestap13)
            ezmesh_band=$(uci get qcmap_ezmesh.@guestap13[0].band)
            ezmesh_type=$(uci get qcmap_ezmesh.@guestap13[0].ezmesh_aptype)
            if [ $band == $ezmesh_band ] && [ $ap_type == $ezmesh_type ]; then
              uci set qcmap_ezmesh.@guestap13[0].ifname=$intf
              log $(basename "$0") "" $LINENO "adding $intf to guestap13"
            fi
          ;;
        esac
        uci commit qcmap_ezmesh
      done
    fi

    #update the ifname to network lan config
    if [ ! -z "$intf" ] && [ ! -z "$mapBssType" ];then
      uci set network.$intf="interface"
      uci set network.$intf.device="$intf"
      uci set network.$intf.proto="static"
      uci set network.$intf.ipv6="1"
      uci set network.$intf.ipaddr="$ipaddr"
      uci set network.$intf.netmask="255.255.255.0"
      uci commit network
    fi
  done
}

function delete_ezmesh_ifaces_config() {
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)
  local traffic_separation=$(uci get qcmap_ezmesh.@r2_config[0].traffic_separation)
  local no_of_vlans=$(uci get qcmap_ezmesh.@r2_config[0].no_of_vlans)
  local ezmesh_type intf

  for i in `seq $ezmesh_ap_len`
  do
    case $i in
      $primaryap)
        ezmesh_type=$(uci get qcmap_ezmesh.@primaryap[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
        uci set qcmap_ezmesh.@primaryap[0].ifname=" "
      ;;

      $guestap1)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap1[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
        uci set qcmap_ezmesh.@guestap1[0].ifname=" "
      ;;

      $guestap2)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap2[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
        uci set qcmap_ezmesh.@guestap2[0].ifname=" "
      ;;

      $guestap3)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap3[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
        uci set qcmap_ezmesh.@guestap3[0].ifname=" "
      ;;

      $guestap4)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap4[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
        uci set qcmap_ezmesh.@guestap4[0].ifname=" "
      ;;

      $guestap5)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap5[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
        uci set qcmap_ezmesh.@guestap5[0].ifname=" "
      ;;

      $guestap6)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap6[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
        uci set qcmap_ezmesh.@guestap6[0].ifname=" "
      ;;

      $guestap7)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap7[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
        uci set qcmap_ezmesh.@guestap7[0].ifname=" "
      ;;

      $guestap8)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap8[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
        uci set qcmap_ezmesh.@guestap8[0].ifname=" "
      ;;

      $guestap9)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap9[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
        uci set qcmap_ezmesh.@guestap9[0].ifname=" "
      ;;

      $guestap10)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap10[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
        uci set qcmap_ezmesh.@guestap10[0].ifname=" "
      ;;

      $guestap11)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap11[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
        uci set qcmap_ezmesh.@guestap11[0].ifname=" "
      ;;

      $guestap12)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap12[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
        uci set qcmap_ezmesh.@guestap12[0].ifname=" "
      ;;

      $guestap13)
        ezmesh_type=$(uci get qcmap_ezmesh.@guestap13[0].ezmesh_aptype)
        intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
        uci set qcmap_ezmesh.@guestap13[0].ifname=" "
      ;;
    esac
    uci commit qcmap_ezmesh

    #delete the ifname config from network lan config
    if [ ! -z "$intf" ] && [ $ezmesh_type != '0' ];then
      uci delete network.$intf 2> /dev/null
      uci commit network
    fi
  done
}

function set_ezmesh_repacd_start() {
  uci set repacd.repacd.Enable='1'
  uci set repacd.repacd.Ezmesh='1'
  uci set repacd.MAPConfig.AssignIPAddressPerVAP='1'
  uci commit repacd

  /etc/init.d/repacd start
}

function set_ezmesh_repacd_stop() {
  local clean_up_config=$(uci get qcmap_ezmesh.@ezmesh[0].clean_up_config)

  delete_ezmesh_ifaces_config
  uci set repacd.repacd.Enable='0'
  uci set repacd.repacd.Ezmesh='0'
  uci set repacd.MAPConfig.ShutDownServices='1'
  if [ $clean_up_config == '1' ]; then
    uci set repacd.MAPConfig.CleanUpEzmeshConfig='1'
  fi
  uci commit repacd

  if [ $clean_up_config == '1' ]; then
    /etc/init.d/repacd stop
  else
    /sbin/wifi down
  fi
}

function set_ezmesh_repacd_restart() {
  uci set repacd.repacd.Enable='1'
  uci set repacd.repacd.Ezmesh='1'
  uci set repacd.MAPConfig.AssignIPAddressPerVAP='1'
  uci commit repacd

  /sbin/wifi up
}

function set_ezmesh_repacd_restore() {
  uci set repacd.repacd.Enable='0'
  uci set repacd.repacd.Ezmesh='0'
  uci set repacd.MAPConfig.ShutDownServices='1'
  uci set repacd.MAPConfig.CleanUpEzmeshConfig='1'
  uci commit repacd

  /etc/init.d/repacd stop
}

function enable_ezmesh_on_bootup() {
  /sbin/wifi
}

function add_athx_to_list() {
  local idx=$1
  local intf=$2

  if [ $idx == 0 ]; then
    wifi0_athlist="${wifi0_athlist} $intf"
  elif [ $idx == 1 ]; then
    wifi1_athlist="${wifi1_athlist} $intf"
  else
    wifi2_athlist="${wifi2_athlist} $intf"
  fi
}

function activate_ezmesh_hostapd_restart() {
  local activate_cmd

  if [ ! -z "$wifi0_athlist" ]; then
    activate_cmd="${activate_cmd}wifi0 "${wifi0_athlist}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi0: $activate_cmd"
  fi

  if [ ! -z "$wifi1_athlist" ]; then
    activate_cmd="${activate_cmd}wifi1 "${wifi1_athlist}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi1: $activate_cmd"
  fi

  if [ ! -z "$wifi2_athlist" ]; then
    activate_cmd="${activate_cmd}wifi2 "${wifi2_athlist}" "
    log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command at wifi2: $activate_cmd"
  fi

  log $(basename "$0") "activate_ezmesh_hostapd_restart" $LINENO "Command before call : $activate_cmd"
  #Activate multi up/down command on athX based on action type.

  wifi multi_down $activate_cmd >> /dev/null
  #sleep 5 second to bring down all iface.
  sleep 5
  wifi multi_up $activate_cmd >> /dev/null

  echo "Activate Hostpad Success"
}

function activate_ezmesh_hostapd_config() {
  local ap_list_len=$1
  local action=$2

  if [ $action -ne $QCMAP_HOSTAPD_RESTART ]; then
    log $(basename "$0") "activate_ezmesh_hostapd_config" $LINENO "Invalid action type: $action"
    return
  fi

  wifi0_athlist=""
  wifi1_athlist=""
  wifi2_athlist=""

  echo "Activate EZMesh Hostapd config is Valid"
  log  $(basename "$0") "activate_ezmesh_hostapd_config" $LINENO "AP List len:$ap_list_len, Action Type:$action done !!!"
}

function activate_ezmesh_hostapd_ap_config() {
  local ap_type=$1
  local idx
  local ezmesh_ap_len=$(uci get qcmap_ezmesh.@ezmesh[0].ap_config_len)

  #wifi multi_up wifiX <athX list from this wifiX>
  #wifi multi_down wifiX <athX list from this wifiX>
  #wifi multi_up wifiX athXA athXB wifiY athYA athYB

  #get wireless config state.
  #wlan_state=$(uci -q get wireless.@wifi-iface[0].disabled)
  #if [ $wlan_state == 1 ]; then
  #  log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "WLAN is disabled can't start hostapd"
  #  return
  #fi

  if [ $ap_type == $QCMAP_ALL_AP ] && [ $ezmesh_ap_len -ne 0 ]; then
    for i in `seq $ezmesh_ap_len`
    do
      case $i in
        $primaryap)
          intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap1)
          intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap2)
          intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap3)
          intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap4)
          intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap5)
          intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap6)
          intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap7)
          intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap8)
          intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap9)
          intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap10)
          intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap11)
          intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap12)
          intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;

        $guestap13)
          intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
        ;;
      esac
    done
    #Call restart hostapd directly in ALL VAP case
    activate_ezmesh_hostapd_restart
  else
    case $ap_type in
      $QCMAP_PRIMARY_AP)
        wlan_type=$(uci get qcmap_ezmesh.@primaryap[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@primaryap[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP)
        wlan_type=$(uci get qcmap_ezmesh.@guestap1[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap1[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_2)
        wlan_type=$(uci get qcmap_ezmesh.@guestap2[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap2[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_3)
        wlan_type=$(uci get qcmap_ezmesh.@guestap3[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap3[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_4)
        wlan_type=$(uci get qcmap_ezmesh.@guestap4[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap4[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_5)
        wlan_type=$(uci get qcmap_ezmesh.@guestap5[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap5[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_6)
        wlan_type=$(uci get qcmap_ezmesh.@guestap6[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap6[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_7)
        wlan_type=$(uci get qcmap_ezmesh.@guestap7[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap7[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_8)
        wlan_type=$(uci get qcmap_ezmesh.@guestap8[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap8[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_9)
        wlan_type=$(uci get qcmap_ezmesh.@guestap9[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap9[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_10)
        wlan_type=$(uci get qcmap_ezmesh.@guestap10[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap10[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_11)
        wlan_type=$(uci get qcmap_ezmesh.@guestap11[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap11[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_12)
        wlan_type=$(uci get qcmap_ezmesh.@guestap12[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap12[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;

      $QCMAP_GUEST_AP_13)
        wlan_type=$(uci get qcmap_ezmesh.@guestap13[0].wlan_ap_type)
        if [ $wlan_type == $ap_type ]; then
          intf=$(uci get qcmap_ezmesh.@guestap13[0].ifname)
          idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
          log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "adding $intf to idx:$idx"
          add_athx_to_list $idx $intf
          activate_ezmesh_hostapd_restart
        fi
        ;;
    *)
      log $(basename "$0") "activate_ezmesh_hostapd_ap_config" $LINENO "Invalid ap_type"
      return
    esac
  fi

  echo "Activate EZMesh Hostapd AP config success"
}

case $1 in
  set_ezmesh_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_config" $LINENO "set_ezmesh_config"
      set_ezmesh_config $2 $3 $4
    fi
    ;;

  set_ezmesh_ap_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_ap_config" $LINENO "set_ezmesh_ap_config"
      set_ezmesh_ap_config $2 $3 $4 $5
    fi
    ;;

  set_ezmesh_per_band_count)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_per_band_count" $LINENO "set_ezmesh_per_band_count"
      set_ezmesh_per_band_count $2 $3 $4
    fi
    ;;

  set_ezmesh_r2_traffic_separation)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_r2_traffic_separation" $LINENO "set_ezmesh_r2_traffic_separation"
      set_ezmesh_r2_traffic_separation $2
    fi
    ;;

  set_ezmesh_vlan_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_vlan_config" $LINENO "set_ezmesh_vlan_config"
      set_ezmesh_vlan_config $2 $3 $4 $5 $6 $7 $8 $9 ${10}
    fi
    ;;

  set_ezmesh_r3_service_priority)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_r3_service_priority" $LINENO "set_ezmesh_r3_service_priority"
      set_ezmesh_r3_service_priority $2
    fi
    ;;

  set_ezmesh_update_wireless)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_update_wireless" $LINENO "set_ezmesh_update_wireless"
      set_ezmesh_update_wireless
    fi
    ;;

  set_ezmesh_update_ifaces)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_update_ifaces" $LINENO "set_ezmesh_update_ifaces"
      set_ezmesh_update_ifaces
    fi
    ;;

  set_ezmesh_repacd_start)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_start" $LINENO "set_ezmesh_repacd_start"
      set_ezmesh_repacd_start
    fi
    ;;

  set_ezmesh_repacd_stop)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_stop" $LINENO "set_ezmesh_repacd_stop"
      set_ezmesh_repacd_stop
    fi
    ;;

  set_ezmesh_repacd_restart)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_restart" $LINENO "set_ezmesh_repacd_restart"
      set_ezmesh_repacd_restart
    fi
    ;;

  set_ezmesh_repacd_restore)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:set_ezmesh_repacd_restore" $LINENO "set_ezmesh_repacd_restore"
      set_ezmesh_repacd_restore
    fi
    ;;

  enable_ezmesh_on_bootup)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:enable_ezmesh_on_bootup" $LINENO "enable_ezmesh_on_bootup"
      enable_ezmesh_on_bootup
    fi
    ;;

  activate_ezmesh_hostapd_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_config" $LINENO "activate_ezmesh_hostapd_config"
      activate_ezmesh_hostapd_config $2 $3
    fi
    ;;

  activate_ezmesh_hostapd_ap_config)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_ap_config" $LINENO "activate_ezmesh_hostapd_ap_config"
      activate_ezmesh_hostapd_ap_config $2
    fi
    ;;

  activate_ezmesh_hostapd_restart)
    if [ $CDT_WLAN_WKK_ATTACH == $CDT_TYPE ]; then
      log  $(basename "$0") "case:activate_ezmesh_hostapd_restart" $LINENO "activate_ezmesh_hostapd_restart"
      activate_ezmesh_hostapd_restart
    fi
    ;;

  *)

    log  $(basename "$0") "case: Invalid" $LINENO "Invalid option"
    ;;

esac

