#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#  Usage: tinyproxyConfig.sh enable_tinyproxy

. /etc/data/mbbUtils.sh
. /etc/data/lanUtils.sh

QCMAP_TINYPROXY_DISABLED=2 # == QCMAP_MSGR_TINY_PROXY_MODE_DOWN_V01
QCMAP_TINYPROXY_ENABLED=1  # == QCMAP_MSGR_TINY_PROXY_MODE_UP_V01

#Enable TinyProxy, add uci option in qcmap_lan.
function enable_tinyproxy() {

  uci set qcmap_lan.@no_of_configs[0].enable_tinyproxy=$QCMAP_TINYPROXY_ENABLED
  uci commit qcmap_lan

  log $(basename "$0") "enable_tinyproxy" $LINENO ": user enable tinyproxy successfully "
}

#Disable TinyProxy, delete uci option in qcmap_lan.
function disable_tinyproxy() {

  uci set qcmap_lan.@no_of_configs[0].enable_tinyproxy=$QCMAP_TINYPROXY_DISABLED
  uci commit qcmap_lan

  log $(basename "$0") "disable_tinyproxy" $LINENO ": disable_tinyproxy successfully "
}

#Setup TinyProxy.
function setup_tinyproxy() {
  local defaultProfileId=$(util_execute_uci get qcmap_lan.@no_of_configs[0].default_pdn)
  local no_of_profiles=$(util_execute_uci get qcmap_lan.@no_of_configs[0].no_of_profiles)

  for i in $(seq 0 $((no_of_profiles-1)))
  do
    profile_id=$(util_execute_uci get qcmap_lan.@profile[$i].profile_id)

    #check if profile_id is same as profile
    if [ $profile_id -eq $defaultProfileId ]; then
      profile_idx=$i
      break
    fi
  done

  ipv4_backhaul=$(util_execute_uci get qcmap_lan.@profile[$profile_idx].bh_present)

  if [ "$ipv4_backhaul" == "wan" ] ; then
    uci set tinyproxy.@tinyproxy[0].enabled='1'
    log $(basename "$0") "setup_tinyproxy" $LINENO ": setup_tinyproxy successfully "
    echo "setup_tinyproxy success"

    uci commit tinyproxy
    /etc/init.d/tinyproxy enable
    /etc/init.d/tinyproxy start
  fi
}

#Stop TinyProxy.
function stop_tinyproxy() {
  local tinyproxy_pid_file=/var/run/tinyproxy.pid

  rm -rf /var/log/tinyproxy.log

  uci set tinyproxy.@tinyproxy[0].enabled='0'


  echo "stop_tinyproxy success"

  uci commit tinyproxy

  if [ -f $tinyproxy_pid_file ]; then
    /etc/init.d/tinyproxy stop
    log $(basename "$0") "stop_tinyproxy" $LINENO ": pid file exists, stop_tinyproxy successfully "
    return
  fi

  log $(basename "$0") "stop_tinyproxy" $LINENO ": tinyproxy not enabled "
}

case $1 in
  enable_tinyproxy)
    log  $(basename "$0") "enable_tinyproxy" $LINENO "enable_tinyproxy"
    enable_tinyproxy
    ;;

  disable_tinyproxy)
    log  $(basename "$0") "disable_tinyproxy" $LINENO "disable_tinyproxy"
    disable_tinyproxy
    ;;

  setup_tinyproxy)
    log  $(basename "$0") "setup_tinyproxy" $LINENO "setup_tinyproxy"
    setup_tinyproxy
    ;;

  stop_tinyproxy)
    log  $(basename "$0") "stop_tinyproxy" $LINENO "stop_tinyproxy"
    stop_tinyproxy
    ;;

  *)
    log $(basename "$0") "" $LINENO ":Invalid option"
    ;;

esac
