#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh

if [[ "$#" -le 0 ]]; then
  echo "Check usage sfeConfig.sh <functions> <arg1> <arg2> <...>"
  return 0
fi

function load_sfe() {
  max_retry=50;
  retry=0;


  /usr/bin/data_path_opt -l SFE

  while [[ "$retry" -le "$max_retry" ]]
  do
    result=$(lsmod | grep sfe)
    if [[ "$result" != "" ]]; then
      echo "Load sfe success and enable flag set for sfe"
      uci set qcmap_sfe.@sfe_enable_info[0].sfe_enable_flag="1"
      uci commit qcmap_sfe
      break
    fi
    let retry++
  done

  if [[ "$retry" -ge "$max_retry" ]]; then
    echo "Load sfe fail"
  fi

  return
}

function unload_sfe() {
  max_retry=50;
  retry=0;

  /usr/bin/data_path_opt -u SFE

  while [[ "$retry" -le "$max_retry" ]]
  do
    result=$(lsmod | grep sfe)
    if [[ "$result" = "" ]]; then
      echo "UnLoad sfe success and enable flag reset for sfe"
      uci set qcmap_sfe.@sfe_enable_info[0].sfe_enable_flag="0"
      uci commit qcmap_sfe
      break
    fi
    let retry++
  done

  if [[ "$retry" -ge "$max_retry" ]]; then
    echo "UnLoad sfe fail"
  fi

  return
}

case $1 in
  "LOAD_SFE")
  log  $(basename "$0") "case:LOAD_sfe" $LINENO "LOAD_sfe done"
    load_sfe
    break
    ;;
  "UNLOAD_SFE")
  log  $(basename "$0") "case:UNLOAD_sfe" $LINENO "UNLOAD_sfe done"
    unload_sfe
    break
    ;;
  *)
    log  $(basename "$0") "case: Invalid" $LINENO "Invalid option"
    ;;
esac
