#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#  Usage: miniupnpd.sh enable_miniupnpd
#  Usage: miniupnpd.sh disable_miniupnpd
#  Usage: miniupnpd.sh set_notify_interval notify_interval

#source log file.
. /etc/data/mbbUtils.sh

if [[ "$#" -le 0 ]]; then
    log  $(basename "$0") $LINENO ": Usage " "miniupnpd.sh enable_miniupnpd"
    log  $(basename "$0") $LINENO ": Usage " "miniupnpd.sh disable_miniupnpd"
    log  $(basename "$0") $LINENO ": Usage " "miniupnpd.sh set_notify_interval notify_interval"
    return 1
elif [ \( "$1" == "enable_miniupnpd" \) -a \( "$#" -ne 1 \) ]; then
    log  $(basename "$0") $LINENO "Usage: miniupnpd.sh enable_miniupnpd"
    return 1
elif [ \( "$1" == "disable_miniupnpd" \) -a \( "$#" -ne 1 \) ]; then
    log  $(basename "$0") $LINENO "Usage miniupnpd.sh disable_miniupnpd"
    return 1
elif [ \( "$1" == "set_notify_interval" \) -a \( "$#" -ne 2 \) ]; then
    log  $(basename "$0") $LINENO "Usage miniupnpd.sh set_notify_interval notify_interval"
    return 1
fi

#Enable_upnp
function enable_miniupnpd() {
  uci set upnpd.config.enabled='1'
  uci set upnpd.config.presentation_url="/"$(uci get network.lan.ipaddr )":8201"
  uci commit upnpd
  log $(basename "$0") $LINENO "set presentation_url" "success"
  /etc/init.d/miniupnpd start
  log $(basename "$0") $LINENO "Enable miniupnpd"
}

#Disable_upnp
function disable_miniupnpd() {
  uci set upnpd.config.enabled='0'
  uci commit upnpd
  /etc/init.d/miniupnpd stop
  log $(basename "$0") $LINENO "Stop miniupnpd"
 }

#Set notify_interval
#$1 : notify_interval [30-60000]
function set_notify_interval() {
  local notify_interval=$1
  uci set upnpd.config.notify_interval="$notify_interval"
  uci commit upnpd
  log $(basename "$0") $LINENO "set_notify_interval"
}

case $1 in
  enable_miniupnpd)
    enable_miniupnpd
    ;;
  disable_miniupnpd)
    disable_miniupnpd
    ;;
  set_notify_interval)
    set_notify_interval $2
    ;;
  *)
    log $(basename "$0") $LINENO "case: " "Invalid option"
    ;;
esac


