#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#  Usage: mdns.sh enable_mdns
#  Usage: mdns.sh disable_mdns

#source log file.
. /etc/data/mbbUtils.sh

if [[ "$#" -le 0 ]]; then
    log  $(basename "$0") $LINENO ": Usage " "mdns.sh enable_mdns"
    log  $(basename "$0") $LINENO ": Usage " "mdns.sh disable_mdns"
    return 1
elif [ \( "$1" == "enable_mdns" \) -a \( "$#" -ne 1 \) ]; then
    log  $(basename "$0") $LINENO "Usage: mdns.sh enable_mdns"
    return 1
elif [ \( "$1" == "disable_mdns" \) -a \( "$#" -ne 1 \) ]; then
    log  $(basename "$0") $LINENO "Usage mdns.sh disable_mdns"
    return 1
fi

#Enable_mdns
function enable_mdns() {
  /etc/init.d/avahi-daemon start
  log $(basename "$0") $LINENO "Enable mdns"
}

#Disable_mdns
function disable_mdns() {
  /etc/init.d/avahi-daemon stop
  log $(basename "$0") $LINENO "Stop mdns"
 }


case $1 in
  enable_mdns)
    enable_mdns
    ;;
  disable_mdns)
    disable_mdns
    ;;

  *)
    log $(basename "$0") $LINENO "case: " "Invalid option"
    ;;
esac
