#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.


. /lib/functions.sh
. /lib/functions/network.sh
. /lib/netifd/netifd-proto.sh

[ -z "$1" ] && echo "No event provided" && return 1
[ -z "$2" ] && echo "No profile number provided" && return 1


CFG=
rmnet_find_cfg() {
    local cfg=$1
    local profile proto
    config_get proto $cfg "proto"
    config_get profile $cfg "profile"
    if [ "$proto" = "rmneteth" ] && [ "$profile" = "$2" ]; then
        CFG=$cfg
    fi
}

config_load network
config_foreach rmnet_find_cfg interface $2
[ -z "$CFG" ] && {
    logger "No CFG found for the profile $2"
    exit 0
}


case "$1" in
    up)
    [ -f /tmp/ethpduconfig$2 ] || sleep 1;
    [ -f /tmp/ethpduconfig$2 ] && . /tmp/ethpduconfig$2
    vlan_start=$VLAN_START
    vlan_end=$VLAN_END
    interface=$IFNAME
    echo $(basename "$0")":up():"$LINENO":Add: vlan start:$vlan_start ,vlan end: $vlan_end ,ifname: $interface"
    EthDeviceIndex=$(uci get qcmap_lan.@eth_pdu[0].eth_device_index)
    #Configure VLAN INFO
    if [ $vlan_end -gt $vlan_start ];then
        for i in $(seq $vlan_start $vlan_end)
        do
            uci add network bridge-vlan
            uci set network.@bridge-vlan[-1].vlan=$i
            uci set network.@bridge-vlan[-1].device="br-lan"
            uci set network.@bridge-vlan[-1].ports="eth$EthDeviceIndex:t $interface:t"
            echo $(basename "$0")":up:"$LINENO":configure vlan: $i"
        done
    fi

    if [ $vlan_start -ne 0 -a $vlan_start -eq $vlan_end ];then
        uci add network bridge-vlan
        uci set network.@bridge-vlan[-1].vlan=$vlan_start
        uci set network.@bridge-vlan[-1].device="br-lan"
        uci set network.@bridge-vlan[-1].ports="eth$EthDeviceIndex:t $interface:t"
        echo $(basename "$0")":up:"$LINENO":configure vlan: $vlan_start"
    fi

    #attach device to interface
    uci set network.wan"$2".device="$interface"
    #Add physical port to bridge
#   uci add_list network.@device[0].ports=$interface
    ifname_list=$(uci get network.lan.ifname)
    ifname_list="${ifname_list} $interface"
    uci set network.lan.ifname="$ifname_list"
    #commit and reload
    uci commit network

    #save callinfo in qcmap_lan
    uci add qcmap_lan EthPduCallInfo
    uci set qcmap_lan.@EthPduCallInfo[-1].profile=$2
    uci set qcmap_lan.@EthPduCallInfo[-1].EthPduIfName=$interface
    uci commit qcmap_lan

    echo $(basename "$0")":up:"$LINENO":notifying netifd!"
    ubus call network.interface down "{ \"interface\" : \"$CFG\" }"
    sleep 1
    ubus call network.interface up "{ \"interface\" : \"$CFG\" }"

    sleep 1
    echo $(basename "$0")":up:"$LINENO":network reloaded successfully!"
    /etc/init.d/network reload
    ;;

    down)
    # source the eth pdu config file
    [ -f /tmp/ethpduconfig$2 ] && . /tmp/ethpduconfig$2
    vlan_start=$VLAN_START
    vlan_end=$VLAN_END
    interface=$IFNAME
    echo $(basename "$0")":down():"$LINENO":Delete:vlan start:$vlan_start ,vlan end: $vlan_end ,ifname: $interface"
    #Get total vlan number in network file
    total_num=$(grep bridge-vlan /etc/config/network | wc -l)
    #Total vlan number of this call
    #local total_number_of_call
    if [ $vlan_start -eq 0 ]; then
        total_number_of_call=0
    else
        total_number_of_call=$((vlan_end-vlan_start+1))
    fi

    echo $(basename "$0")":down():"$LINENO":device total vlan number: $total_num Call total vlan number for this call: $total_number_of_call."
    if [ $total_num -gt 0 -a $total_number_of_call -gt 0 ];then
        for i in $(seq $vlan_start $vlan_end)
        do
            for j in $(seq 0 $((total_num-1)))
            do
                vlan_id=$(uci get network.@bridge-vlan[$j].vlan)
                if [ $i -eq $vlan_id ];then
                    echo $(basename "$0")":down():"$LINENO":delete vlan:$vlan_id in index:$j"
                    uci delete network.@bridge-vlan[$j]
                    total_num=$((total_num-1))
                    break
                fi
            done
        done
    fi

    #delete device rmnet_ethX from wanX interface
    uci delete network.wan"$2".device
    #Delete physical port from bridge
#   uci del_list network.@device[0].ports=$interface
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$interface// | sed "s/ *$//g")
    uci set network.lan.ifname="$ifname_list"
    #commit network
    uci commit network

    #delete call info from qcmap_lan
    EthPduCallNum=$(grep EthPduCallInfo /etc/config/qcmap_lan | wc -l)
    echo $(basename "$0")":down():"$LINENO":total call info in qcmap_lan: $EthPduCallNum"
    for k in $(seq 0 $((EthPduCallNum-1)))
    do
        profileiHandle=$(uci get qcmap_lan.@EthPduCallInfo[$k].profile)
        if [ $2 -eq $profileiHandle ];then
            echo $(basename "$0")":down():"$LINENO":delete call info from qcmap_lan:$profileiHandle in index:$k"
            uci delete qcmap_lan.@EthPduCallInfo[$k]
            uci commit qcmap_lan
            break
        fi
    done

    #need to reload twice as WA for netifd
    /etc/init.d/network reload
    /etc/init.d/network reload
    echo $(basename "$0")":down():"$LINENO":network reload successfully!"
    ifdown $CFG
    ;;

esac
exit 0
