#!/bin/sh
#  Copyright (c) 2019,2021-2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

[ -n "$INCLUDE_ONLY" ] || {
    . /lib/functions.sh
    . /lib/functions/network.sh
    . ../netifd-proto.sh
    init_proto "$@"
}

proto_rmneteth_setup() {
    local cfg="$1"
    #Call rmnet eth management script below!!
    logger "start rmneteth $cfg"
    /lib/netifd/rmneteth.script setup $cfg
    logger "update rmneteth done"
}

proto_rmneteth_teardown() {
    local cfg="$1"
    #Tear down rmnet eth manager script here.*/
    logger "stop rmneteth cfg:$cfg"
    /lib/netifd/rmneteth.script down $cfg
}

proto_rmneteth_init_config() {
    #ddno_device=1
    available=1
    #proto_config_add_array "downstream:list(string)"
    #proto_config_add_int "bind"
    proto_config_add_int "profile"
}

[ -n "$INCLUDE_ONLY" ] || {
    add_protocol rmneteth
}
