#=============================================================================
# Copyright (c) 2023 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
#=============================================================================

enable_sdxpinn_rproc_tracing()
{
	echo "++++ $0 -> enable_rproc_tracing START" > /dev/kmsg
	# bail out if its perf config
	if [ ! -d /sys/module/msm_rtb ]
	then
		return
	fi
    # Add support for rproc events tracing
    local RPROC_PATH="/sys/kernel/debug/tracing/instances/rproc"
    # Mount tracefs in /sys/kernel/tracing as CONFIG_DEBUG_FS might be
    # disabled and /sys/kernel/debug/tracing might not be available
    if [ ! -d /sys/kernel/debug/tracing ] ; then
        mount -t tracefs nodev /sys/kernel/tracing
        RPROC_PATH="/sys/kernel/tracing/instances/rproc"
    fi
    if [ ! -d RPROC_PATH ] ; then
            mkdir $RPROC_PATH
            echo "rproc_qcom:rproc_qcom_event" > $RPROC_PATH/set_event
    fi
	echo "++++ $0 -> enable_rproc_tracing END" > /dev/kmsg
}

case "$1" in
"start_rproc_tracing")
    enable_sdxpinn_rproc_tracing
    ;;
esac
