#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/wlanConfig_common.sh

if [[ "$#" -le 0 ]]; then
    log  $(basename "$0") $LINENO ": Usage " "wlanConfig_wkk.sh set_wlan_mode mode"
    return 1
elif [ \( "$1" == "set_wlan_mode" \) -a \( "$#" -ne 2 \) ]; then
    log  $(basename "$0") $LINENO ": Usage " "wlanConfig_wkk.sh set_wlan_mode mode"
    return 1
fi

function checkFileExist() {
    #it will check if dst_file_name exists if not will make copy from src_file_name
    local src_file_name=$1
    local dst_file_name=$2
    #check if tmp config file not present
    [ -f $dst_file_name ] || {
        #make a copy
        cp $src_file_name $dst_file_name
    }
}
# Get Backhaul WAN type: get_wan_type <arg1>
# $1 : QCMAP backhaul WAN type.
function set_wlan_mode() {

  local wlan_mode=$1
  checkFileExist /etc/config/qcmap_wlan /etc/config/qcmap_wlan_current
  uci set qcmap_wlan_current.@wlanconfig[0].mode=$wlan_mode
  uci set qcmap_wlan_current.@wlanconfig[0].wlanconfigex='0'
  uci commit qcmap_wlan_current

  add_wanwlan_iface_on_wan_all_zone $1
  log  $(basename "$0") "set_wlan_mode" $LINENO "set_wlan_mode as $wlan_mode done !!!"
}

# Get Backhaul WAN type: get_wan_type <arg1>
# $1 : QCMAP backhaul WAN type.
function set_mld_wlan_mode() {

  local mld_wlan_mode=$1
  checkFileExist /etc/config/qcmap_wlan /etc/config/qcmap_wlan_current
  uci set qcmap_wlan_current.@mldwlanconfig[0].mode=$mld_wlan_mode
  uci set qcmap_wlan_current.@wlanconfig[0].wlanconfigex='1'
  uci commit qcmap_wlan_current

  add_wanwlan_iface_on_wan_all_zone $1
  log  $(basename "$0") "set_wlan_mode" $LINENO "set_wlan_mode as $wlan_mode done !!!"
}

function set_coex_config() {

  local coex_mode=$1
  checkFileExist /etc/config/qcmap_wlan /etc/config/qcmap_wlan_current
  uci set qcmap_wlan_current.@coex[0].enabled=$coex_mode
  uci commit qcmap_wlan_current
  log  $(basename "$0") "set_coex_config" $LINENO "set_coex_config  $coex_mode done !!!"
}

function set_primary_config() {

  local band=$1

  uci set qcmap_wlan_current.@primaryap[0].band=$band
  uci commit qcmap_wlan_current

  log  $(basename "$0") "set_primary_config" $LINENO "set_primary_config on band $band done !!!"
}

function set_ap_config() {

  local ap_count=$1
  local band=$2
  local accessprofile=$3

  uci set qcmap_wlan_current.@apconfig[$ap_count].band=$band
  uci set qcmap_wlan_current.@apconfig[$ap_count].accessprofile=$accessprofile
  uci commit qcmap_wlan_current

  log  $(basename "$0") "set_ap_config" $LINENO "set_ap_config on band $band done !!!"
}

function set_mld_ap_config() {

  local mld_ap_count=$1
  local no_of_mld_link=$2
  local accessprofile=$3

  uci set qcmap_wlan_current.@mldapconfig[$mld_ap_count].no_of_mld_link=$no_of_mld_link
  uci set qcmap_wlan_current.@mldapconfig[$mld_ap_count].accessprofile=$accessprofile
  uci commit qcmap_wlan_current

  log  $(basename "$0") "set_ap_config" $LINENO "set_mld_ap_config done !!!"
}



function set_guest_config() {

local guest1_band=$1
local guest1_accessprofile=$2
local guest2_band=$3
local guest2_accessprofile=$4
local guest3_band=$5
local guest3_accessprofile=$6

#Now at most 4 AP support, so at most 3 guest AP.

  uci set qcmap_wlan_current.@guestap[0].band=$guest1_band
  uci set qcmap_wlan_current.@guestap[0].accessprofile=$guest1_accessprofile
  uci set qcmap_wlan_current.@guestaptwo[0].band=$guest2_band
  uci set qcmap_wlan_current.@guestaptwo[0].accessprofile=$guest2_accessprofile
  uci set qcmap_wlan_current.@guestapthree[0].band=$guest3_band
  uci set qcmap_wlan_current.@guestapthree[0].accessprofile=$guest3_accessprofile
  uci commit qcmap_wlan_current

  log  $(basename "$0") "set_guest_config" $LINENO "set_guest_config on band $1 done !!!"
}

function set_7apguest_config() {
  local band=$1
  local accessprofile=$2
  local index=$3
  uci set qcmap_wlan_current.@guestapconfig[$index].band=$band
  uci set qcmap_wlan_current.@guestapconfig[$index].accessprofile=$accessprofile
  uci commit qcmap_wlan_current

  log  $(basename "$0") "set_7apguest_config" $LINENO "set_7apguest_config on band $1 done !!!"
}

function set_sta_config() {
  local band=$1
  local bridge_mode=$2
  local sta_mode_conn_type=$3
  local ipaddr=$4
  local gateway=$5
  local netmask=$6
  local dnsserver=$7
  local wlan_mode

  wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  uci set qcmap_wlan_current.@stamodeconfig[0].band=$band
  uci set qcmap_wlan_current.@stamodeconfig[0].bridge_mode=$bridge_mode
  uci set qcmap_wlan_current.@stamodeconfig[0].sta_mode_conn_type=$sta_mode_conn_type
  uci set qcmap_wlan_current.@stamodeconfig[0].ipaddr=$ipaddr
  uci set qcmap_wlan_current.@stamodeconfig[0].gateway=$gateway
  uci set qcmap_wlan_current.@stamodeconfig[0].netmask=$netmask
  uci set qcmap_wlan_current.@stamodeconfig[0].dnsserver=$dnsserver

  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
  #delete exiting static type uci entry before reconfiguration
    uci delete network.wanwlan.ipaddr 2> /dev/null
    uci delete network.wanwlan.netmask 2> /dev/null
    uci delete network.wanwlan.dns 2> /dev/null

    if [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
      log  $(basename "$0") "set_sta_config" $LINENO "STA dynamic mode"
      if [ $(util_execute_uci get network.wanwlan.proto) != "none" ] ; then
        util_execute_uci_set "network.wanwlan.proto" "dhcp"
      fi

    elif [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_STATIC ] ; then
      log  $(basename "$0") "set_sta_config" $LINENO "Add STA static mode in network"
      uci set network.wanwlan="interface"
      uci set network.wanwlan.device="wlan0"
      uci set network.wanwlan.proto="static"
      uci set network.wanwlan.ipaddr=$ipaddr
      uci set network.wanwlan.netmask="255.255.255.0"
      uci set network.wanwlan.dns=$dnsserver
    fi
  fi

  uci commit

  log  $(basename "$0") "set_sta_config" $LINENO "set_sta_config done !!!"
}

function set_mld_sta_config() {
  local no_of_mld_link=$1
  local bridge_mode=$2
  local sta_mode_conn_type=$3
  local ipaddr=$4
  local gateway=$5
  local netmask=$6
  local dnsserver=$7
  local mld_wlan_mode

  mld_wlan_mode=$(uci get qcmap_wlan_current.@mldwlanconfig[0].mode)
  uci set qcmap_wlan_current.@mldstaconfig[0].no_of_mld_link=$no_of_mld_link
  uci set qcmap_wlan_current.@mldstaconfig[0].bridge_mode=$bridge_mode
  uci set qcmap_wlan_current.@mldstaconfig[0].sta_mode_conn_type=$sta_mode_conn_type
  uci set qcmap_wlan_current.@mldstaconfig[0].ipaddr=$ipaddr
  uci set qcmap_wlan_current.@mldstaconfig[0].gateway=$gateway
  uci set qcmap_wlan_current.@mldstaconfig[0].netmask=$netmask
  uci set qcmap_wlan_current.@mldstaconfig[0].dnsserver=$dnsserver

  if [ $mld_wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
  #delete exiting static type uci entry before reconfiguration
    uci -q delete network.wanwlan.ipaddr 2> /dev/null
    uci -q delete network.wanwlan.netmask 2> /dev/null
    uci -q delete network.wanwlan.dns 2> /dev/null

    if [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
      log  $(basename "$0") "set_sta_config" $LINENO "STA dynamic mode"
      uci set network.wanwlan.proto="dhcp"

    elif [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_STATIC ] ; then
      log  $(basename "$0") "set_sta_config" $LINENO "Add STA static mode in network"
      uci set network.wanwlan="interface"
      uci set network.wanwlan.proto="static"
      uci set network.wanwlan.ipaddr=$ipaddr
      uci set network.wanwlan.netmask="$gateway"
      uci set network.wanwlan.dns=$dnsserver
    fi
  fi

  uci commit

  log  $(basename "$0") "set_mld_sta_config" $LINENO "set_mld_sta_config done !!!"
}

function get_wlan_iface_name_wkk() {
  log  $(basename "$0") "get_wlan_iface_name_wkk" $LINENO " begin !!!"
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local device_type=$1
  local lan_Iface=""

  if [ $device_type == $QCMAP_MSGR_DEVICE_TYPE_PRIMARY_AP ] ; then
    if [ $(is_primary_ap_availale $wlan_mode) -eq 1 ]; then
        lan_Iface=$(uci get qcmap_wlan.@primaryap[0].ifname)
    fi
  elif [ $device_type == $QCMAP_MSGR_DEVICE_TYPE_GUEST_AP ] ; then
    if [ $(is_guest_ap_availale $wlan_mode) -eq 1 ]; then
        lan_Iface=$(uci get qcmap_wlan.@guestap[0].ifname)
    fi
  elif [ $device_type == $QCMAP_MSGR_DEVICE_TYPE_GUEST_AP_2 ] ; then
    if [ $(is_guest_aptwo_availale $wlan_mode) -eq 1 ]; then
        lan_Iface=$(uci get qcmap_wlan.@guestaptwo[0].ifname)
    fi
  elif [ $device_type == $QCMAP_MSGR_DEVICE_TYPE_GUEST_AP_3 ] ; then
    if [ $(is_guest_apthree_availale $wlan_mode) -eq 1 ]; then
        lan_Iface=$(uci get qcmap_wlan.@guestapthree[0].ifname)
    fi
  fi

  log $(basename "$0") "get_wlan_iface_name_wkk :" $LINENO ": lan iface gets successfully"
  echo $lan_Iface
}
function start_hostapd_cli_service_sta_wkk() {
  log  $(basename "$0") "start_hostapd_cli_service_sta_wkk" $LINENO " begin !!!"
  local wifi_ifaces=$(ls /sys/class/net | grep ath)
  for intf in $wifi_ifaces
  do
    #start hostapd cli service
    idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
    count=`ps | grep -i hostapd | grep -w $intf -c`
    if [ $count -eq 0 ]; then
      for line in $(/usr/sbin/hostapd_cli -i $intf -s /var/run/wpad/hostapd-wifi$idx/ -p /var/run/wpad/hostapd-wifi$idx/ list_sta)
      do
        /usr/bin/QCMAP_StaInterface "$intf" "AP-STA-CONNECTED" "${line}"
        log $(basename "$0") "start_hostapd_cli_service_sta:" $LINENO " notify QCMAP on $intf AP-STA-CONNECTED ${line}"
      done

      /usr/sbin/hostapd_cli -i $intf -s /var/run/wpad/hostapd-wifi$idx/ -p /var/run/wpad/hostapd-wifi$idx/ -B -a /usr/bin/QCMAP_StaInterface
	fi
  done
  log $(basename "$0") "start_hostapd_cli_service_sta_wkk:" $LINENO " hostapd_cli service starts successfully"
}


#GET supplicant state info to check if STA/AP+STA/AP+AP+STA mode is started or not
function get_supplicant_status_wkk() {
  sta_iface=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)
  get_supplicant_status

}

function is_primary_ap_availale()
{
  local wlan_mode=$1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_STA ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_STA ]; then
    echo 1
  else
    echo 0
  fi
}

function is_guest_ap_availale()
{
  local wlan_mode=$1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    echo 1
  else
    echo 0
  fi
}

function is_guest_aptwo_availale()
{
  local wlan_mode=$1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_STA ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP_AP ]; then
    echo 1
  else
    echo 0
  fi
}

function is_guest_apthree_availale()
{
  local wlan_mode=$1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_AP_AP ]; then
    echo 1
  else
    echo 0
  fi
}

function is_sta_available() {
  local wlan_mode=$1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_STA ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_STA ] \
   || [ $wlan_mode -eq $QCMAP_WLAN_MODE_STA_ONLY ]; then
    echo 1
  else
    echo 0
  fi
}

function add_athx_to_list() {
  local idx=$1
  local intf=$2

  if [ $idx -eq 0 ]; then
    wifi0_athlist="${wifi0_athlist} $intf"
  elif [ $idx -eq 1 ]; then
    wifi1_athlist="${wifi1_athlist} $intf"
  else
    wifi2_athlist="${wifi2_athlist} $intf"
  fi
}

function activate_hostapd_config_wkk()
{
  local ap_type=$1
  local action=$2
  local activate_cmd res idx
  local wlan_mode=$(uci -q get qcmap_wlan.@wlanconfig[0].mode)
  local wifi_ifaces=$(ls /sys/class/net | grep ath)

  #wifi multi_up wifiX <athX list from this wifiX>
  #wifi multi_down wifiX <athX list from this wifiX>
  #wifi multi_up wifiX athXA athXB wifiY athYA athYB

  #get wireless config state.
  wlan_state=$(uci -q get wireless.@wifi-iface[0].disabled)
  if [ $wlan_state -eq 1 ]; then
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "WLAN is disabled can't start hostapd"
    return
  fi

  if [ $ap_type -lt $QCMAP_PRIMARY_AP ] || [  $ap_type -gt $QCMAP_ALL_AP ]; then
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Invalid AP type: $ap_type"
    return
  fi

  if [ $action -lt $QCMAP_HOSTAPD_START ] || [ $action -gt $QCMAP_HOSTAPD_RESTART ]; then
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Invalid action type: $action"
    return
  fi

  case $ap_type in
    $QCMAP_PRIMARY_AP)
      res=$(is_primary_ap_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@primaryap[0].ifname)
        wifi_dev="wifi"$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "interface:$intf dev:$wifi_dev"
        activate_cmd="$wifi_dev $intf"
      fi
      log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "activate command: $activate_cmd"
      ;;

    $QCMAP_GUEST_AP)
      res=$(is_guest_ap_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestap[0].ifname)
        wifi_dev="wifi"$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "interface:$intf dev:$wifi_dev"
        activate_cmd="$wifi_dev $intf"
      fi
      log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "activate command: $activate_cmd"
      ;;

    $QCMAP_GUEST_AP_2)
      res=$(is_guest_aptwo_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestaptwo[0].ifname)
        wifi_dev="wifi"$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "interface:$intf dev:$wifi_dev"
        activate_cmd="$wifi_dev $intf"
       fi
      log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "activate command: $activate_cmd"
      ;;

    $QCMAP_GUEST_AP_3)
      res=$(is_guest_apthree_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestapthree[0].ifname)
        wifi_dev="wifi"$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "interface:$intf dev:$wifi_dev"
        activate_cmd="$wifi_dev $intf"
      fi
      log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "activate command: $activate_cmd"
      ;;

    $QCMAP_ALL_AP)
      #check if primary AP is available
      wifi0_athlist=""
      wifi1_athlist=""
      wifi2_athlist=""

      res=$(is_primary_ap_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@primaryap[0].ifname)
        idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "adding $intf to idx:$idx"
        add_athx_to_list $idx $intf
      fi


      res=$(is_guest_ap_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestap[0].ifname)
        idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "adding $intf to idx:$idx"
        add_athx_to_list $idx $intf
      fi

      res=$(is_guest_aptwo_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestaptwo[0].ifname)
        idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "adding $intf to idx:$idx"
        add_athx_to_list $idx $intf
      fi

      res=$(is_guest_apthree_availale $wlan_mode)
      if [ $res -eq 1 ]; then
        intf=$(uci get qcmap_wlan.@guestapthree[0].ifname)
        idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "adding $intf to idx:$idx"
        add_athx_to_list $idx $intf
      fi

      if [ ! -z "$wifi0_athlist" ]; then
        activate_cmd="${activate_cmd}wifi0 "${wifi0_athlist}" "
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Command at wifi0: $activate_cmd"
      fi

      if [ ! -z "$wifi1_athlist" ]; then
        activate_cmd="${activate_cmd}wifi1 "${wifi1_athlist}" "
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Command at wifi1: $activate_cmd"
      fi

      if [ ! -z "$wifi2_athlist" ]; then
        activate_cmd="${activate_cmd}wifi2 "${wifi2_athlist}" "
        log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Command at wifi1: $activate_cmd"
      fi
      ;;
  *)
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Invalid ap_type"
    return
  esac


  log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Command before call : $activate_cmd"
  #Activate multi up/down command on athX based on action type.

  if [ $action -eq $QCMAP_HOSTAPD_START ]; then
    wifi multi_up $activate_cmd >> /dev/null
  elif [ $action -eq $QCMAP_HOSTAPD_STOP ]; then
    wifi multi_down $activate_cmd >> /dev/null
  else
    wifi multi_down $activate_cmd >> /dev/null
    #sleep 5 second to bring down all iface.
    sleep 5
    wifi multi_up $activate_cmd >> /dev/null
  fi
  /etc/data/wlanConfig_wkk.sh start_hostapd_cli_service_sta
  #FIXME: this will be handled by netifd.
  for intf in $wifi_ifaces
  do
    echo 0 > /proc/sys/net/ipv6/conf/$intf/disable_ipv6
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Setting disable_ipv6 flag to 0 for intf:$intf"
  done
  echo "Activate Hostpad Success"
}

function activate_supplicant_config_wkk() {

  local wlan_state
  local intf res wifi_dev activate_cmd
  local wlan_mode=$(uci -q get qcmap_wlan.@wlanconfig[0].mode)
  local wifi_ifaces=$(ls /sys/class/net | grep ath)
  local ipv4config_file="/tmp/ipv4config.wanwlan"

  #get STA IP
  ipv4_public_ip=`cat $ipv4config_file | grep PUBLIC_IP | sed -r 's/.*"(.+)".*/\1/'`

  #get wireless config state.
  wlan_state=$(uci -q get wireless.@wifi-iface[0].disabled)
  if [ $wlan_state -eq 1 ]; then
    log $(basename "$0") "activate_supplicant_config_wkk" $LINENO "WLAN is disabled can't activate supplicant"
    return
  fi
  wanwlan_intf=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)
  res=$(is_sta_available $wlan_mode)
  if [ $res -eq 1 ]; then
    #Get wifi device
    wifi_dev="wifi"$(echo $wanwlan_intf | awk '{ print $1 }' | cut -c 4)
    log $(basename "$0") "activate_supplicant_config_wkk" $LINENO "interface:$wanwlan_intf dev:$wifi_dev"
    activate_cmd="$wifi_dev $wanwlan_intf"
    eval wifi multi_down $activate_cmd >> /dev/null
    sleep 2
    eval wifi multi_up $activate_cmd >> /dev/null
    sleep 2
    #FIXME: this will be handled by netifd.
    for intf in $wifi_ifaces
    do
      echo 0 > /proc/sys/net/ipv6/conf/$intf/disable_ipv6
      log $(basename "$0") "activate_supplicant_config_wkk" $LINENO "Setting disable_ipv6 flag to 0 for intf:$intf"
    done
    #Inform netifd about STA interface
    cmd="ubus call network.interface.wanwlan add_device '{\"name\": \""$wanwlan_intf"\"}'"
    eval "$cmd" >> /dev/null
    cmd="ubus call network.interface.wanwlan_v6 add_device '{\"name\": \""$wanwlan_intf"\"}'"
    eval "$cmd" >> /dev/null

    #Delete conntrack entry
    cmd="conntrack -D -d ${ipv4_public_ip}"
    log $(basename "$0") "activate_supplicant_config_wkk" $LINENO "deleting conntrack: $cmd"
    eval $cmd >> /dev/null
    echo "Activate supplicant Success"
  fi
}

function update_guestap_wkk() {
  local intf=$1
  local count=$2
  local accessprofile=""

  log $(basename "$0") "update_guestap_wkk" $LINENO "Begin: count:$count intf:$intf"
  case $count in
    1)
      accessprofile=$(uci get qcmap_wlan.@guestap[0].accessprofile)
      ;;
    2)
      accessprofile=$(uci get qcmap_wlan.@guestaptwo[0].accessprofile)
      ;;
    3)
      accessprofile=$(uci get qcmap_wlan.@guestapthree[0].accessprofile)
      ;;
    *)
      log $(basename "$0") "update_guestap_wkk" $LINENO "Invalid Guest AP count"
  esac
  uci commit qcmap_wlan

  if [ ! -z $accessprofile ] && [ $accessprofile -eq $INTERNET_ONLY ]; then
    log $(basename "$0") "update_guestap_wkk" $LINENO "Guest AP$count: $intf found with access:$accessprofile"
    utility_install_single_guestap_access_rules $intf
    #Inform IPA about guest AP internet mode
    ipa xml wlanmode $intf internet
  fi
}

function update_7apguestconfig_wkk() {
  local intf=$1
  local count=$2
  local accessprofile=""

  log $(basename "$0") "update_7apguestconfig_wkk" $LINENO "Begin: count:$count intf:$intf"
  accessprofile=$(uci get qcmap_wlan.@guestapconfig[$count].accessprofile)

  uci commit qcmap_wlan_current

  if [ ! -z $accessprofile ] && [ $accessprofile -eq $INTERNET_ONLY ]; then
    log $(basename "$0") "update_7apguestconfig_wkk" $LINENO "Guest AP$count: $intf found with access:$accessprofile"
    utility_install_single_guestap_access_rules $intf
    #Inform IPA about guest AP internet mode
    ipa xml wlanmode $intf internet
  fi
}

function update_network_config_wkk() {
  #update Network config.
  local wifi_ifaces=$(ls /sys/class/net | grep ath)
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local sta_iface
  local all_iface ap_iface primary_ap guest_ap_iface idx band
  local wifi0_band=$(cfg80211tool wifi0 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi1_band=$(cfg80211tool wifi1 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi2_band=$(cfg80211tool wifi2 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local ifname_list

  wifi0_athlist=""
  wifi1_athlist=""
  wifi2_athlist=""

  log $(basename "$0") "update_network_config_wkk" $LINENO "Begin: Setting network config with mode: $wlan_mode"
  #delete any STA interface attach to wanwlan, will add only if any STA config found
  uci delete network.wanwlan.device 2> /dev/null
  for intf in $wifi_ifaces
  do
    #Get mode for Interface $intf
    tmp=$(cfg80211tool $intf get_opmode)
    mode=$(echo $tmp | awk '{ print $2 }' | cut -c 12-)
    if [ $mode == "HOSTAP" ]; then
      #update network file
      ifname_list=$(uci get network.lan.ifname)
      ifname_list=$(echo "$ifname_list" | sed s/$intf//)
      ifname_list=$(echo "$ifname_list" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')    #Remove first/last and trailing spaces if any
      ifname_list="${ifname_list} $intf"
      uci set network.lan.ifname="$ifname_list"
      uci set network.$intf="interface"
      uci set network.$intf.device="$intf"
      uci set network.$intf.proto="static"
      uci set network.$intf.ipv6="1"
    else
    #store STA interface if we found any.
      log $(basename "$0") "update_network_config_wkk" $LINENO "STA intf found: $intf"
      sta_iface=$intf
    fi
  done

  #Update STA config.
  if [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    #if STA config found then update network config
    #delete any previous config
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$sta_iface//)
    uci set network.lan.ifname="$ifname_list"
    uci delete network."$sta_iface" 2> /dev/null
    uci -q delete network.wanwlan.device
    uci -q delete network.wanwlan_v6.device
    uci set network.wanwlan.device="$sta_iface"
    uci set network.wanwlan_v6.device="$sta_iface"
    uci set qcmap_wlan.@stamodeconfig[0].ifname="$sta_iface"
    log $(basename "$0") "update_network_config_wkk" $LINENO "STA config found adding $sta_iface to STA config"
  fi

  all_iface=$(echo $wifi_ifaces | sed s'/\n/ /g')
  ap_iface=$all_iface

  #remove sta interface from the list.
    if [ ! -z $sta_iface ]; then
      ap_iface=$(echo $all_iface | sed s/$sta_iface//)
    fi

  for intf in $ap_iface
  do
    idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
    log $(basename "$0") "update_network_config_wkk" $LINENO "adding $intf to idx:$idx"
    add_athx_to_list $idx $intf
  done

  log $(basename "$0") "update_network_config_wkk ***** wifi0" $LINENO  "$wifi0_athlist"
  log $(basename "$0") "update_network_config_wkk ***** wifi1" $LINENO  "$wifi1_athlist"
  log $(basename "$0") "update_network_config_wkk ***** wifi2" $LINENO  "$wifi2_athlist"

  if [ $(is_primary_ap_availale $wlan_mode) -eq 1 ] || [ $wlan_mode -eq $QCMAP_WLAN_MODE_7AP ]; then
    #set primary AP interface.
    intf=""
    band=$(uci get qcmap_wlan.@primaryap[0].band)
    if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
        intf=$(echo $wifi1_athlist | awk '{print $1}')
        wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
        log $(basename "$0") "After update PA intf:$intf band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
    elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
        intf=$(echo $wifi0_athlist | awk '{print $1}')
        wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
        log $(basename "$0") "After update PA intf:$intf band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
    elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
        intf=$(echo $wifi2_athlist | awk '{print $1}')
        wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
        log $(basename "$0") "After update PA intf:$intf band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
    fi

    if [ ! -z $intf ]; then
        log $(basename "$0") "update_network_config_wkk" $LINENO "Primary AP available band:$band intf:$intf"
        uci set qcmap_wlan.@primaryap[0].ifname="$intf"
        #remove primary AP interface from list.
        guest_ap_iface=$(echo $ap_iface | sed s/$intf //)
        log $(basename "$0") "$****update_network_config_wkk" $LINENO "**All guest AP :$guest_ap_iface"
    fi
  fi

  utility_update_guest_ap_public_ip
  count=1
  if [ $wlan_mode -eq $QCMAP_WLAN_MODE_7AP ]; then
    #update Guest AP for in 7AP mode
    local max_guest_ap_count=$(uci get qcmap_wlan.@wlanconfig[0].totalapcount)
    for i in ` seq 0 $((max_guest_ap_count-1))`
      do
        band=$(uci get qcmap_wlan.@guestapconfig[$i].band)
        intf=""
        if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
            intf=$(echo $wifi1_athlist | awk '{print $1}')
            wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
            log $(basename "$0") "After update GAP intf:$intf  band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
        elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
            intf=$(echo $wifi0_athlist | awk '{print $1}')
            wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
            log $(basename "$0") "After update GAP intf:$intf  band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
        elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
            intf=$(echo $wifi2_athlist | awk '{print $1}')
            wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
            log $(basename "$0") "After update GAP intf:$intf  band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
        fi

        if [ ! -z $intf ]; then
            log $(basename "$0") "update_network_config_wkk" $LINENO "Guest AP available band:$band intf:$intf"
            uci set qcmap_wlan.@guestapconfig[$i].ifname="$intf"
            update_7apguestconfig_wkk $intf $i
        fi
      done
  else
  if [ $(is_guest_ap_availale $wlan_mode) -eq 1 ]; then
    #set primary AP interface.
    band=$(uci get qcmap_wlan.@guestap[0].band)
    intf=""
    if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
        intf=$(echo $wifi1_athlist | awk '{print $1}')
        wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP intf:$intf  band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
    elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
        intf=$(echo $wifi0_athlist | awk '{print $1}')
        wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP intf:$intf  band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
    elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
        intf=$(echo $wifi2_athlist | awk '{print $1}')
        wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP intf:$intf  band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
    fi

    if [ ! -z $intf ]; then
        log $(basename "$0") "update_network_config_wkk" $LINENO "Guest AP available band:$band intf:$intf"
        uci set qcmap_wlan.@guestap[0].ifname="$intf"
        update_guestap_wkk $intf $count
        count=$((count+1))
    fi
  fi

  if [ $(is_guest_aptwo_availale $wlan_mode) -eq 1 ]; then
    #set primary AP interface.
    band=$(uci get qcmap_wlan.@guestaptwo[0].band)
    intf=""
    if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
        intf=$(echo $wifi1_athlist | awk '{print $1}')
        wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP2 intf:$intf  band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
    elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
        intf=$(echo $wifi0_athlist | awk '{print $1}')
        wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP2 intf:$intf  band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
    elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
        intf=$(echo $wifi2_athlist | awk '{print $1}')
        wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP2 intf:$intf  band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
    fi

     if [ ! -z $intf ]; then
        log $(basename "$0") "update_network_config_wkk" $LINENO "Guest AP2 available band:$band intf:$intf"
        uci set qcmap_wlan.@guestaptwo[0].ifname="$intf"
        update_guestap_wkk $intf $count
        count=$((count+1))
    fi
  fi

  if [ $(is_guest_apthree_availale $wlan_mode) -eq 1 ]; then
    #set primary AP interface.
    band=$(uci get qcmap_wlan.@guestapthree[0].band)
    intf=""
    if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
        intf=$(echo $wifi1_athlist | awk '{print $1}')
        wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP3 intf:$intf  band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
    elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
        intf=$(echo $wifi0_athlist | awk '{print $1}')
        wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP3 intf:$intf  band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
    elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
        intf=$(echo $wifi2_athlist | awk '{print $1}')
        wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
        log $(basename "$0") "After update GAP3 intf:$intf  band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
    fi

     if [ ! -z $intf ]; then
        log $(basename "$0") "update_network_config_wkk" $LINENO "Guest AP3 available band:$band intf:$intf"
        uci set qcmap_wlan.@guestapthree[0].ifname="$intf"
        update_guestap_wkk $intf $count
        count=$((count+1))
    fi
  fi
  fi
  uci commit network
  uci commit qcmap_wlan
}

function update_network_config_wkk_ex() {
  #update Network config.
  local wifi_ifaces=$(ls /sys/class/net | grep ath)
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local mld_wlan_mode=$(uci get qcmap_wlan.@mldwlanconfig[0].mode)
  local totalapcount=$(uci get qcmap_wlan.@wlanconfig[0].totalapcount)
  local totalmldapcount=$(uci get qcmap_wlan.@mldwlanconfig[0].totalmldapcount)
  local sta_iface=""
  local all_iface ap_iface primary_ap guest_ap_iface idx band
  local wifi0_band=$(cfg80211tool wifi0 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi1_band=$(cfg80211tool wifi1 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi2_band=$(cfg80211tool wifi2 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local ifname_list
  local mld_count=0 tmp=""

  wifi0_athlist=""
  wifi1_athlist=""
  wifi2_athlist=""

  #remove MLD interfaces from athList.
  mld_ath_intf=""
  for intf in $wifi_ifaces
  do
    tmp=""
    is_dup_link=$(echo $mld_ath_intf | grep $intf -c)
    log $(basename "$0") "update_network_config_wkk_ex" $LINENO "checking for intf:$intf is_dup_link:$is_dup_link"
    if [ $is_dup_link -eq 0 ]; then
        log $(basename "$0") "update_network_config_wkk_ex" $LINENO "dup:$is_dup_link intf:$intf"
        tmp=$(cfg80211tool $intf get_mldev_params 0)
        is_valid_link=$(echo $tmp | grep -w $intf -c)
        log $(basename "$0") "update_network_config_wkk_ex" $LINENO "checking for tmp:$tmp is_valid_link:$is_valid_link"
        if [ -n "$tmp" ] && [ $is_valid_link -eq 1 ]; then
            partner_link=""
            mld_inft=$(echo $tmp | awk '{print $4}')
            partner_link=$(echo $tmp | grep -o 'ath[0-9]*' | awk -F: '{print $NF}')
            partner_link=$(echo $partner_link | sed s'/\n/ /g')
            primary_link=$(echo $partner_link | awk '{print $1}')
            log $(basename "$0") "before update_network_config_wkk_ex" $LINENO "partner_link:$partner_link primary_link:$primary_link"
            #remove primary link , it will be duplicate in the list
            partner_link=$(echo "$partner_link" | sed s/$primary_link//)
            mld_idx=$(echo $mld_inft | grep -c 3)
            #Update Partner link to MLD config.
            log $(basename "$0") "update_network_config_wkk_ex" $LINENO "partner_link:$partner_link mld_inft:$mld_inft"
            link_count=0
            for link in $partner_link
            do
                uci set qcmap_wlan.@mldapconfig[$mld_idx].link$link_count="$link"
                link_count=$((link_count+1))
                mld_ath_intf="${mld_ath_intf} $link"
            done
            log $(basename "$0") "update_network_config_wkk_ex" $LINENO "**UPDATED: mld_ath_intf: $mld_ath_intf"
        fi
    fi
  done

  #Remove trailing space
  mld_ath_intf=$(echo "$mld_ath_intf" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')
  non_mld_ath_intf=$(echo $wifi_ifaces | sed s'/\n/ /g')
  log $(basename "$0") "update_" $LINENO "**MLD+NON MLD : $non_mld_ath_intf"
  for intf in $mld_ath_intf
  do
    non_mld_ath_intf=$(echo "$non_mld_ath_intf" | sed s/$intf//)
    log $(basename "$0") "update_" $LINENO "**NON-MLD UPDATE : $non_mld_ath_intf removing: $intf"
  done

  #wifi_ifaces
  log $(basename "$0") "update_network_config_wkk_ex" $LINENO "MLD ath link: $mld_ath_intf"
  log $(basename "$0") "update_network_config_wkk_ex" $LINENO "Non-MLD ath link: $non_mld_ath_intf"
  #delete any STA interface attach to wanwlan, will add only if any STA config found
  uci delete network.wanwlan.device 2> /dev/null
  for intf in $non_mld_ath_intf
  do
    #Get mode for Interface $intf
    tmp=$(cfg80211tool $intf get_opmode)
    mode=$(echo $tmp | awk '{ print $2 }' | cut -c 12-)
    if [ $mode == "HOSTAP" ]; then
      #update network file
      ifname_list=$(uci get network.lan.ifname)
      ifname_list=$(echo "$ifname_list" | sed s/$intf//)
      ifname_list=$(echo "$ifname_list" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')    #Remove first/last and trailing spaces if any
      ifname_list="${ifname_list} $intf"
      uci set network.lan.ifname="$ifname_list"
      uci set network.$intf="interface"
      uci set network.$intf.device="$intf"
      uci set network.$intf.proto="static"
      uci set network.$intf.ipv6="1"
    else
    #store STA interface if we found any.
      log $(basename "$0") "update_network_config_wkk_ex" $LINENO "STA intf found: $intf"
      sta_iface=$intf
    fi
  done

  #Update STA config.
  if [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
    #if STA config found then update network config
    #delete any previous config
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$sta_iface//)
    uci set network.lan.ifname="$ifname_list"
    uci delete network."$sta_iface" 2> /dev/null
    uci -q delete network.wanwlan.device
    uci -q delete network.wanwlan_v6.device
    uci set network.wanwlan.device="$sta_iface"
    uci set network.wanwlan_v6.device="$sta_iface"
    uci set qcmap_wlan.@stamodeconfig[0].ifname="$sta_iface"
    log $(basename "$0") "update_network_config_wkk" $LINENO "STA config found adding $sta_iface to STA config"
  fi

  #Update MLD AP interface.
  for i in `seq 0 $((totalmldapcount-1))`
  do
    mld_intf="mld$i"
    uci set qcmap_wlan.@mldapconfig[$i].ifname="$mld_intf"
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$mld_intf//)
    ifname_list=$(echo "$ifname_list" | sed "s/^ *//g" | sed "s/ *$//g" | tr -s ' ')    #Remove first/last and trailing spaces if any
    ifname_list="${ifname_list} $mld_intf"
    uci set network.lan.ifname="$ifname_list"
    mld_count=$((mld_count+1))
    #Update IPA for INTENET Access
    accessprofile=$(uci get qcmap_wlan.@mldapconfig[$i].accessprofile)
    if [ ! -z $accessprofile ] && [ $accessprofile -eq $INTERNET_ONLY ]; then
        log $(basename "$0") "update_network_config_wkk_ex" $LINENO "mld$i found with access:$accessprofile update to IPA"
        no_of_mld_link=$(uci get qcmap_wlan.@mldapconfig[$i].no_of_mld_link)
        for j in `seq 0 $no_of_mld_link`
        do
            intf=$(uci get qcmap_wlan.@mldapconfig[$i].link$j)
            utility_install_single_guestap_access_rules $intf
            #Inform IPA about guest AP internet mode
            ipa xml wlanmode $intf internet
        done
    fi
  done
  uci commit network
  #Update STA config.
  if [ $mld_wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $mld_wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
    #if STA config found then update network config
    #delete any previous config
    mld_sta_iface="mld$mld_count"
    ifname_list=$(uci get network.lan.ifname)
    ifname_list=$(echo "$ifname_list" | sed s/$mld_sta_iface//)
    uci set network.lan.ifname="$ifname_list"
    uci delete network."$mld_sta_iface" 2> /dev/null
    uci -q delete network.wanwlan.device
    uci -q delete network.wanwlan_v6.device
    uci set network.wanwlan.device="$mld_sta_iface"
    uci set network.wanwlan_v6.device="$mld_sta_iface"
    uci set qcmap_wlan.@mldstaconfig[0].ifname="$mld_sta_iface"
    log $(basename "$0") "update_network_config_wkk_ex" $LINENO "STA config found adding $mld_sta_iface to STA config"
  fi

  ap_iface=$non_mld_ath_intf

  #remove sta interface from the list.
  if [ ! -z $sta_iface ]; then
    ap_iface=$(echo $all_iface | sed s/$sta_iface//)
  fi

  for intf in $ap_iface
  do
    idx=$(echo $intf | awk '{ print $1 }' | cut -c 4)
    log $(basename "$0") "update_network_config_wkk_ex" $LINENO "adding $intf to idx:$idx"
    add_athx_to_list $idx $intf
  done

  log $(basename "$0") "update_network_config_wkk ***** wifi0" $LINENO  "$wifi0_athlist"
  log $(basename "$0") "update_network_config_wkk ***** wifi1" $LINENO  "$wifi1_athlist"
  log $(basename "$0") "update_network_config_wkk ***** wifi2" $LINENO  "$wifi2_athlist"


  for i in `seq 0 $((totalapcount-1))`
  do
    intf=""
    band=$(uci get qcmap_wlan.@apconfig[$i].band)
    if [ $band -eq $wifi1_band ] && [ ! -z "$wifi1_athlist" ]; then
        intf=$(echo $wifi1_athlist | awk '{print $1}')
        wifi1_athlist=$(echo "$wifi1_athlist" | sed s/$intf//)
        log $(basename "$0") "AP$i intf:$intf band: $band wifi1_athlist" $LINENO  "$wifi1_athlist"
    elif [ $band -eq $wifi0_band ] && [ ! -z "$wifi0_athlist" ]; then
        intf=$(echo $wifi0_athlist | awk '{print $1}')
        wifi0_athlist=$(echo "$wifi0_athlist" | sed s/$intf//)
        log $(basename "$0") "AP$i intf:$intf intf:$intf band: $band wifi0_athlist" $LINENO  "$wifi0_athlist"
    elif [ $band -eq $wifi2_band ] && [ ! -z "$wifi2_athlist" ]; then
        intf=$(echo $wifi2_athlist | awk '{print $1}')
        wifi2_athlist=$(echo "$wifi2_athlist" | sed s/$intf//)
        log $(basename "$0") "AP$i intf:$intf intf:$intf band: $band wifi2_athlist" $LINENO  "$wifi2_athlist"
    fi

    if [ ! -z $intf ]; then
        log $(basename "$0") "update_network_config_wkk_ex" $LINENO "Primary AP available band:$band intf:$intf"
        uci set qcmap_wlan.@apconfig[$i].ifname="$intf"
        log $(basename "$0") "$****update_network_config_wkk_ex" $LINENO "**All guest AP :$guest_ap_iface"
        accessprofile=$(uci get qcmap_wlan.@apconfig[$i].accessprofile )
        if [ ! -z $accessprofile ] && [ $accessprofile -eq $INTERNET_ONLY ]; then
            log $(basename "$0") "update_network_config_wkk_ex" $LINENO "$intf found with access:$accessprofile update to IPA"
            utility_install_single_guestap_access_rules $intf
            #Inform IPA about guest AP internet mode
            ipa xml wlanmode $intf internet
        fi
    fi
  done

  uci commit network
  uci commit qcmap_wlan
}


function get_total_wireless_config_count() {
  local primary_ap_band=$1
  local guest_ap_band=$2
  local guest_aptwo_band=$3
  local guest_apthree_band=$4
  local band=$5
  config_count=0

  if [ $primary_ap_band -eq $band ]; then
    #dont enable wifi config, we will enable while enabling wifi.
    config_count=$((config_count+1))
    log $(basename "$0") "update_wireless_config" $LINENO "updating primary AP: count:$config_count"
  fi

  #Enabling guest AP mode
  if [ $guest_ap_band -eq $band ]; then
    #dont enable wifi config, we will enable while enabling wifi.
    config_count=$((config_count+1))
    log $(basename "$0") "update_wireless_config" $LINENO "updating Guest AP: count:$config_count"
  fi

  #Enabling guest AP TWO mode
  if [ $guest_aptwo_band -eq $band ]; then
    #dont enable wifi config, we will enable while enabling wifi.
    config_count=$((config_count+1))
    log $(basename "$0") "update_wireless_config" $LINENO "updating Guest AP2: count:$config_count"
  fi

  #Enabling guest AP THREE mode
  if [ $guest_apthree_band -eq $band ]; then
    #dont enable wifi config, we will enable while enabling wifi.
    config_count=$((config_count+1))
    log $(basename "$0") "update_wireless_config" $LINENO "updating Guest AP3: count:$config_count"
  fi

}

function update_wireless_config() {

  local file=$1
  local band=$2
  local wifi_dev=$3
  local max=8
  local ip_octet_tmp=$4
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  local primary_ap_band=$(uci get qcmap_wlan_current.@primaryap[0].band)
  local guest_ap_band=$(uci get qcmap_wlan_current.@guestap[0].band)
  local guest_aptwo_band=$(uci get qcmap_wlan_current.@guestaptwo[0].band)
  local guest_apthree_band=$(uci get qcmap_wlan_current.@guestapthree[0].band)
  local station_band=$(uci get qcmap_wlan_current.@stamodeconfig[0].band)
  local sta_config_found=1
  local wifi0_band=$(cfg80211tool wifi0 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi1_band=$(cfg80211tool wifi1 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi2_band=$(cfg80211tool wifi2 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local mode

  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
    total_ap_number=1
  elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    total_ap_number=2
  elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP ] ; then
    total_ap_number=3
  elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ] ; then
    total_ap_number=4  # only WKK support 4AP
  else
    total_ap_number=0
  fi

  #Set primary band to 5GHz if its not set by user
  if [ \( $primary_ap_band -eq 0 \) -a \( $total_ap_number -ge 1 \) ]; then
    #reset primary band to 0 by default if band is not provided
    log $(basename "$0") "update_wireless_config" $LINENO "setting primary band to 5"
    primary_ap_band=5
    uci set qcmap_wlan_current.@primaryap[0].band="$primary_ap_band"
  fi

  #Set guest AP band to 5GHz if its not set by user
  if [ \( $guest_ap_band -eq 0 \) -a \( $total_ap_number -ge 2 \) ]; then
      #reset primary band to 0 by default if band is not provided
      log $(basename "$0") "update_wireless_config" $LINENO "setting guest ap band to 5"
      guest_ap_band=5
      uci set qcmap_wlan_current.@guestap[0].band="$guest_ap_band"
  fi

  #Set guest AP two band to 5GHz if its not set by user
  if [ \( $guest_aptwo_band -eq 0 \) -a \( $total_ap_number -ge 3 \) ]; then
      #reset primary band to 0 by default if band is not provided
      log $(basename "$0") "update_wireless_config" $LINENO "setting guest ap2 band to 5"
      guest_aptwo_band=5
      uci set qcmap_wlan_current.@guestaptwo[0].band="$guest_aptwo_band"
  fi

  #Set guest AP 3 band to 5GHz if its not set by user
  if [ \( $guest_apthree_band -eq 0 \) -a \( $total_ap_number -eq 4 \) ]; then
      #reset primary band to 0 by default if band is not provided
      log $(basename "$0") "update_wireless_config" $LINENO "setting guest ap3 band to 5"
      guest_apthree_band=5
      uci set qcmap_wlan_current.@guestapthree[0].band="$guest_apthree_band"
  fi

  #Set STA band to 5GHz if its not set by user
  if [ $station_band -eq 0 ]; then
      #reset primary band to 0 by default if band is not provided
      log $(basename "$0") "update_wireless_config" $LINENO "setting STA band to 5"
      station_band=5
      uci set qcmap_wlan_current.@stamodeconfig[0].band="$station_band"
  fi

  #qcmap_wlan
  uci commit qcmap_wlan_current

  #Get totoal config count required in specific band.
  get_total_wireless_config_count $primary_ap_band $guest_ap_band $guest_aptwo_band $guest_apthree_band $band

  #Configure IP address to AP.
  #Link local IP will set by wifi script, update link local IP to AP wireless config.
  for i in `seq $config_count`
  do
    log $(basename "$0") "update_wireless_config" $LINENO "Setting IP addr to AP config"
    uci set $file.@wifi-iface[$((i-1))].ipaddr="169.254.$((ip_octet_tmp)).1"
    ip_octet_tmp=$((ip_octet_tmp+1))
    uci commit
  done

  #update ip octet for other radio.
  ip_octet=$ip_octet_tmp

  log $(basename "$0") "update_wireless_config" $LINENO "config_count: $config_count band:$band"
  #delete unused AP config.delete till last but one.
  for i in `seq $config_count $((max-1))`
  do
    #Check mode before deleting as default config might have different AP/STA count
    mode=$(uci get $file.@wifi-iface[$config_count].mode)
    if [ $mode != "sta" ]; then
    uci delete $file.@wifi-iface[$config_count]
    uci commit $file
    else
      break
    fi
  done

  #delete STA config only STA is not configured
  if [ $wlan_mode != $QCMAP_WLAN_MODE_STA_ONLY ] \
    && [ $wlan_mode != $QCMAP_WLAN_MODE_AP_STA ] \
    && [ $wlan_mode != $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    #delete STA config
    sta_config_found=0
    log $(basename "$0") "update_wireless_config" $LINENO "No STA config found Deleting STA config"
  fi

  #update STA network config to in case of AP-STA router case.
  if [ \( $station_band -eq $band \) -a \( $sta_config_found -eq 1 \) ]; then
    log $(basename "$0") "update_wireless_config" $LINENO "Valid STA config found"
    #delete network option from wireless.
    #Removing option network lan option as wifi doesn't need this information
    #TODO for bridge mode
    uci delete $file.@wifi-iface[$config_count].network
    uci commit $file
  else
    log $(basename "$0") "update_wireless_config" $LINENO "No STA config found Deleting STA config"
    uci delete $file.@wifi-iface[$config_count]
    uci commit $file
  fi


  log $(basename "$0") "update_wireless_config" $LINENO "band:$band sta_config_found:$sta_config_found count:$config_count"
  if [ $config_count -ge 1 ] || [ \( $station_band -eq $band \) -a \( $sta_config_found -eq 1 \) ]; then
  #append config to wireless config file
    log $(basename "$0") "update_wireless_config" $LINENO "valid config found with band:$band"
    #update wifi config flag.
    if [ $band -eq $wifi0_band ]; then
        uci set qcmap_wlan_current.@wlanconfig[0].wifi0_config=1
    elif [ $band -eq $wifi1_band ]; then
        uci set qcmap_wlan_current.@wlanconfig[0].wifi1_config=1
    elif [ $band -eq $wifi2_band ]; then
        uci set qcmap_wlan_current.@wlanconfig[0].wifi2_config=1
    fi
  fi
  #copy config to wireless.
  cat /etc/config/$file >> /etc/config/wireless
  uci commit wireless
  uci commit qcmap_wlan_current

  #reset config_count
  config_count=0
}

function is_wifi_up(){
   output=$(ls /sys/class/net | grep wifi | wc -l)
   if [ $output -eq 3 ]; then
           echo 1
   else
           echo 0
   fi
   }

function update_wkk_wireless_ex() {

  local wifi_dev2 wifi_dev2_mac_addr
  local wifi_dev5 wifi_dev5_mac_addr
  local wifi_dev6 wifi_dev6_mac_addr

  local primary_ap_band=$(uci get qcmap_wlan_current.@primaryap[0].band)
  local guest_ap_band=$(uci get qcmap_wlan_current.@guestap[0].band)
  local guest_aptwo_band=$(uci get qcmap_wlan_current.@guestaptwo[0].band)
  local guest_apthree_band=$(uci get qcmap_wlan_current.@guestapthree[0].band)
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  local mld_wlan_mode=$(uci get qcmap_wlan_current.@mldwlanconfig[0].mode)
  local total_mld_ap_count=$(uci get qcmap_wlan_current.@mldwlanconfig[0].totalmldapcount)
  local mld_ref=0

  #Get wifi devices.
  wifi_devices=$(ls /sys/class/net | grep wifi)
  for device in $wifi_devices
  do
    tmp=$(cfg80211tool $device g_oper_reg_info)
    band=$(echo $tmp | awk '{ print $4 }' | cut -c 6)
    case $band in
      2)
        wifi_dev2=$device
        wifi_dev2_mac_addr=$(cat /sys/class/net/$wifi_dev2/address)
        ;;
      5)
        wifi_dev5=$device
        wifi_dev5_mac_addr=$(cat /sys/class/net/$wifi_dev5/address)
        ;;
      6)
        wifi_dev6=$device
        wifi_dev6_mac_addr=$(cat /sys/class/net/$wifi_dev6/address)
        ;;
      *)
        echo "Invalid Band"
    esac
  done

  echo > /etc/config/wireless

  #reset wifi config flag
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi0_config=0
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi1_config=0
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi2_config=0
  uci commit qcmap_wlan_current

  #update 2g wireless file to tmp
  cp /etc/config/default_wifi_configs/2g_wireless /etc/config/2g_wireless
  sed -i "s/wifiX/$wifi_dev2/g" /etc/config/2g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev2_mac_addr/g" /etc/config/2g_wireless

  #update 5g wireless file to tmp
  cp /etc/config/default_wifi_configs/5g_wireless /etc/config/5g_wireless
  sed -i "s/wifiX/$wifi_dev5/g" /etc/config/5g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev5_mac_addr/g" /etc/config/5g_wireless

  #update 6g wireless file to tmp
  cp /etc/config/default_wifi_configs/6g_wireless /etc/config/6g_wireless
  sed -i "s/wifiX/$wifi_dev6/g" /etc/config/6g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev6_mac_addr/g" /etc/config/6g_wireless

  update_wireless_config_mld 2g_wireless 2 $wifi_dev2 $ip_octet
  update_wireless_config_mld 5g_wireless 5 $wifi_dev5 $ip_octet
  update_wireless_config_mld 6g_wireless 6 $wifi_dev6 $ip_octet

  #Add MLD AP config if any.
  #Note: mld_macaddr is congugurale by user, we are setting dummy mac for all AP
  if [ $total_mld_ap_count -gt 0 ]; then
    for i in `seq 0 $((total_mld_ap_count-1))`
    do
        uci set wireless.mld$i=wifi-mld
        uci set wireless.mld$i.mld_macaddr="aa:bb:cc:dd:ee:ff"
        uci set wireless.mld$i.mld_ssid="QSoftAP_MLD$i"
        uci set wireless.mld$i.mld_ref="$i"
        mld_ref=$((i+1))
        uci commit wireless
    done
  fi

  #Add MLD config for STA if any.
  #Note: mld_macaddr is congugurale by user, we are setting dummy mac for MLD STA
  if [ $mld_wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $mld_wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    uci set wireless.mld$mld_ref=wifi-mld
    uci set wireless.mld$mld_ref.mld_macaddr="aa:bb:cc:dd:ee:ff"
    uci set wireless.mld$mld_ref.mld_ssid="QSoftAP_MLD$mld_ref"
    uci set wireless.mld$mld_ref.mld_ref="$mld_ref"
    uci commit wireless
  fi

  log $(basename "$0") "update_wkk_wireless" $LINENO "/etc/config/wireless updated"
  #delete /etc/confog/Xg_wireless
  rm /etc/config/2g_wireless
  rm /etc/config/5g_wireless
  rm /etc/config/6g_wireless

}

function update_wkk_wireless() {

  local wifi_dev2 wifi_dev2_mac_addr
  local wifi_dev5 wifi_dev5_mac_addr
  local wifi_dev6 wifi_dev6_mac_addr

  local primary_ap_band=$(uci get qcmap_wlan_current.@primaryap[0].band)
  local guest_ap_band=$(uci get qcmap_wlan_current.@guestap[0].band)
  local guest_aptwo_band=$(uci get qcmap_wlan_current.@guestaptwo[0].band)
  local guest_apthree_band=$(uci get qcmap_wlan_current.@guestapthree[0].band)
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)

  #Get wifi devices.
  wifi_devices=$(ls /sys/class/net | grep wifi)
  for device in $wifi_devices
  do
    tmp=$(cfg80211tool $device g_oper_reg_info)
    band=$(echo $tmp | awk '{ print $4 }' | cut -c 6)
    case $band in
      2)
        wifi_dev2=$device
        wifi_dev2_mac_addr=$(cat /sys/class/net/$wifi_dev2/address)
        ;;
      5)
        wifi_dev5=$device
        wifi_dev5_mac_addr=$(cat /sys/class/net/$wifi_dev5/address)
        ;;
      6)
        wifi_dev6=$device
        wifi_dev6_mac_addr=$(cat /sys/class/net/$wifi_dev6/address)
        ;;
      *)
        echo "Invalid Band"
    esac
  done

  echo > /etc/config/wireless

  #reset wifi config flag
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi0_config=0
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi1_config=0
  uci -q set qcmap_wlan_current.@wlanconfig[0].wifi2_config=0
  uci commit qcmap_wlan_current

  #update 2g wireless file to tmp
  cp /etc/config/default_wifi_configs/2g_wireless /etc/config/2g_wireless
  sed -i "s/wifiX/$wifi_dev2/g" /etc/config/2g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev2_mac_addr/g" /etc/config/2g_wireless

  #update 5g wireless file to tmp
  cp /etc/config/default_wifi_configs/5g_wireless /etc/config/5g_wireless
  sed -i "s/wifiX/$wifi_dev5/g" /etc/config/5g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev5_mac_addr/g" /etc/config/5g_wireless

  #update 6g wireless file to tmp
  cp /etc/config/default_wifi_configs/6g_wireless /etc/config/6g_wireless
  sed -i "s/wifiX/$wifi_dev6/g" /etc/config/6g_wireless
  sed -i "s/aa:bb:cc:dd:ee:ff/$wifi_dev6_mac_addr/g" /etc/config/6g_wireless

  if [ $wlan_mode -ne $QCMAP_WLAN_MODE_7AP ]; then
    update_wireless_config 2g_wireless 2 $wifi_dev2 $ip_octet
    update_wireless_config 5g_wireless 5 $wifi_dev5 $ip_octet
    update_wireless_config 6g_wireless 6 $wifi_dev6 $ip_octet
  else
    update_7ap_wireless_config 2g_wireless 2 $wifi_dev2 $ip_octet
    update_7ap_wireless_config 5g_wireless 5 $wifi_dev5 $ip_octet
    update_7ap_wireless_config 6g_wireless 6 $wifi_dev6 $ip_octet
  fi

  log $(basename "$0") "update_wkk_wireless" $LINENO "/etc/config/wireless updated"
  #delete /etc/confog/Xg_wireless
  rm /etc/config/2g_wireless
  rm /etc/config/5g_wireless
  rm /etc/config/6g_wireless

}

function update_7ap_wireless_config() {

  local file=$1
  local band=$2
  local wifi_dev=$3
  local max=8
  local ip_octet_tmp=$4
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  local primary_ap_band=$(uci get qcmap_wlan_current.@primaryap[0].band)
  total_ap_number=$(uci get qcmap_wlan_current.@wlanconfig[0].totalapcount)
  local wifi0_band=$(cfg80211tool wifi0 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi1_band=$(cfg80211tool wifi1 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi2_band=$(cfg80211tool wifi2 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local count=0


  #Set primary band to 5GHz if its not set by user
  if [ \( $total_ap_number -ge 1 \) -a \( $primary_ap_band -eq 0 \) ]; then
    #reset primary band to 0 by default if band is not provided
    log $(basename "$0") "update_7ap_wireless_config" $LINENO "setting primary band to 5"
    primary_ap_band=5
    uci set qcmap_wlan_current.@primaryap[0].band="$primary_ap_band"
  fi

  #qcmap_wlan
  uci commit qcmap_wlan_current

  #Get totoal config count required in specific band.
  if [ $band -eq 2 ]; then
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].guestapcount2g)
  elif [ $band -eq 5 ]; then
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].guestapcount5g)
  else
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].guestapcount6g)
  fi

  if [ $primary_ap_band -eq $band ]; then
    count=$((count+1))
  fi

  #Configure IP address to AP.
  #Link local IP will set by wifi script, update link local IP to AP wireless config.
  for i in `seq 0 $((count-1))`
  do
    log $(basename "$0") "update_7ap_wireless_config" $LINENO "Setting IP addr to AP config"
    uci set $file.@wifi-iface[$i].ipaddr="169.254.$((ip_octet_tmp)).1"
    ip_octet_tmp=$((ip_octet_tmp+1))
    uci commit
  done

  #update ip octet for other radio.
  ip_octet=$ip_octet_tmp

  log $(basename "$0") "update_7ap_wireless_config" $LINENO "*****Valid count:$count band:$band***"
  #delete unused AP config.
  for i in `seq $count $max`
  do
    uci delete $file.@wifi-iface[$count]
    uci commit $file
  done

  uci commit $file
  #append config to wireless config file
  log $(basename "$0") "update_7ap_wireless_config" $LINENO "valid config found with band:$band"
  cat /etc/config/$file >> /etc/config/wireless
  uci commit wireless
  #update wifi config flag.
  if [ $band -eq $wifi0_band ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi0_config=1
  elif [ $band -eq $wifi1_band ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi1_config=1
  elif [ $band -eq $wifi2_band ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi2_config=1
  fi

  uci commit qcmap_wlan_current
}

function get_mld_link_count() {
  local band=$1
  local count=0
  mld_ap_count=$(uci get qcmap_wlan_current.@mldwlanconfig[0].totalmldapcount)
  for i in `seq 0 $((mld_ap_count-1))`
  do
    no_of_mld_link=$(uci get qcmap_wlan_current.@mldapconfig[$i].no_of_mld_link)
    for j in `seq 0 $((no_of_mld_link-1))`
    do
        link_band=$(uci get qcmap_wlan_current.@mldapconfig[$i].link_band$j)
        if [ $link_band -eq $band ]; then
            count=$((count+1))
        fi
    done
  done
  echo $count
}

function is_mld_sta_valid_band() {
  local band=$1
  local is_valid_band=0
  local no_of_mld_link=$(uci get qcmap_wlan_current.@mldstaconfig[0].no_of_mld_link)
  log $(basename "$0") "is_mld_sta_valid_band" $LINENO "Dheeraj link found no_of_mld_link:$no_of_mld_link band:$band"
  for i in `seq 0 $((no_of_mld_link-1))`
  do
    link_band=$(uci get qcmap_wlan_current.@mldstaconfig[0].link_band$i)
    if [ $link_band -eq $band ]; then
      log $(basename "$0") "is_mld_sta_valid_band" $LINENO "valid link found band:$band link_band:$link_band"
      is_valid_band=1
      break
    fi
  done
  log $(basename "$0") "is_mld_sta_valid_band" $LINENO "No valid link found for band:$band"
  echo $is_valid_band
}

function update_wireless_config_mld() {

  local file=$1
  local band=$2
  local wifi_dev=$3
  local max=8
  local ip_octet_tmp=$4
  local mld_ap_count=$(uci get qcmap_wlan_current.@mldwlanconfig[0].totalmldapcount)
  local total_ap_number=$(uci get qcmap_wlan_current.@wlanconfig[0].totalapcount)
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  local mld_wlan_mode=$(uci get qcmap_wlan_current.@mldwlanconfig[0].mode)
  local station_band=$(uci get qcmap_wlan_current.@stamodeconfig[0].band)
  local wifi0_band=$(cfg80211tool wifi0 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi1_band=$(cfg80211tool wifi1 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local wifi2_band=$(cfg80211tool wifi2 g_oper_reg_info | awk '{ print $4 }' | cut -c 6)
  local count=0 total_link=0
  local mld_2g_link=0 mld_5g_link=0 mld_6g_link=0
  local sta_config_found=0 mld_sta_config_found=0
  local is_valid_config_found=0

  if [ $mld_ap_count -gt 0 ]; then
    mld_2g_link=$(get_mld_link_count 2)
    mld_5g_link=$(get_mld_link_count 5)
    mld_6g_link=$(get_mld_link_count 6)
  fi
  is_valid_band=$(is_mld_sta_valid_band $band)
  log $(basename "$0") "update_wireless_config_mld" $LINENO "MLD2GLink: $mld_2g_link"
  log $(basename "$0") "update_wireless_config_mld" $LINENO "MLD5GLink: $mld_5g_link"
  log $(basename "$0") "update_wireless_config_mld" $LINENO "MLD6GLink: $mld_6g_link"
  log $(basename "$0") "update_wireless_config_mld" $LINENO "************is_sta_band_valid: $is_valid_band"

  #Get totoal config count required in specific band.
  if [ $band -eq 2 ]; then
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].apcount2g)
    total_link=$(($count + $mld_2g_link))
  elif [ $band -eq 5 ]; then
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].apcount5g)
    total_link=$(($count + $mld_5g_link))
  else
    count=$(uci get qcmap_wlan_current.@wlanconfig[0].apcount6g)
    total_link=$(($count + $mld_6g_link))
  fi


  if [ $total_link -gt 0 ]; then
    is_valid_config_found=1
  fi
  #Configure IP address to AP.
  #Link local IP will set by wifi script, update link local IP to AP wireless config.
  for i in `seq 0 $((total_link-1))`
  do
    log $(basename "$0") "update_wireless_config_mld" $LINENO "Setting IP addr to AP config"
    uci set $file.@wifi-iface[$i].ipaddr="169.254.$((ip_octet_tmp)).1"
    ip_octet_tmp=$((ip_octet_tmp+1))
    uci commit
  done

  #update ip octet for other radio.
  ip_octet=$ip_octet_tmp

  log $(basename "$0") "update_wireless_config_mld" $LINENO "*****Valid count:$count total_link: $total_link"

  #delete unused AP config.
  for i in `seq $total_link $((max-1))`
  do
    uci delete $file.@wifi-iface[$total_link]
    uci commit $file
  done

  #delete STA config only STA is not configured
  if [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
    #delete STA config
    sta_config_found=1
    log $(basename "$0") "update_wireless_config_mld" $LINENO "STA config found for regular AP"
  fi

  if [ $mld_wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $mld_wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
    #delete STA config
    mld_sta_config_found=1
    log $(basename "$0") "update_wireless_config_mld" $LINENO "STA config found for MLD config"
  fi

  #update STA network config to in case of AP-STA router case.
  if [ \( $station_band -eq $band \) -a \( $sta_config_found -eq 1 \) ] \
     || [ \( $mld_sta_config_found -eq 1 \) -a \( $is_valid_band -eq 1 \) ]; then
    log $(basename "$0") "update_wireless_config" $LINENO "Valid STA config found"
    #delete network option from wireless.
    #Removing option network lan option as wifi doesn't need this information
    #TODO for bridge mode
    uci delete $file.@wifi-iface[$total_link].network
    is_valid_config_found=1
  else
    log $(basename "$0") "update_wireless_config_mld" $LINENO "No STA config found Deleting STA config"
    uci delete $file.@wifi-iface[$total_link]
  fi

  uci commit $file

  #append config to wireless config file
  log $(basename "$0") "update_wireless_config_mld" $LINENO "valid config found with band:$band"
  cat /etc/config/$file >> /etc/config/wireless
  uci commit wireless
  #update wifi config flag.
  if [ $band -eq $wifi0_band ] && [ $is_valid_config_found -eq 1 ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi0_config=1
  elif [ $band -eq $wifi1_band ] && [ $is_valid_config_found -eq 1 ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi1_config=1
  elif [ $band -eq $wifi2_band ] && [ $is_valid_config_found -eq 1 ]; then
    uci set qcmap_wlan_current.@wlanconfig[0].wifi2_config=1
  fi

  uci commit qcmap_wlan_current
}

function enable_wlan_wkk() {

  #copy current config.
  local wlan_mode=$(uci get qcmap_wlan_current.@wlanconfig[0].mode)
  local mld_wlan_mode=$(uci get qcmap_wlan_current.@mldwlanconfig[0].mode)
  local wlanconfigex=$(uci get qcmap_wlan_current.@wlanconfig[0].wlanconfigex)
  cp /etc/config/qcmap_wlan_current /etc/config/qcmap_wlan
  uci commit qcmap_wlan

  # we need to enable config in wireless config before wifi up
  sed -i "s/disabled '1'/disabled '0'/g" /etc/config/wireless

  #check if all wifi dev present.
  wifi0_config_available=$(uci -q get qcmap_wlan.@wlanconfig[0].wifi0_config)
  wifi1_config_available=$(uci -q get qcmap_wlan.@wlanconfig[0].wifi1_config)
  wifi2_config_available=$(uci -q get qcmap_wlan.@wlanconfig[0].wifi2_config)

  if [ $wifi0_config_available -eq 0 ]; then
    log $(basename "$0") "enable_wlan_wkk" $LINENO "Disabliling wifi0 config"
    uci -q set wireless.wifi0.disabled='1'
  fi

  if [ $wifi1_config_available -eq 0 ]; then
    log $(basename "$0") "enable_wlan_wkk" $LINENO "Disabliling wifi1 config"
    uci -q set wireless.wifi1.disabled='1'
  fi

  if [ $wifi2_config_available -eq 0 ]; then
    log $(basename "$0") "enable_wlan_wkk" $LINENO "Disabliling wifi2 config"
    uci -q set wireless.wifi2.disabled='1'
  fi
  uci commit wireless

  update_wanwlan_iface_on_wan_zone 1 #add wanwlan in wan zone

  eval /sbin/wifi up >> /dev/null
  #Add respective interface to network
  if [ $wlanconfigex -eq 0 ]; then
    update_network_config_wkk
    if [ $wlan_mode -eq $QCMAP_WLAN_MODE_STA_ONLY ] || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode -eq $QCMAP_WLAN_MODE_AP_STA ]; then
        wanwlan_intf=$(uci get network.wanwlan.device)
        cmd="ubus call network.interface.wanwlan add_device '{\"name\": \""$wanwlan_intf"\"}'"
        eval "$cmd"
        cmd="ubus call network.interface.wanwlan_v6 add_device '{\"name\": \""$wanwlan_intf"\"}'"
        eval "$cmd"
    fi
    ubus call network reload
  else
    update_network_config_wkk_ex
    if [ $mld_wlan_mode -eq $QCMAP_WLAN_MODE_STA_ONLY ] || [ $mld_wlan_mode -eq $QCMAP_WLAN_MODE_AP_STA ]; then
      wanwlan_intf=$(uci get network.wanwlan.device)
      cmd="ubus call network.interface.wanwlan add_device '{\"name\": \""$wanwlan_intf"\"}'"
      eval "$cmd"
      cmd="ubus call network.interface.wanwlan_v6 add_device '{\"name\": \""$wanwlan_intf"\"}'"
      eval "$cmd"
    fi
    ubus call network reload
  fi

  #FIXME: this will be handled by netifd.
  wifi_ifaces=$(ls /sys/class/net | grep ath)
  for intf in $wifi_ifaces
  do
    echo 0 > /proc/sys/net/ipv6/conf/$intf/disable_ipv6
    log $(basename "$0") "activate_hostapd_config_wkk" $LINENO "Setting disable_ipv6 flag to 0 for intf:$intf"
  done
}

function disable_wlan_wkk() {

  local intf

  #Set IPA config to default.
  ath_ifaces=$(ls  /sys/class/net | grep ath)
  for intf in $ath_ifaces
  do
    ipa xml wlanmode $intf full
  done

  /sbin/wifi down >> /dev/null

  update_wanwlan_iface_on_wan_zone 0 #remove wanwlan in wan zone

  #disable wifi config on wireless
  sed -i "s/disabled '0'/disabled '1'/g" /etc/config/wireless
  delete_guest_ap_access_rules

  uci commit wireless
}

function reset_wlan_atbootup_wkk() {
  update_wanwlan_iface_on_wan_zone 0 #remove wanwlan in wan zone

  #disable wifi config on wireless
  sed -i "s/enabled/disabled/g" /etc/config/wireless

  uci commit wireless
}

function get_total_ap_sta_link() {
  log  $(basename "$0") "get_total_ap_sta_link" $LINENO " begin !!!"
  local wlanmode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local mldwlanmode=$(uci get qcmap_wlan.@mldwlanconfig[0].mode)
  local apcount=$(uci get qcmap_wlan.@wlanconfig[0].totalapcount)
  local totalmldapcount=$(uci get qcmap_wlan.@mldwlanconfig[0].totalmldapcount)
  local mldaplink=0
  log  $(basename "$0") "get_total_ap_sta_link" $LINENO " apcount:$apcount totalmldapcount:$totalmldapcount"
  for i in `seq 0 $((totalmldapcount-1))`
  do
    aplink=$(uci get qcmap_wlan.@mldapconfig[$i].no_of_mld_link)
    mldaplink=$((mldaplink+aplink))
  done

  total_ap_link=$((mldaplink+apcount))
  if [ $wlanmode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlanmode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    total_sta_link=1
  elif [ $mldwlanmode == $QCMAP_WLAN_MODE_AP_STA ] || [ $mldwlanmode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    sta_link=$(uci get qcmap_wlan.@mldstaconfig[$i].no_of_mld_link)
    for i in `seq 0 $((sta_link-1))`
    do
        total_sta_link=$((total_sta_link+1))
    done
  fi

  log  $(basename "$0") "get_total_ap_sta_link" $LINENO " AP LInk:total_ap_link:$total_ap_link STA LINK: $total_sta_link !!!"
}

function get_sap_status_wkk() {
  #we need to check total number of ath interface has come
  #up after wifi enabled based on number of AP configured
  local sta_count=0
  #Get SAP status has to checked with running config.
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local wlanconfigex=$(uci get qcmap_wlan.@wlanconfig[0].wlanconfigex)
  local total_expected_link=0

  if [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    #delete STA config
    sta_count=1
  fi

  if [ $wlanconfigex -eq 1 ]; then
    get_total_ap_sta_link
    total_expected_link=$((total_ap_link+total_sta_link))
  else
    get_total_ap_number
    total_expected_link=$((total_ap_number+sta_count))
  fi


  ath_intf=$(ls /sys/class/net | grep ath)
  count=$(echo $ath_intf | wc -w)
  log $(basename "$0") "get_sap_status_wkk" $LINENO "SAP count:$total_ap_number STA count:$sta_count total count:$count"
  if [ $count -eq $total_expected_link ]; then
    echo "ENABLED"
  else
    log  $(basename "$0") "get_sap_status_wkk" $LINENO "Not all ath interface has come up AP count:$count !!!"
  fi
}

function get_sta_status_wkk() {
    local sta_iface
    sta_iface=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)
    get_sta_status $sta_iface
}

function get_active_wlan_info_wkk() {
  #Get active wlan device info, including ifname, AP type, card type and enable state
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  #Store AP type enabled state
  local primary_ap_enabled=0
  local guest_ap_enabled=0
  local guest_ap2_enabled=0
  local guest_ap3_enabled=0
  local sta_enabled=0

  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "Begin wlan mode : $wlan_mode"
  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "get primary AP info"
  #check if primary AP availble and its enabled
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    #get primary ap ifname.
    ifname=$(uci get qcmap_wlan.@primaryap[0].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    if [ $res -eq 1 ]; then
        primary_ap_enabled=1
    fi
  fi

  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "Get Guest AP info"
  #check if guest AP availble and its enabled
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
    #get guest ap ifname.
    ifname=$(uci get qcmap_wlan.@guestap[0].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    if [ $res -eq 1 ]; then
        guest_ap_enabled=1
    fi
  fi

  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "Get Guest AP2 info"
  #check if guest AP2 availble and its enabled
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ]; then
    #get guest ap2 ifname.
    ifname=$(uci get qcmap_wlan.@guestaptwo[0].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    if [ $res -eq 1 ]; then
        guest_ap2_enabled=1
    fi
  fi

  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "Get Guest AP3 info"
  #check if guest AP3 availble and its enabled
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ]; then
    #get guest ap3 ifname.
    ifname=$(uci get qcmap_wlan.@guestapthree[0].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    if [ $res -eq 1 ]; then
        guest_ap3_enabled=1
    fi
  fi

  log  $(basename "$0") "get_active_wlan_info_wkk" $LINENO "Get STA info"
  #check if STA availble and its enabled
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] \
    || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    #get STA ifname.
    ifname=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    if [ $res -eq 1 ]; then
        sta_enabled=1
    fi
  fi

  echo "$wlan_mode $primary_ap_enabled $guest_ap_enabled $guest_ap2_enabled $guest_ap3_enabled $sta_enabled"
}

function get_active_wlan_info_7ap() {
  local result=""
  local ifname
  local is_primary_ap_enable

  local guest_count=$(uci get qcmap_wlan.@wlanconfig[0].totalapcount)
  log  $(basename "$0") "get_active_wlan_info_7ap" $LINENO "Begin totalapcount : $guest_count"

  ifname=$(uci get qcmap_wlan.@primaryap[0].ifname)
  res=$(iwconfig $ifname | grep -c SSID)
  result="${result}$res "

  for i in `seq 0 $((guest_count-2))`
  do
    ifname=$(uci get qcmap_wlan.@guestapconfig[$i].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    result="${result}$res "
  done
  log  $(basename "$0") "get_active_wlan_info_7ap" $LINENO "result:$result count:$guest_count"
  echo $result
}

function get_active_mld_wlan_info() {
  local result=""
  local ifname
  local is_primary_ap_enable

  local apcount=$(uci get qcmap_wlan.@wlanconfig[0].totalapcount)
  local mldapcount=$(uci get qcmap_wlan.@mldwlanconfig[0].totalmldapcount)
  log  $(basename "$0") "get_active_mld_wlan_info" $LINENO "Begin apcount :$apcount mldapcount:$mldapcount"

  for i in `seq 0 $((apcount-1))`
  do
    ifname=$(uci get qcmap_wlan.@apconfig[$i].ifname)
    res=$(iwconfig $ifname | grep -c SSID)
    result="${result}$res "
  done

  #Check MLD AP info
  for i in `seq 0 $((mldapcount-1))`
  do
    ifname=$(uci get qcmap_wlan.@mldapconfig[$i].link0)
    res=$(iwconfig $ifname | grep -c SSID)
    result="${result}$res "
  done

  log  $(basename "$0") "get_active_mld_wlan_info" $LINENO "result:$result count:$apcount mldapcount:$mldapcount"
  echo $result
}

function set_mld_ap_config_len() {
  local apcount2g=$1
  local apcount5g=$2
  local apcount6g=$3
  local totalapcount=$4
  local totalmldapcount=$5

  uci set qcmap_wlan_current.@wlanconfig[0].apcount2g="$apcount2g"
  uci set qcmap_wlan_current.@wlanconfig[0].apcount5g="$apcount5g"
  uci set qcmap_wlan_current.@wlanconfig[0].apcount6g="$apcount6g"
  uci set qcmap_wlan_current.@wlanconfig[0].totalapcount="$totalapcount"
  uci set qcmap_wlan_current.@mldwlanconfig[0].totalmldapcount="$totalmldapcount"
  uci commit
}




case $1 in
  set_wlan_mode)
    log  $(basename "$0") "case:set_wlan_mode" $LINENO "set_wlan_mode"
    set_wlan_mode $2
    ;;

  set_coex_config)
    log  $(basename "$0") "case:set_coex_config" $LINENO "set_coex_config"
    set_coex_config $2
    ;;

  set_mld_wlan_mode)
    log  $(basename "$0") "case:set_mld_wlan_mode" $LINENO "set_mld_wlan_mode"
    set_mld_wlan_mode $2
    ;;

  set_mld_ap_config)
    log  $(basename "$0") "case:set_mld_ap_config" $LINENO "set_mld_ap_config"
    set_mld_ap_config $2 $3 $4
    ;;

  set_ap_config)
    log  $(basename "$0") "case:set_ap_config" $LINENO "set_ap_config"
    set_ap_config $2 $3 $4
    ;;

  set_primary_config)
    log  $(basename "$0") "case:set_primary_config" $LINENO "set_primary_config"
    set_primary_config $2
    ;;

  set_guest_config)
    log  $(basename "$0") "case:set_guest_config" $LINENO "set_guest_config"
    set_guest_config $2 $3 $4 $5 $6 $7
    ;;

  set_7apguest_config)
    log  $(basename "$0") "case:set_7apguest_config" $LINENO "set_7apguest_config"
    set_7apguest_config $2 $3 $4
    ;;

  set_sta_config)
    log  $(basename "$0") "case:set_sta_config" $LINENO "set_sta_config"
    set_sta_config $2 $3 $4 $5 $6 $7 $8
    ;;

  set_mld_sta_config)
    log  $(basename "$0") "case:set_mld_sta_config" $LINENO "set_mld_sta_config"
    set_mld_sta_config $2 $3 $4 $5 $6 $7 $8
    ;;


  update_wireless_network)
    log  $(basename "$0") "case:update_wkk_wireless" $LINENO "update_wkk_wireless"
    update_wkk_wireless
    ;;

  is_wifi_up)
    log  $(basename "$0") "case:is_wifi_up" $LINENO "is_wifi_up"
    is_wifi_up
    ;;
  update_wireless_network_ex)
    log  $(basename "$0") "case:update_wkk_wireless_ex" $LINENO "update_wkk_wireless_ex"
    update_wkk_wireless_ex
    ;;

  enable_wlan)
    log  $(basename "$0") "case:enable_wlan" $LINENO "enable_wlan"
    echo QCMAP:Start WLAN Enable > /dev/kmsg
    enable_wlan_wkk
    ;;

  disable_wlan)
    log  $(basename "$0") "case:disable_wlan" $LINENO "disable_wlan"
    echo QCMAP:Disable WLAN > /dev/kmsg
    disable_wlan_wkk
    ;;

  reset_wlan_atbootup)
    log  $(basename "$0") "case:reset_wlan_atbootup" $LINENO "reset_wlan_atbootup"
    reset_wlan_atbootup_wkk
    ;;

  get_sap_status)
    res=$(get_sap_status_wkk)
    echo $res
    ;;

  get_supplicant_status)
    log  $(basename "$0") "case:get_supplicant_status" $LINENO "get_supplicant_status"
    get_supplicant_status_wkk
    ;;

  set_wlan_bootup_enable)
    log  $(basename "$0") "case:set_wlan_bootup_enable" $LINENO "set_wlan_bootup_enable"
    set_wlan_bootup_enable $2
    ;;

  get_sta_status)
    log  $(basename "$0") "case:get_sta_status" $LINENO "get_sta_status"
    #Need to add WKK device here
    get_sta_status_wkk
    ;;

  activate_hostapd_config)
    log  $(basename "$0") "case:activate_hostapd_config" $LINENO "activate_hostapd_config"
    activate_hostapd_config_wkk $2 $3 $4
    ;;

  activate_supplicant_config)
    log  $(basename "$0") "case:activate_supplicant_config" $LINENO "activate_supplicant_config"
    activate_supplicant_config_wkk
    ;;

  get_active_wlan_info)
    log  $(basename "$0") "case:get_active_wlan_info" $LINENO "get_active_wlan_info"
    get_active_wlan_info_wkk
    ;;

  get_active_wlan_info_7ap)
    log  $(basename "$0") "case:get_active_wlan_info_7ap" $LINENO "get_active_wlan_info_7ap"
    get_active_wlan_info_7ap
    ;;

  get_active_mld_wlan_info)
    log  $(basename "$0") "case:get_active_mld_wlan_info" $LINENO "get_active_mld_wlan_info"
    get_active_mld_wlan_info
    ;;

  get_wlan_iface_name)
    log  $(basename "$0") "case:get_Iface_name" $LINENO "get_Iface_name_wkk"
    get_wlan_iface_name_wkk $2
    ;;

  start_hostapd_cli_service_sta)
    log  $(basename "$0") "case:start_hostapd_cli_service_sta" $LINENO "start_hostapd_cli_service_sta"
    start_hostapd_cli_service_sta_wkk
    ;;

  add_delete_rules_for_bridge_mode)
    log  $(basename "$0") "case: add_delete_rules_for_bridge_mode" $LINENO "add_delete_rules_for_bridge_mode"
    add_delete_rules_for_bridge_mode $2
    ;;

  start_wpa_cli_service)
    log  $(basename "$0") "case:start_wpa_cli_service" $LINENO "start_wpa_cli_service"
    start_wpa_cli_service
    ;;

  ap_sta_bridge_mode_connect)
    log  $(basename "$0") "case:ap_sta_bridge_mode_connect" $LINENO "ap_sta_bridge_mode_connect"
    ap_sta_bridge_mode_connect
    ;;

  ap_sta_bridge_mode_disconnect)
    log  $(basename "$0") "case:ap_sta_bridge_mode_disconnect" $LINENO "ap_sta_bridge_mode_disconnect"
    ap_sta_bridge_mode_disconnect
    ;;

  set_mld_ap_config_len)
    log  $(basename "$0") "case:set_mld_ap_config_len" $LINENO "set_mld_ap_config_len"
    set_mld_ap_config_len $2 $3 $4 $5 $6
    ;;

  get_sta_associcated_status)
    log  $(basename "$0") "case:get_sta_associcated_status" $LINENO "get_sta_associcated_status"
    get_sta_associcated_status
    ;;

  *)
    log  $(basename "$0") "case: Invalid" $LINENO "Invalid option"
    ;;

esac
