#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh

#source common functions

#QCMAP Server have no permission to on /lib/functions.sh which include by lanUtils.sh
#. /etc/data/lanUtils.sh

#Function to execute uci set cmd for string value
#$1 - uci options
#$2 - uci value
function util_execute_uci_set() {
  uci set "$1=$2"
  log $(basename "$0") "util_execute_uci" $LINENO " uci set $1=$2"
}

#Function to execute uci cmd and print to log
#$1 - uci cmd
function util_execute_uci() {
  uci $*
  log  $(basename "$0") "util_execute_uci" $LINENO " uci $*"
}

eval static_ip_wlan0="169.254.24.1"
eval static_ip_wlan1="169.254.25.1"
eval static_ip_wlan2="169.254.26.1"
eval static_ip_wlan3="169.254.27.1"
ip_octet=28
pdev_number=0
QCMAP_WLAN_MODE_AP=1
QCMAP_WLAN_MODE_AP_AP=2
QCMAP_WLAN_MODE_AP_STA=3
QCMAP_WLAN_MODE_AP_AP_AP=4
QCMAP_WLAN_MODE_AP_AP_STA=5
QCMAP_WLAN_MODE_STA_ONLY=6
QCMAP_WLAN_MODE_AP_AP_AP_AP=7
QCMAP_WLAN_MODE_AP_STA_BRIDGE=8
QCMAP_WLAN_MODE_AP_AP_STA_BRIDGE=9
QCMAP_WLAN_MODE_STA_ONLY_BRIDGE=10
QCMAP_WLAN_MODE_7AP=13
total_ap_number=0
total_ap_link=0
total_sta_link=0
prefer_primary_band=0
prefer_second_band=0
station_band=0
QCMAP_STA_CONNECTION_DYNAMIC=1
QCMAP_STA_CONNECTION_STATIC=2
QCMAP_STA_CONNECTED=1
QCMAP_STA_DISCONNECTED=2
INTERNET_ONLY=1
config_count=0
wifi0_athlist=""
wifi1_athlist=""
wifi2_athlist=""

#worst case 12s, one time 150ms
hostapd_start_poll_max_count=80
hostapd_poll_delay_S=0.15

#sap_state used to save every single sap status
sap_state=""

#parameter need to be updated in function utility_update_guest_ap_public_ip
lan_ip=""
netmask=""
lipv4_public_ip=""
prefix_v6=""
prefix_len=0
ipv4_wan_connected=0
ipv6_wan_connected=0

#used to support activate hostapd
QCMAP_PRIMARY_AP=1
QCMAP_GUEST_AP=2
QCMAP_GUEST_AP_2=3
QCMAP_GUEST_AP_3=4
QCMAP_ALL_AP=5
QCMAP_HOSTAPD_START=1
QCMAP_HOSTAPD_STOP=2
QCMAP_HOSTAPD_RESTART=3
ap_pid=0
guest_ap_pid=0
guest_ap2_pid=0
guest_ap3_pid=0
wlan_disable_status=1
hostapd_activate_status=1
activate_ap_number=0
wlan_pdev=pdev0

#check sap/sta 5g enable status
WLAN_5G_ENABLE=1
WLAN_5G_DISABLE=0

QCMAP_MSGR_DEVICE_TYPE_PRIMARY_AP=1
QCMAP_MSGR_DEVICE_TYPE_GUEST_AP=2
QCMAP_MSGR_DEVICE_TYPE_GUEST_AP_2=5
QCMAP_MSGR_DEVICE_TYPE_GUEST_AP_3=6

CDT_WLAN_WKK_ATTACH=3
CDT_TYPE=$(cat /sys/devices/soc0/platform_subtype_id)

function ap_sta_bridge_mode_connect(){

  /etc/init.d/firewall stop

  local sta_mode=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].sta_mode_conn_type)
  local bridge_iface=$(util_execute_uci get network.lan.device)
  local lease_file=$(util_execute_uci get dhcp.lan_dns.leasefile)
  local sta_iface=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].ifname)

  util_execute_uci set qcmap_wlan.@stamodeconfig[0].bridge_flag=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].bridge_mode)

  add_delete_rules_for_bridge_mode 1


  ap_sta_bridge_mac=`ifconfig $sta_iface | grep HWaddr | awk -F' ' '{print $5}'`
  if [ $sta_mode == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
    util_execute_uci delete network.lan.ipaddr
    util_execute_uci delete network.lan.netmask
    util_execute_uci set network.lan.proto="dhcp"
    util_execute_uci set network.lan.macaddr="$ap_sta_bridge_mac"

    util_execute_uci delete network.wanwlan_v6
    util_execute_uci set network.lan_v6="interface"
    util_execute_uci set network.lan_v6.device=$bridge_iface
    util_execute_uci set network.lan_v6.proto="dhcpv6"
    util_execute_uci set network.lan_v6.ipv6="1"
    util_execute_uci set network.lan_v6.type="internet"

    rm -rf $lease_file

    util_execute_uci commit network
    ubus call network reload
  else
    local ip=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].ipaddr)
    local netmask=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].netmask)
    local dns=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].dnsserver)
    local gw=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].gateway)
    local resolv_file=$(util_execute_uci get dhcp.lan_dns.resolvfile)

    util_execute_uci delete network.wanwlan.dns

    util_execute_uci set network.lan.macaddr="$ap_sta_bridge_mac"
    util_execute_uci set network.lan.ipaddr=$ip
    util_execute_uci set network.lan.netmask=$netmask
    util_execute_uci set network.lan.dns=$dns

    util_execute_uci set network.lan_v6="interface"
    util_execute_uci set network.lan_v6.device=$bridge_iface
    util_execute_uci set network.lan_v6.proto="dhcpv6"
    util_execute_uci set network.lan_v6.ipv6="1"
    util_execute_uci set network.lan_v6.type="internet"

    util_execute_uci commit network
    ubus call network reload

    route add default gw $gw dev $bridge_iface

    /etc/data/dhcpRelay.sh enable_dhcp_proxy lan
  fi

  log  $(basename "$0") "ap_sta_bridge_mode_connect" $LINENO "station bridge mode setting done !!!"
}
function ap_sta_bridge_mode_disconnect(){

  local sta_mode=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].sta_mode_conn_type)
  /etc/init.d/firewall start

  util_execute_uci set network.lan.proto="static"
  util_execute_uci set network.lan.ipaddr="192.168.224.1"
  util_execute_uci set network.lan.netmask="255.255.254.0"
  util_execute_uci delete network.lan.dns
  util_execute_uci delete network.lan.macaddr

  util_execute_uci delete network.lan_v6

  util_execute_uci commit network
  ubus call network reload

  add_delete_rules_for_bridge_mode 0

  /etc/data/dhcpRelay.sh disable_dhcp_proxy

  log  $(basename "$0") "ap_sta_bridge_mode_disconnect" $LINENO "station bridge mode revert done !!!"
}
function add_wanwlan_iface_on_wan_all_zone() {
  local wlan_mode=$1

  #Getting wan_all zone index
  zone_wan_all_idx=`util_execute_uci show firewall | grep -i name | grep -i "wan_all" | awk -F'[][]' '{print $2}'`

  #checking if wanwlan iface is already there in the list; if yes, delete it firstly
  all_iface_wan_listed=`util_execute_uci -q get firewall.@zone[$zone_wan_all_idx].network`
  if [ ! -z "$all_iface_wan_listed" ]; then
    for iface in $all_iface_wan_listed
    do
      if [ "$iface" = "wanwlan" ]; then
        log $(basename "$0") "add_wan_iface_on_wan_all_zone :" $LINENO ": wan iface is already added on list network of wan_all zone, need to delete it firstly"
        util_execute_uci del_list firewall.@zone[$zone_wan_all_idx].network="wanwlan"
        util_execute_uci commit firewall
      fi
    done
  fi

  #checking wlan mode. If wlan is STA mode, add wanwlan into wan_all firewall zone,
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    util_execute_uci add_list firewall.@zone[$zone_wan_all_idx].network=wanwlan
    log $(basename "$0") "add_wanwlan_iface_on_wan_all_zone :" $LINENO ": wanwlan iface is successfully added on list network of wan_all zone"
    util_execute_uci commit firewall
  fi
}

function update_wanwlan_iface_on_wan_zone() {
  local wlan_mode=$(util_execute_uci get qcmap_wlan.@wlanconfig[0].mode)
  local isAdd=$1

  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    #Getting wan_all zone index
    zone_wan_idx=`util_execute_uci show firewall | grep -i name | grep -i "'wan'" | awk -F'[][]' '{print $2}'`

    #checking if wanwlan/wanwlan_v6 iface is already there in the list; if yes, delete it
    util_execute_uci -q del_list firewall.@zone[$zone_wan_idx].network="wanwlan"
    util_execute_uci -q del_list firewall.@zone[$zone_wan_idx].network="wanwlan_v6"
    util_execute_uci commit firewall

    if [ $isAdd -eq 1 ]; then
      #checking wlan mode. If wlan is STA mode, add wanwlan into wan_all firewall zone,
      util_execute_uci add_list firewall.@zone[$zone_wan_idx].network=wanwlan
      util_execute_uci add_list firewall.@zone[$zone_wan_idx].network=wanwlan_v6
      log $(basename "$0") "update_wanwlan_iface_on_wan_zone :" $LINENO ": wanwlan iface is successfully added on list network of wan_all zone"
      util_execute_uci commit firewall
    fi

    #don't need firewall reload here, when IP address allocated/deallocated, it will reload firewall from backhaul switch

  fi
}

function get_total_ap_number() {
  log  $(basename "$0") "get_total_ap_number" $LINENO " begin !!!"
  local wlan_mode=$(util_execute_uci get qcmap_wlan.@wlanconfig[0].mode)

  if [ $wlan_mode != $QCMAP_WLAN_MODE_7AP ]; then
    if [ $wlan_mode == $QCMAP_WLAN_MODE_AP ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ]; then
      total_ap_number=1
    elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ]; then
      total_ap_number=2
    elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP ] ; then
      total_ap_number=3
    elif [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_AP_AP ] ; then
      total_ap_number=4  # only WKK support 4AP
    else
      total_ap_number=0
    fi
  else
    total_ap_number=$(util_execute_uci get qcmap_wlan.@wlanconfig[0].totalapcount)
  fi
  log  $(basename "$0") "get_total_ap_number" $LINENO " total $total_ap_number !!!"
}
function start_wpa_cli_service() {
  log  $(basename "$0") "function start_wpa_cli_service" $LINENO " begin !!!"
  local wlan_mode=$(util_execute_uci get qcmap_wlan.@wlanconfig[0].mode)
  local sta_iface=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].ifname)
  local wpa_state

  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
     wpa_state=$(/usr/sbin/wpa_cli -i wlan0 -p /data/vendor/wifi/wpa_supplicant -s /data/vendor/wifi status | grep wpa_state | awk -F'=' '{print $2}')
     if [ -n $wpa_state -a "$wpa_state" == "COMPLETED" ]; then
        /usr/bin/QCMAP_StaInterface "wlan0" "CONNECTED"
        log  $(basename "$0") "start_wpa_cli_service" $LINENO " notify wlan0 CONNECTED"
     fi
     /usr/sbin/wpa_cli -i $sta_iface -p /data/vendor/wifi/wpa_supplicant -s /data/vendor/wifi  -B -a /usr/bin/QCMAP_StaInterface
  fi
}
function add_delete_rules_for_bridge_mode() {

  local add=$1
  local sta_iface=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].ifname)
  local ap_iface=$(util_execute_uci get qcmap_wlan.@primaryap[0].staifname)
  local ap_ap_iface=$(util_execute_uci get qcmap_wlan.@guestap[0].staifname)

  if [ $add == 1 ]; then
    ap_sta_station_mac=`ifconfig $sta_iface | grep HWaddr | awk -F' ' '{print $5}'`
    ap_sta_ap_mac=`ifconfig $ap_iface | grep HWaddr | awk -F' ' '{print $5}'`

    ebtables -t nat -A POSTROUTING -o $sta_iface -j snat --to-source $ap_sta_station_mac
    ebtables -t nat -A POSTROUTING -o $ap_iface -j snat --to-source $ap_sta_ap_mac
    if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] ; then
      ap_sta_ap_ap_mac=`ifconfig $ap_ap_iface | grep HWaddr | awk -F' ' '{print $5}'`
      ebtables -t nat -A POSTROUTING -o $ap_ap_iface -j snat --to-source $ap_sta_ap_ap_mac
    fi
    log  $(basename "$0") "add_delete_rules_for_bridge_mode" $LINENO " add ebtables rules succssfully"
  else
    ebtables -t nat --flush
    ebtables -t filter --flush
    ebtables -t broute --flush

    ip6tables -t filter -D FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
    ip6tables -t filter -D FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
    ip6tables -t filter -D FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP
    ip6tables -t filter -D FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP
    ip6tables -t filter -D OUTPUT -p ipv6-icmp -m icmp6 --icmpv6-type 137 -j DROP
    log  $(basename "$0") "add_delete_rules_for_bridge_mode" $LINENO " delete ip6tables rules succssfully"
  fi
}

function utility_update_guest_ap_public_ip() {
  #default PDN config file
  local current_bh=""
  local default_pdn
  local ipv4config_file
  local ipv6config_file

  lan_ip=$(util_execute_uci get network.lan.ipaddr)
  netmask=$(util_execute_uci get network.lan.netmask)
  current_bh=$(uci -q get qcmap_lan.@profile[0].bh_present)
  if [ "$current_bh" == "wan" ]; then
    default_pdn=$(uci -q get qcmap_lan.@no_of_configs[0].default_pdn)
    ipv4config_file=/tmp/ipv4config$default_pdn
    ipv6config_file=/tmp/ipv6config$default_pdn
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "WWAN BH found with default_pdn:$default_pdn"
  elif [ "$current_bh" != "wan" ]; then
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "non-WWAN BH found: $current_bh"
    ipv4config_file=/tmp/ipv4config.$current_bh
    ipv6config_file=/tmp/ipv6config.$current_bh
  fi

  if [ -f $ipv4config_file ]; then
    ipv4_wan_connected=1
    ipv4_public_ip=`cat $ipv4config_file | grep PUBLIC_IP | sed -r 's/.*"(.+)".*/\1/'`
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "IPV4 WWAN backhual is connected."
  else
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "file $ipv4config_file doesn't exist."
  fi

  if [ -f $ipv6config_file ]; then
    ipv6_wan_connected=1
    prefix_v6=`cat $ipv6config_file | grep PUBLIC_IP6 | sed -r 's/.*"(.+)".*/\1/'`
    prefix_len=`cat $ipv6config_file | grep NETMASK6 | sed -r 's/.*"(.+)".*/\1/'`
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "IPV6 WWAN backhual is connected."
  else
    log  $(basename "$0") "utility_update_guest_ap_public_ip" $LINENO "file $ipv6config_file doesn't exist."
  fi
}

#install single guest ap access rules
#need a input argument, for example: utility_install_single_guestap_access_rules wlan1
#need get the variable value before this function used. $lan_ip, $netmask, $ipv4_public_ip, $prefix_v6, $prefix_len
function utility_install_single_guestap_access_rules() {
  local if_name=$1

  #* ------------------ IPv4 Rules ----------------------- *
  #* Rules to allow DNS/DHCP and block the rest of the traffic from Guest AP Client
  #(interface via which frame is received)  to Apps local subnet *
  ebtables -I INPUT -i $if_name -p IPv4 --ip-proto udp --ip-dport 53 -j ACCEPT
  ebtables -I INPUT -i $if_name -p IPv4 --ip-proto tcp --ip-dport 53 -j ACCEPT
  ebtables -I INPUT -i $if_name -p IPv4 --ip-proto udp --ip-dport 67 -j ACCEPT
  ebtables -A INPUT -i $if_name -p IPv4 --ip-destination $lan_ip/$netmask -j DROP
  ebtables -I INPUT -i $if_name -p IPv4 --ip-proto tcp --ip-dport 8888 -j ACCEPT

  #* Rules to allow DNS/DHCP and block the rest of the traffic from APSS/local subnet
  #to GuestAPClient(interface via which a frame is going to be sent ) *
  ebtables -I OUTPUT -o $if_name -p IPv4 --ip-proto udp --ip-sport 53 -j ACCEPT
  ebtables -I OUTPUT -o $if_name -p IPv4 --ip-proto tcp --ip-sport 53 -j ACCEPT
  ebtables -I OUTPUT -o $if_name -p IPv4 --ip-proto udp --ip-sport 67 -j ACCEPT
  ebtables -A OUTPUT -o $if_name -p IPv4 --ip-source $lan_ip/$netmask -j DROP

  if [ $ipv4_wan_connected == 1 ] && [ \( "$ipv4_public_ip" != "" \) ]; then
    #* Rules to block traffic to pubilc ip on APSS *
    ebtables -D OUTPUT -o $if_name -p IPv4 --ip-source $ipv4_public_ip -j DROP
    ebtables -A OUTPUT -o $if_name -p IPv4 --ip-source $ipv4_public_ip -j DROP
    ebtables -D INPUT -i $if_name -p IPv4 --ip-destination $ipv4_public_ip -j DROP
    ebtables -A INPUT -i $if_name -p IPv4 --ip-destination $ipv4_public_ip -j DROP
  else
    ebtables -A INPUT -i $if_name -p IPv4 -j DROP
    ebtables -A OUTPUT -o $if_name -p IPv4 -j DROP
  fi

  #* ------------------ IPv6 Rules ----------------------- *
  #* Rule to allow ICMP/DNS messages and block rest of the traffic to APSS or local LAN *
  ebtables -I INPUT -i $if_name -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 133:136/0 -j ACCEPT
  ebtables -I INPUT -i $if_name -p IPv6 --ip6-proto udp --ip6-dport 53 -j ACCEPT
  ebtables -I INPUT -i $if_name -p IPv6 --ip6-proto tcp --ip6-dport 53 -j ACCEPT
  ebtables -A INPUT -i $if_name -p IPv6 --ip6-destination fe80::/64 -j DROP

  if [ $ipv6_wan_connected == 1 ] && [ \( "$prefix_v6" != "" \) ]; then
    #* If a global IPv6 prefix is available, also add prefix based input rules *
    ebtables -A INPUT -i $if_name -p IPv6 --ip6-destination $prefix_v6/$prefix_len -j DROP
  fi

  #* Rule to Drop traffic routed from local subnet to guest AP. Allow DNS/ICMP responses *
  ebtables -I OUTPUT -o $if_name -p IPv6 --ip6-proto ipv6-icmp --ip6-icmp-type 133:136/0 -j ACCEPT
  ebtables -I OUTPUT -o $if_name -p IPv6 --ip6-proto udp --ip6-sport 53 -j ACCEPT
  ebtables -I OUTPUT -o $if_name -p IPv6 --ip6-proto tcp --ip6-sport 53 -j ACCEPT
  ebtables -A OUTPUT -o $if_name -p IPv6 --ip6-source fe80::/64 -j DROP

  if [ $ipv6_wan_connected == 1 ] && [ \( "$prefix_v6" != "" \) ]; then
    #* If a global IPv6 prefix is available, also add prefix based output rules *
    ebtables -A OUTPUT -o $if_name -p IPv6 --ip6-source $prefix_v6/$prefix_len -j DROP
  fi

  if [ $ipv6_wan_connected == 0 ]; then
    #* Add Drop rules if there is no backhaul avaulable/connected *
    ebtables -A OUTPUT -o $if_name -p IPv6 -j DROP
    ebtables -A INPUT -i $if_name -p IPv6 -j DROP
  fi

  #* Rules to drop briged traffic to/from LAN from/to guest AP *
  ebtables -A FORWARD -o $if_name -j DROP
  ebtables -A FORWARD -i $if_name -j DROP
}


#clean ebTables filter tables
function delete_guest_ap_access_rules() {
  ebtables -t filter --flush

  for i in $(seq 0 3)
  do
    #Set wlan$i mode to "full" in "/etc/data/ipa/IPACM_cfg.xml"
    ipa xml wlanmode wlan$i full
  done
}

function set_wlan_bootup_enable {
  local set_wlan_bootup=$1

  util_execute_uci set qcmap_lan.@no_of_configs[0].wlan_bootup_enable=$set_wlan_bootup
  util_execute_uci commit qcmap_lan

  log  $(basename "$0") "set_wlan_bootup_enable" $LINENO "set_wlan_bootup_enable as $set_wlan_bootup done !!!"
}

function get_sta_status() {
  #Check if STA is connected to AP successuly under either dynamic or static mode
  local device=$1
  local sta_mode_conn_type=$(util_execute_uci get qcmap_wlan.@stamodeconfig[0].sta_mode_conn_type)
  local wlan_mode=$(util_execute_uci get qcmap_wlan.@wlanconfig[0].mode)

  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_STA_ONLY ]; then
    if [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
      #For dynamic STA mode, check ifconfig v4/v6 addr
      dhcp_sta_v4addr=`ifconfig $device | grep "inet addr"`
      dhcp_sta_v6addr=`ifconfig $device | grep "inet6 addr" | grep -v Link`
      if [ "$dhcp_sta_v4addr" != "" ] || [ "$dhcp_sta_v6addr" != "" ] ; then
        log  $(basename "$0") "get_sta_status" $LINENO "Get DYNAMIC STA Status Connected"
        util_execute_uci set qcmap_wlan.@stamodeconfig[0].status=$QCMAP_STA_CONNECTED
      else
        log  $(basename "$0") "get_sta_status" $LINENO "Get DYNAMIC STA Status Disconnected"
        util_execute_uci set qcmap_wlan.@stamodeconfig[0].status=$QCMAP_STA_DISCONNECTED
      fi
    elif [ $sta_mode_conn_type == $QCMAP_STA_CONNECTION_STATIC ] ; then
      #For static sta mode, check iw ssid info
      static_sta_ssid=`iw $device info | grep ssid`
      if [ "$static_sta_ssid" != "" ] ; then
        log  $(basename "$0") "get_sta_status" $LINENO "Get STATIC STA Status Connected"
        util_execute_uci set qcmap_wlan.@stamodeconfig[0].status=$QCMAP_STA_CONNECTED
      else
        log  $(basename "$0") "get_sta_status" $LINENO "Get STATIC STA Status Disconnected"
        util_execute_uci set qcmap_wlan.@stamodeconfig[0].status=$QCMAP_STA_DISCONNECTED
      fi
    fi
  else
    #NO STA configured
    log  $(basename "$0") "get_sta_status" $LINENO "Not under STA mode"
    util_execute_uci set qcmap_wlan.@stamodeconfig[0].status=$QCMAP_STA_DISCONNECTED
  fi

  util_execute_uci commit qcmap_wlan
}

function get_sta_associcated_status()
{
  local ifname=$(util_execute_uci get wireless.pdev0_STA.ifname)
  if_status=$(ifconfig | grep $ifname)
  static_sta_ssid=$(iw $device info | grep ssid)
  if [ -n "$if_status" ]; then
    if  [ -n "$static_sta_ssid" ]; then
       echo "1"
    else
       echo "0"
    fi
  else
    echo "0"
  fi
}



#GET supplicant state info to check if STA/AP+STA/AP+AP+STA mode is started or not
function get_supplicant_status() {
  #worst case 5s, one time 100ms
  local supplicant_start_max_retry=50
  local supplicant_start_delay_S=0.1
  local supplicant_pid_file
  local supplicant_pid=0
  local retry=0

  while [ $retry -lt $supplicant_start_max_retry ]
  do
    if [ $CDT_WLAN_WKK_ATTACH -eq $CDT_TYPE ]; then
      supplicant_pid_file=/tmp/run/wpad/wpa_supplicant-global.pid
    else
      supplicant_pid_file=/data/vendor/wifi/wpa_supplicant-wlan0.pid
    fi
    if [ -f $supplicant_pid_file ]; then
      supplicant_pid=`cat $supplicant_pid_file`
      echo "Supplicant running normal, Get wpa_supplicant.pid: $supplicant_pid"
      echo "Supplicant running normal, Get wpa_supplicant.pid: $supplicant_pid" > /dev/kmsg
      log  $(basename "$0") "get_supplicant_status" $LINENO " Supplicant start success, wpa_supplicant.pid: $supplicant_pid"

      ifconfig $sta_iface allmulti

      return
    fi

    retry=$(($retry+1))
    sleep $supplicant_start_delay_S
  done

  log  $(basename "$0") "get_supplicant_status" $LINENO " Supplicant start failed"
}