#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.
#  Usage: Restore Factory Config on OpenWRT

# Usage: restoreFactoryConfig.sh

if [[ "$#" -ne 0 ]]; then
  echo "Check usage ./restoreFactoryConfig.sh"
  return 1
fi

CDT_WLAN_WKK_ATTACH=3
CDT_TYPE=$(cat /sys/devices/soc0/platform_subtype_id)

config_dir='/etc/config/'
uci_dir='/etc/uci-defaults/'
factory_dir_suffix='/etc/data/factory/factory_'
config_files=""
config_files="$config_files qcmap_wlan"
config_files="$config_files qcmap_ezmesh"
config_files="$config_files qcmap_lan"
config_files="$config_files qcmap_firewall"
config_files="$config_files dhcp"
config_files="$config_files firewall"
config_files="$config_files network"
config_files="$config_files qcmap_gsb"
config_files="$config_files qcmap_current_lan_config"
config_files="$config_files upnpd"

#restore config files
for config_file in $config_files;
do
        rm $config_dir$config_file
        cp $factory_dir_suffix$config_file $config_dir$config_file
done

#restore uci default config files
cp ${factory_dir_suffix}qcmap_network_config ${uci_dir}qcmap_network_config

# restore the qcmap_wlan_current config as well
cp ${factory_dir_suffix}qcmap_wlan ${config_dir}qcmap_wlan_current

#restore wireless config file specific to target
rm ${config_dir}wireless
if [ $CDT_WLAN_WKK_ATTACH -eq $CDT_TYPE ]; then
	cp ${factory_dir_suffix}wireless_wkk ${config_dir}wireless
else
	cp ${factory_dir_suffix}wireless_hmt ${config_dir}wireless
fi

#send command to ipa for reset
ipa reset
