#!/bin/sh

# quec_update_lan_mtu.sh mtu
# mtu : 0 use default mtu 1500
# mtu : 1 use OTA mtu
# mtu : 46~9216

#source common functions
. /etc/data/mbbUtils.sh

# Ensure the script receives a single argument (mtu value)
if [ "$#" -ne 0 ]; then
    echo "Usage: $0 mtu_value"
    exit 1
fi

# Attempt to retrieve the 'update_mtu' value from UCI configuration
mtu=$(uci get qcmap_lan.@global[0].update_mtu 2>/dev/null)

# Check if the UCI entry exist
if [[ -z "$mtu" ]]; then
    mtu=-1
fi

# Perform actions based on the provided mtu value
case "$mtu" in
    1)
        # Configure MTU based on tmp file
	    [ -f /tmp/ipv4config1 ] && . /tmp/ipv4config1
        ip4mtu=$IPV4MTU

        [ -f /tmp/ipv6config1 ] && . /tmp/ipv6config1
        ip6mtu=$IPV6MTU

        # Check if ip4mtu is defined
        if [[ -z ${ip4mtu+x} ]]; then
            # ip4mtu is not defined; check if ip6mtu is defined
            if [[ -z ${ip6mtu+x} ]]; then
                # ip6mtu is also not defined; use the default MTU
                val=1500
                log $(basename "$0") "update_lan_mtu" $LINENO "no backhaul,Configuring MTU to 1500..."
            else
                val=$ip6mtu
                log $(basename "$0") "update_lan_mtu" $LINENO "no v4 backhaul,Configuring MTU to ip6mtu..."
            fi
        else
            val=$ip4mtu
            log $(basename "$0") "update_lan_mtu" $LINENO "v4 backhaul exists,Configuring MTU to ip4mtu..."
        fi
        log $(basename "$0") "update_lan_mtu" $LINENO "Configuring MTU to $val..."        
        uci set network.lan.mtu=$val
        uci set network.eth.mtu=$val
        uci set network.eth_nic2.mtu=$val
        uci set network.rndis.mtu=$val
        uci set network.ecm.mtu=$val
        uci commit
        /etc/init.d/network restart
        ;;
    0)
        # Configure MTU to 1500
        log $(basename "$0") "update_lan_mtu" $LINENO "Configuring MTU to 1500..."
        # Replace with actual command to set MTU, e.g., `ip link set dev eth0 mtu 1500`
        uci set network.lan.mtu=1500
        uci set network.eth.mtu=1500
        uci set network.eth_nic2.mtu=1500
        uci set network.rndis.mtu=1500
        uci set network.ecm.mtu=1500
        uci del qcmap_lan.@global[0].update_mtu
        uci commit
        /etc/init.d/network restart
        ;;
    -1)
        log $(basename "$0") "update_lan_mtu" $LINENO "global mtu_update not exist,skip"
        ;;
    *)
        # Check if mtu is within the valid range (46 <= mtu <= 9216)
        if (( mtu < 46 || mtu > 9216 )); then
            log $(basename "$0") "update_lan_mtu" $LINENO "Error: MTU must be between 46 and 9216..."
            echo "Error: MTU must be between 46 and 9216."
            exit 1
        fi
        log $(basename "$0") "update_lan_mtu" $LINENO "Configuring MTU to $mtu ..."
        uci set network.lan.mtu=$mtu
        uci set network.eth.mtu=$mtu
        uci set network.eth_nic2.mtu=$mtu
        uci set network.rndis.mtu=$mtu
        uci set network.ecm.mtu=$mtu
        uci commit
        /etc/init.d/network restart
        ;;
esac

exit 0