#!/bin/sh

# Copyright (c) 2023 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.

ping_log="/tmp/mtpe_ping.log"
tmp_logs="/tmp/mtpe_data.log$2"
output_logs="/tmp/mtpe_iperf.log$2"

rm "$ping_log" "$tmp_logs" "$output_logs"

# RTT Measurement
if [ "$1" == "0" ] ; then
  ping -c"$2" "$3" | tail -n1 | awk '{printf "%s %s\n", $4,$5}' |  sed -r 's/.*\/(.*)\/.*\ /\1 /' > "$ping_log"

# Client TCP Throughput Test (IPv4/IPv6 specified in option 5)
elif [ "$1" == "1" ] ; then
  iperf3 -$5 -p$2 -t$3 -P$6 -c$4 | grep sender > "$tmp_logs"

  line_count=$(wc -l < "$tmp_logs")
  if [ "$line_count" -eq 1 ]; then
    cat "$tmp_logs" | awk '{printf "%s %s\n", $7,$8}' > "$output_logs"
  else
    cat "$tmp_logs" | grep SUM | awk '{printf "%s %s\n", $6,$7}' > "$output_logs"
  fi

# Server TCP Throughput Test (IPv4/IPv6 specified in option 5)
elif [ "$1" == "2" ] ; then
  iperf3 -1 -$5 -p$2 -B$4 -s | grep receiver > "$tmp_logs"

  line_count=$(wc -l < "$tmp_logs")
  if [ "$line_count" -eq 1 ]; then
    cat "$tmp_logs" | awk '{printf "%s %s\n", $7,$8}' > "$output_logs"
  else
    cat "$tmp_logs" | grep SUM | awk '{printf "%s %s\n", $6,$7}' > "$output_logs"
  fi

else
  echo "invalid arguments" > "$ping_log"
  echo "invalid arguments" > "$output_logs"
fi
