#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

#source log file
# Usage to use log function
# log  $(basename "$0") $LINENO "Log message"
. /etc/data/mbbUtils.sh
. /etc/data/lanUtils.sh

QCMAP_STA_CONNECTION_DYNAMIC=1
QCMAP_STA_CONNECTION_STATIC=2

QCMAP_WLAN_MODE_AP=1
QCMAP_WLAN_MODE_AP_AP=2
QCMAP_WLAN_MODE_AP_STA=3
QCMAP_WLAN_MODE_AP_AP_AP=4
QCMAP_WLAN_MODE_AP_AP_STA=5
QCMAP_WLAN_MODE_STA_ONLY=6
QCMAP_WLAN_MODE_AP_AP_AP_AP=7

function enable_dhcp_proxy() {

  local bh=$1
  local sta_mode=$(uci get qcmap_wlan.@stamodeconfig[0].sta_mode_conn_type)

  #avoid duplicate work
  local current_dhcp_proxy=$(uci get dhcp.lan.dhcp_proxy)
  if [ $current_dhcp_proxy == 1 ]; then
    return
  fi

  util_execute_uci set dhcp.lan.ignore='1'
  util_execute_uci add dhcp relay
  util_execute_uci set dhcp.@relay[-1].interface="lan"
  util_execute_uci set dhcp.@relay[-1].dhcp_proxy='1'
  util_execute_uci set dhcp.lan.dhcp_proxy='1'

  #enable odhcpd relay mode
  util_execute_uci set dhcp.lan.dhcpv6='relay'
  util_execute_uci set dhcp.lan.ra='relay'
  util_execute_uci set dhcp.lan_v6="dhcp"
  util_execute_uci set dhcp.lan_v6.ndp='relay'
  util_execute_uci set dhcp.lan_v6.ra='relay'
  util_execute_uci set dhcp.lan_v6.sta_bridge_mode='1'
  #enable odhcpd debug log
  #util_execute_uci set dhcp.odhcpd.loglevel='7'

  if [ $sta_mode == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
    util_execute_uci set dhcp.@relay[-1].local_addr=$(ifstatus lan | grep "\"address\":" | awk -F: '{print $2}' | awk -F\" '{print $2'})
    util_execute_uci set dhcp.@relay[-1].server_addr=$(ifstatus lan | grep "\""nexthop"\":" | awk -F: '{print $2}' | awk -F\" '{print $2'})
  elif [ $sta_mode == $QCMAP_STA_CONNECTION_STATIC ] ; then
    util_execute_uci set dhcp.@relay[-1].local_addr=$(uci get qcmap_wlan.@stamodeconfig[0].ipaddr)
    util_execute_uci set dhcp.@relay[-1].server_addr=$(uci get qcmap_wlan.@stamodeconfig[0].gateway)
  fi

  util_execute_uci commit dhcp
  /etc/init.d/dnsmasq reload
  /etc/init.d/odhcpd reload

  add_ipv4_ebtables_rules $bh
  add_ipv6_ebtable_rules

  log  $(basename "$0") "enable_dhcp_proxy" $LINENO "enable_dhcp_proxy done !!!"
}

function disable_dhcp_proxy() {

  local current_dhcp_proxy=$(uci get dhcp.lan.dhcp_proxy)
  if [ $current_dhcp_proxy == 1 ]; then
    util_execute_uci set dhcp.lan.ignore='0'
    util_execute_uci set dhcp.lan.dhcp_proxy='0'
    util_execute_uci delete dhcp.@relay[-1]

    #recover dhcp configuration
    util_execute_uci set dhcp.lan.dhcpv6='server'
    util_execute_uci set dhcp.lan.ra='server'
    util_execute_uci delete dhcp.lan_v6

    util_execute_uci commit dhcp
    /etc/init.d/dnsmasq reload
    /etc/init.d/odhcpd reload

    delete_ipv6_ebtable_rules
    log  $(basename "$0") "disable_dhcp_proxy" $LINENO "disable_dhcp_proxy done !!!"
  fi
}



function add_ipv4_ebtables_rules() {

  local bh=$1
  local wlan_mode=$(uci get qcmap_wlan.@wlanconfig[0].mode)
  local sta_iface=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)
  local ap_iface=$(uci get qcmap_wlan.@primaryap[0].staifname)
  local ap_ap_iface=$(uci get qcmap_wlan.@guestap[0].staifname)
  local sta_mode=$(uci get qcmap_wlan.@stamodeconfig[0].sta_mode_conn_type)

# rule to ensure DHCP-ARP DAD works fine
  ebtables -t nat -I PREROUTING -p arp --arp-ip-src=0.0.0.0 --arp-opcode Request -j ACCEPT
# rule to ensure we dont reply to gratitious ARP requests
  ebtables -t nat -I PREROUTING -p arp --arp-opcode Request --arp-gratuitous -j ACCEPT
# rules to ensure all arp-requests are replied by Bridge and not forwarded
  ebtables -t filter -A FORWARD -i $sta_iface -p ARP -j DROP
  ebtables -t filter -A FORWARD -o $sta_iface -p ARP -j DROP

  if [ $sta_mode == $QCMAP_STA_CONNECTION_DYNAMIC ] ; then
    file=/tmp/ipv4config.$bh
    ap_sta_bridge_gw=`awk -F "=" 'FNR == 5 {print $2}' $file | tr -d '"'`
    ap_sta_bridge_netmask=`awk -F "=" 'FNR == 3 {print $2}' $file | tr -d '"'`
  elif [ $sta_mode == $QCMAP_STA_CONNECTION_STATIC ] ; then
    ap_sta_bridge_gw=$(uci get qcmap_wlan.@stamodeconfig[0].gateway)
    ap_sta_bridge_netmask=$(uci get qcmap_wlan.@stamodeconfig[0].netmask)
  fi
  ap_sta_bridge_mac=`ifconfig $sta_iface | grep HWaddr | awk -F' ' '{print $5}'`

# default Subnet Based ARP Reply Rules for WLAN and tethered (USB/ETH) Interfaces
  if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_STA ] || [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] ; then
    ebtables -t nat -A PREROUTING -i $ap_iface -p arp --arp-ip-src=$ap_sta_bridge_gw/$ap_sta_bridge_netmask --arp-opcode Request -j arpreply --arpreply-mac $ap_sta_bridge_mac --arpreply-target ACCEPT
    if [ $wlan_mode == $QCMAP_WLAN_MODE_AP_AP_STA ] ; then
      ebtables -t nat -A PREROUTING -i $ap_ap_iface -p arp --arp-ip-src=$ap_sta_bridge_gw/$ap_sta_bridge_netmask --arp-opcode Request -j arpreply --arpreply-mac $ap_sta_bridge_mac --arpreply-target ACCEPT
    fi
  fi

  if_list=$(uci get network.lan.ifname)
  if [ ! -z "$if_list" ]; then
    for list_member in $if_list
    do
      if [ $list_member != "wlan1" ]; then
        check_port=$(brctl show | grep $list_member)
        if [ ! -z "$check_port" ]; then
          ebtables -t nat -A PREROUTING -i $list_member -p arp --arp-ip-src=$ap_sta_bridge_gw/$ap_sta_bridge_netmask --arp-opcode Request -j arpreply --arpreply-mac $ap_sta_bridge_mac --arpreply-target ACCEPT
        fi
      fi
    done
  else
    $(basename "$0")":add_ipv4_ebtables_rules:"$LINENO":get network.@device[0].ports failed: $if_list"
  fi
}

function add_ipv6_ebtable_rules() {

  delete_ipv6_ebtable_rules
  local sta_iface=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)

  ip6tables -t filter -A FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
  ip6tables -t filter -A FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
  ip6tables -t filter -A FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP
  ip6tables -t filter -A FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP

  ebtables -t filter -A FORWARD -o $sta_iface -p ip6 --ip6-protocol ipv6-icmp --ip6-icmp-type 135:136 -j DROP
  ebtables -t filter -A FORWARD -i $sta_iface -p ip6 --ip6-protocol ipv6-icmp --ip6-icmp-type 135:136 -j DROP

# Drop all redirect messages
  ip6tables -t filter -A OUTPUT -p ipv6-icmp -m icmp6 --icmpv6-type 137 -j DROP
}

function delete_ipv6_ebtable_rules() {

  local sta_iface=$(uci get qcmap_wlan.@stamodeconfig[0].ifname)

  ip6tables -t filter -D FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
  ip6tables -t filter -D FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 135 -j DROP
  ip6tables -t filter -D FORWARD -o $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP
  ip6tables -t filter -D FORWARD -i $sta_iface -p ipv6-icmp -m icmp6 --icmpv6-type 136 -j DROP

  ebtables -t filter -D FORWARD -o $sta_iface -p ip6 --ip6-protocol ipv6-icmp --ip6-icmp-type 135:136 -j DROP
  ebtables -t filter -D FORWARD -i $sta_iface -p ip6 --ip6-protocol ipv6-icmp --ip6-icmp-type 135:136 -j DROP

# Drop all redirect messages
  ip6tables -t filter -D OUTPUT -p ipv6-icmp -m icmp6 --icmpv6-type 137 -j DROP
}


case $1 in
  enable_dhcp_proxy)
    log  $(basename "$0") "case:enable_dhcp_proxy" $LINENO "enable_dhcp_proxy"
    enable_dhcp_proxy $2
    ;;

  disable_dhcp_proxy)
    log  $(basename "$0") "case:disable_dhcp_proxy" $LINENO "disable_dhcp_proxy"
    disable_dhcp_proxy
    ;;

  *)
    log  $(basename "$0") "case: Invalid" $LINENO "Invalid option"
    ;;

esac

