#!/bin/sh

# Copyright (c) 2023 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.

#source common functions
. /etc/data/mbbUtils.sh
. /etc/data/lanUtils.sh

DHCP_OPT_TZ=0
DHCP_OPT_VENDER_INFO=1
UCI_ADD_LIST=0
UCI_DEL_LIST=1
DNMASQ_CONF_FILE=/var/etc/dnsmasq.conf.lan_dns

# For dhcp_options feature,execute uci cmd and reload dnsmasq
if [ "$1" == $DHCP_OPT_TZ ] ; then
#For DHCP_OPTION_TZ, need to handle separatly for 100/101
  if [ "$2" == $UCI_ADD_LIST ] ; then
    util_execute_uci set qcmap_lan.@dhcp_option[0].dhcp_tz_100=$3
    util_execute_uci set qcmap_lan.@dhcp_option[0].dhcp_tz_101=$4
    util_execute_uci add_list dhcp.lan.dhcp_option_force=100,$3
    util_execute_uci add_list dhcp.lan.dhcp_option_force=101,$4
    log  $(basename "$0") "dhcp_option" $LINENO "Set dhcp_option_force 100/101 for TZ done"
  elif [ "$2" == $UCI_DEL_LIST ] ; then
    option_100=`util_execute_uci get qcmap_lan.@dhcp_option[0].dhcp_tz_100`
    option_101=`util_execute_uci get qcmap_lan.@dhcp_option[0].dhcp_tz_101`
    log  $(basename "$0") "dhcp_option" $LINENO "DHCP option 100: $option_100; option 101: $option_101"
    util_execute_uci -q del_list dhcp.lan.dhcp_option_force=100,$option_100
    util_execute_uci -q del_list dhcp.lan.dhcp_option_force=101,$option_101
    util_execute_uci -q delete qcmap_lan.@dhcp_option[0].dhcp_tz_100
    util_execute_uci -q delete qcmap_lan.@dhcp_option[0].dhcp_tz_101
    log  $(basename "$0") "dhcp_option" $LINENO "Delete dhcp_option_force 100/101 for TZ done"
  fi
elif [ "$1" == $DHCP_OPT_VENDER_INFO ] ; then
#For DHCP_OPTION_VENDER_INFO 43/60
  if [ "$2" == $UCI_ADD_LIST ] ; then
    util_execute_uci set qcmap_lan.@dhcp_option[0].dhcp_vsi=$3
    util_execute_uci add_list dhcp.lan.dhcp_option_force=$3
    log  $(basename "$0") "dhcp_option" $LINENO "Set dhcp_option_force 43/60 for VENDER_INFO done"
  elif [ "$2" == $UCI_DEL_LIST ] ; then
    option_vendor=`util_execute_uci get qcmap_lan.@dhcp_option[0].dhcp_vsi`
    log  $(basename "$0") "dhcp_option" $LINENO "DHCP option vendor info: $option_vendor"
    util_execute_uci -q del_list dhcp.lan.dhcp_option_force=$option_vendor
    util_execute_uci -q delete qcmap_lan.@dhcp_option[0].dhcp_vsi
    log  $(basename "$0") "dhcp_option" $LINENO "Delete dhcp_option_force 43/60 for VENDER_INFO done"
  fi
fi

util_execute_uci commit dhcp
util_execute_uci commit qcmap_lan

/etc/init.d/dnsmasq reload
log  $(basename "$0") "dhcp_option" $LINENO "Dnsmasq reload"