#!/bin/sh
#  Copyright (c) 2023 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.

[ -z "$1" ] && echo "No event provided" && return 1

function eth_pdu_mode_enable() {
    local default_ifname
    local eth_idx=$1
    echo $(basename "$0")":eth_pdu_mode_enable():"$LINENO":eth pdu mode set to enable."
    #Save the exisiting default lan ifname
    default_ifname=$(uci get network.lan.ifname)
    uci set qcmap_lan.@eth_pdu[0].default_ifname="$default_ifname"
    uci set network.lan.ifname=eth$eth_idx
    uci delete network.lan.ipaddr
    uci delete network.lan.netmask

    if [ $eth_idx -eq 0 ]; then
      uci delete network.eth.ipaddr
      uci delete network.eth.netmask
      uci delete network.eth_nic2
    fi

    if [ $eth_idx -eq 1 ]; then
      uci delete network.eth_nic2.ipaddr
      uci delete network.eth_nic2.netmask
      uci delete network.eth
    fi

    uci set network.dummy=interface
    uci set network.dummy.device=eth$eth_idx
    uci set network.lan.vlan_filtering=1
    uci commit network
    #configure qcmap_lan
    uci set qcmap_lan.@eth_pdu[0].enable=1
    uci set qcmap_lan.@eth_pdu[0].eth_device_index=$eth_idx
    uci commit qcmap_lan
    sleep 5
    reboot
}

function eth_pdu_mode_disable() {
    local default_ifname
    echo $(basename "$0")":eth_pdu_mode_disable():"$LINENO":eth pdu mode set to disable."
    #get default ifname.
    default_ifname=$(uci get qcmap_lan.@eth_pdu[0].default_ifname)
    uci set network.lan.ifname="$default_ifname"
    uci set network.lan.ipaddr=192.168.224.1
    uci set network.lan.netmask=255.255.254.0
    uci set network.eth=interface
    uci set network.eth.device=eth0
    uci set network.eth.proto=static
    uci set network.eth.ipv6="1"
    uci set network.eth.ipaddr=169.254.22.1
    uci set network.eth.netmask=255.255.255.0
    uci set network.eth_nic2=interface
    uci set network.eth_nic2.device=eth1
    uci set network.eth_nic2.proto=static
    uci set network.eth_nic2.ipv6="1"
    uci set network.eth_nic2.ipaddr=169.254.23.1
    uci set network.eth_nic2.netmask=255.255.255.0
    uci delete network.lan.vlan_filtering
    uci delete network.dummy
    uci commit network
    #configure qcmap_lan
    uci set qcmap_lan.@eth_pdu[0].enable=0
    uci set qcmap_lan.@eth_pdu[0].eth_device_index=$1
    uci commit qcmap_lan
    sleep 5
    reboot
}

function eth_pdu_bootup_cfg() {
    echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":bootup configure."
    #0.1 set pvid value to be 0 for all bridge interfaces as WA for WKK VLAN tag issue.
    echo   0 > /sys/class/net/br-lan/bridge/default_pvid
    #0.2 set pvid value to all vlan bridges
    max=$(uci get qcmap_lan.@no_of_configs[0].no_of_vlans)
    echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":total vlan bridges: $max."
    if [ $max -gt 0 ]; then
        for i in $(seq $max)
        do
            vlan_id=$(uci get qcmap_lan.@vlan[$((i-1))].vlan_id)
            echo   0 > /sys/class/net/br-lan$vlan_id/bridge/default_pvid
            echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":config default pvid value for vlan id: $vlan_id."
        done
    fi

    #1. get totoal number of bridge-vlan and delete them
    total_br_vlan_info_num=$(grep bridge-vlan /etc/config/network | wc -l)
    echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":total vlan info in network: $total_br_vlan_info_num."
    if [ $total_br_vlan_info_num -gt 0 ];then
        for i in $(seq 0 $((total_br_vlan_info_num-1)))
        do
            echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":delete vlan info"
            uci delete network.@bridge-vlan[-1]
        done
    fi
    uci commit network
    ubus call network reload
    #2. get total number of call info and delete the info from network
    CallNum=$(grep EthPduCallInfo /etc/config/qcmap_lan | wc -l)
    EthDeviceIndex=$(uci get qcmap_lan.@eth_pdu[0].eth_device_index)
    EthPduMode=$(uci get qcmap_lan.@eth_pdu[0].enable)
    echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":total call number in qcmap_lan: $CallNum.eth pdu mode:$EthPduMode,device index:$EthDeviceIndex."
    if [ $CallNum -gt 0 ];then
        for j in $(seq 0 $((CallNum-1)))
        do
            profileiHandle=$(uci get qcmap_lan.@EthPduCallInfo[$j].profile)
            EthPduIfname=$(uci get qcmap_lan.@EthPduCallInfo[$j].EthPduIfName)
            echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":get profile: $profileiHandle, ifname: $EthPduIfname from in call info at index: $j"
            #delete device rmnet_ethX from wanX interface
            uci delete network.wan"$profileiHandle".device
        done
    fi

    # No need to set the network lan config as it will be updated as part of disable/enable ETH PDU
    #eth pdu mode disable case,set default ifname
    #if [ $EthPduMode -eq 0 ]; then
    #  uci set network.lan.ifname='eth0 eth1 ecm0 rndis0'
    #fi

    #eth pdu mode enable case,set ifname per device index
    if [ $EthPduMode -eq 1 ]; then
      uci set network.lan.ifname=eth$EthDeviceIndex
    fi

    uci commit network
    ubus call network reload

    if [ $CallNum -gt 0 ];then
        for k in $(seq 0 $((CallNum-1)))
        do
            echo $(basename "$0")":eth_pdu_bootup_cfg():"$LINENO":delete call info from qcmap_lan at index: $k"
            uci delete qcmap_lan.@EthPduCallInfo[-1]
        done
        uci commit qcmap_lan
    fi
}

case "$1" in
    enable)
      eth_pdu_mode_enable $2
    ;;
    disable)
      eth_pdu_mode_disable $2
    ;;
    ethpdu_bootup_cfg)
      eth_pdu_bootup_cfg
    ;;
    *)
    echo "Invalid option"
    ;;
esac
